/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.eclemma.core.EclEmmaStatus;
import org.eclipse.eclemma.core.ICorePreferences;
import org.eclipse.eclemma.core.ISessionManager;
import org.eclipse.eclemma.internal.core.ExecutionDataFiles;
import org.eclipse.eclemma.internal.core.JavaCoverageLoader;
import org.eclipse.eclemma.internal.core.SessionManager;
import org.eclipse.eclemma.internal.core.launching.CoverageLaunch;
import org.osgi.framework.BundleContext;

public class EclEmmaCorePlugin
extends Plugin {
    public static final String ID = "org.eclipse.eclemma.core";
    private static final IStatus PROMPT_STATUS = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    private static EclEmmaCorePlugin instance;
    private ICorePreferences preferences = ICorePreferences.DEFAULT;
    private ISessionManager sessionManager;
    private JavaCoverageLoader coverageLoader;
    private ExecutionDataFiles executionDataFiles;
    private ILaunchListener launchListener = new ILaunchListener(){

        public void launchRemoved(ILaunch launch) {
            if (EclEmmaCorePlugin.this.preferences.getAutoRemoveSessions()) {
                EclEmmaCorePlugin.this.sessionManager.removeSessionsFor(launch);
            }
        }

        public void launchAdded(ILaunch launch) {
        }

        public void launchChanged(ILaunch launch) {
        }
    };
    private IDebugEventSetListener debugListener = new IDebugEventSetListener(){

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess proc;
                ILaunch launch;
                DebugEvent e = debugEventArray[n2];
                if (e.getSource() instanceof IProcess && e.getKind() == 8 && (launch = (proc = (IProcess)e.getSource()).getLaunch()) instanceof CoverageLaunch) {
                    CoverageLaunch coverageLaunch = (CoverageLaunch)launch;
                    coverageLaunch.getAgentServer().stop();
                    this.checkExecutionData(coverageLaunch);
                }
                ++n2;
            }
        }

        private void checkExecutionData(CoverageLaunch launch) {
            if (!launch.getAgentServer().hasDataReceived()) {
                try {
                    EclEmmaCorePlugin.this.showPrompt(EclEmmaStatus.NO_COVERAGE_DATA_ERROR.getStatus(), launch);
                }
                catch (CoreException e) {
                    EclEmmaCorePlugin.this.getLog().log(e.getStatus());
                }
            }
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.executionDataFiles = new ExecutionDataFiles(this.getStateLocation());
        this.executionDataFiles.deleteTemporaryFiles();
        this.sessionManager = new SessionManager(this.executionDataFiles);
        this.coverageLoader = new JavaCoverageLoader(this.sessionManager);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.launchListener);
        DebugPlugin.getDefault().addDebugEventListener(this.debugListener);
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        this.executionDataFiles.deleteTemporaryFiles();
        DebugPlugin.getDefault().removeDebugEventListener(this.debugListener);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.launchListener);
        this.executionDataFiles = null;
        this.coverageLoader.dispose();
        this.coverageLoader = null;
        this.sessionManager = null;
        super.stop(context);
    }

    public static EclEmmaCorePlugin getInstance() {
        return instance;
    }

    public void setPreferences(ICorePreferences preferences) {
        this.preferences = preferences;
    }

    public ICorePreferences getPreferences() {
        return this.preferences;
    }

    public ISessionManager getSessionManager() {
        return this.sessionManager;
    }

    public JavaCoverageLoader getJavaCoverageLoader() {
        return this.coverageLoader;
    }

    public ExecutionDataFiles getExecutionDataFiles() {
        return this.executionDataFiles;
    }

    private boolean showPrompt(IStatus status, Object info) throws CoreException {
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(PROMPT_STATUS);
        if (prompter == null) {
            if (status.getSeverity() == 4) {
                throw new CoreException(status);
            }
            return true;
        }
        return (Boolean)prompter.handleStatus(status, info);
    }
}

