/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.JarArchive;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.api.deployment.archive.WritableArchiveEntry;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="jar")
@PerLookup
public class OutputJarArchive
extends JarArchive
implements WritableArchive {
    private static final System.Logger LOG = System.getLogger(OutputJarArchive.class.getName());
    private URI uri;
    private ZipOutputStream jos;
    private Manifest manifest;
    private final Vector<String> entries = new Vector();

    public long getArchiveSize() throws NullPointerException, SecurityException {
        return -1L;
    }

    public void close() throws IOException {
        if (this.jos != null) {
            LOG.log(System.Logger.Level.DEBUG, "close()");
            this.jos.close();
            this.jos = null;
        }
    }

    @Override
    protected JarEntry getJarEntry(String entryName) {
        return null;
    }

    public void create(URI path) throws IOException {
        LOG.log(System.Logger.Level.DEBUG, "create(path={0})", path);
        this.uri = path;
        File file = new File(this.uri.getSchemeSpecificPart());
        if (file.exists() && !file.delete()) {
            LOG.log(System.Logger.Level.WARNING, "Could not delete the file {0}", file);
        }
        this.jos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public Enumeration<String> entries() {
        return this.entries.elements();
    }

    public Collection<String> getDirectories() throws IOException {
        return new Vector<String>();
    }

    public Manifest getManifest() throws IOException {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        return this.manifest;
    }

    public URI getURI() {
        return this.uri;
    }

    public WritableArchive createSubArchive(String name) throws IOException {
        LOG.log(System.Logger.Level.DEBUG, "createSubArchive(name={0})", name);
        this.checkOpen("Could not create subarchive {0}, because the output archive {1} is already closed.", name, this.getName());
        ZipOutputStream zip = new ZipOutputStream((OutputStream)this.putNextEntry(name));
        OutputJarArchive jar = new OutputJarArchive();
        try {
            jar.uri = new URI("jar", name, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create a subarchive for name " + name, e);
        }
        jar.jos = zip;
        return jar;
    }

    public WritableArchiveEntry putNextEntry(String name) throws IOException {
        LOG.log(System.Logger.Level.DEBUG, "putNextEntry(name={0})", name);
        this.checkOpen("Could not put next entry {0}, because the output archive {1} is already closed.", name, this.getName());
        ZipEntry ze = new ZipEntry(name);
        this.jos.putNextEntry(ze);
        this.entries.add(name);
        return new WritableArchiveEntry(this::getZipOutputStream, this::closeEntry);
    }

    private void closeEntry() throws IOException {
        LOG.log(System.Logger.Level.DEBUG, "closeEntry({0})", this.entries.get(this.entries.size() - 1));
        this.checkOpen("The zip output stream to {0} is already closed.", this.getName());
        this.jos.flush();
        this.jos.closeEntry();
    }

    private ZipOutputStream getZipOutputStream() {
        this.checkOpen("The zip output stream to {0} is already closed.", this.getName());
        return this.jos;
    }

    private void checkOpen(String message, Object ... args) {
        if (this.jos == null) {
            throw new IllegalStateException(MessageFormat.format(message, args));
        }
    }
}

