/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsft.component;

import com.sun.jsft.component.FragmentReadyEvent;
import com.sun.jsft.component.FragmentRenderer;
import com.sun.jsft.tasks.Task;
import com.sun.jsft.tasks.TaskEvent;
import com.sun.jsft.tasks.TaskManager;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIOutput;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class DeferredFragment
extends UIComponentBase {
    public static final String FAMILY = DeferredFragment.class.getName();
    private int taskCount = 1;
    private transient String placeHolderId = "";
    private List<ComponentSystemEventListener> listeners = new ArrayList<ComponentSystemEventListener>(2);

    public DeferredFragment() {
        this.subscribeToEvent(PostAddToViewEvent.class, new AfterCreateListener());
    }

    public String getFamily() {
        return FAMILY;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        System.out.println("Encode Begin (" + this.getId() + ")...");
    }

    public void encodeEnd(FacesContext context) throws IOException {
        System.out.println("Encode End (" + this.getId() + ")...");
    }

    private boolean isReady() {
        return this.taskCount == 0;
    }

    public String getPlaceHolderId() {
        return this.placeHolderId;
    }

    public void setPlaceHolderId(String id) {
        this.placeHolderId = id;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(int count) {
        this.taskCount = count;
    }

    public void addReadyListener(ComponentSystemEventListener listener) {
        this.listeners.add(listener);
    }

    protected void fireFragmentReadyEvent() {
        FragmentReadyEvent event = new FragmentReadyEvent(this);
        System.out.println("listeners" + String.valueOf(this.listeners));
        for (ComponentSystemEventListener listener : this.listeners) {
            listener.processEvent((ComponentSystemEvent)event);
        }
    }

    public static class AfterCreateListener
    implements ComponentSystemEventListener {
        private boolean done = false;
        private static final String FRAGMENT_RENDERER = "jsft-FR";

        AfterCreateListener() {
        }

        public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
            if (this.done) {
                return;
            }
            this.done = true;
            DeferredFragment comp = (DeferredFragment)event.getComponent();
            FacesContext ctx = FacesContext.getCurrentInstance();
            UIViewRoot viewRoot = ctx.getViewRoot();
            Map facetMap = viewRoot.getFacets();
            String key = "jsft_" + comp.getClientId(ctx);
            UIOutput placeHolder = new UIOutput();
            placeHolder.getAttributes().put("value", "<span id='" + key + "'></span>");
            List peers = comp.getParent().getChildren();
            int index = peers.indexOf((Object)comp);
            peers.set(index, placeHolder);
            comp.setPlaceHolderId(placeHolder.getClientId(ctx));
            facetMap.put(key, comp);
            String task = (String)comp.getAttributes().get("task");
            StringTokenizer tok = new StringTokenizer(task, ";");
            TaskManager tm = TaskManager.getInstance();
            int taskCount = 0;
            while (tok.hasMoreTokens()) {
                task = tok.nextToken().trim();
                int idx = task.indexOf(":");
                String type = null;
                if (idx != -1) {
                    type = task.substring(idx + 1);
                    task = task.substring(0, idx);
                }
                tm.addTask(task, type, new DeferredFragmentTaskListener(comp));
                ++taskCount;
            }
            comp.setTaskCount(taskCount);
            Map requestScope = ctx.getExternalContext().getRequestMap();
            FragmentRenderer fragmentRenderer = (FragmentRenderer)((Object)requestScope.get(FRAGMENT_RENDERER));
            if (fragmentRenderer == null) {
                fragmentRenderer = new FragmentRenderer();
                fragmentRenderer.setId(FRAGMENT_RENDERER);
                viewRoot.getChildren().add(fragmentRenderer);
                requestScope.put(FRAGMENT_RENDERER, fragmentRenderer);
            }
            fragmentRenderer.addDeferredFragment(comp);
            comp.addReadyListener(fragmentRenderer);
        }
    }

    public static class DeferredFragmentTaskListener
    implements SystemEventListener {
        private DeferredFragment df = null;

        public DeferredFragmentTaskListener(DeferredFragment df) {
            this.df = df;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processEvent(SystemEvent event) throws AbortProcessingException {
            System.out.println("DeferredFragmentTaskListener.processEvent()!");
            Task task = (Task)event.getSource();
            String eventType = ((TaskEvent)event).getType();
            int count = 0;
            DeferredFragment deferredFragment = this.df;
            synchronized (deferredFragment) {
                count = this.df.getTaskCount() - 1;
                this.df.setTaskCount(count);
            }
            if (count == 0) {
                this.df.fireFragmentReadyEvent();
            }
        }

        public boolean isListenerForSource(Object source) {
            return true;
        }
    }
}

