/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.glassfish.main.jul.cfg.LogProperty;
import org.glassfish.main.jul.env.LoggingSystemEnvironment;
import org.glassfish.main.jul.formatter.OneLineFormatter;
import org.glassfish.main.jul.handler.HandlerConfigurationHelper;

public class SimpleLogHandler
extends StreamHandler {
    public SimpleLogHandler() {
        HandlerConfigurationHelper helper = HandlerConfigurationHelper.forHandlerClass(this.getClass());
        PrintStream outputStream = helper.getBoolean(SimpleLogHandlerProperty.USE_ERROR_STREAM, true) != false ? LoggingSystemEnvironment.getOriginalStdErr() : LoggingSystemEnvironment.getOriginalStdOut();
        this.setOutputStream(new UncloseablePrintStream(outputStream, helper.getCharset(SimpleLogHandlerProperty.ENCODING, Charset.defaultCharset())));
        this.setFormatter(helper.getFormatter(OneLineFormatter.class));
    }

    public SimpleLogHandler(PrintStream printStream) {
        super(printStream, new OneLineFormatter());
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    @Override
    public void close() {
        this.flush();
    }

    public static enum SimpleLogHandlerProperty implements LogProperty
    {
        USE_ERROR_STREAM("useErrorStream"),
        FORMATTER(HandlerConfigurationHelper.FORMATTER.getPropertyName()),
        LEVEL("level"),
        FILTER("filter"),
        ENCODING("encoding");

        private final String propertyName;

        private SimpleLogHandlerProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyFullName() {
            return this.getPropertyFullName(SimpleLogHandler.class);
        }
    }

    private static final class UncloseablePrintStream
    extends PrintStream {
        private UncloseablePrintStream(PrintStream out, Charset encoding) {
            super((OutputStream)out, false, encoding);
        }

        @Override
        public void close() {
        }
    }
}

