/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.core;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.InputStream;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.FlashlightLoggerInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class ProviderSubClassImplGenerator {
    private static final Logger logger = FlashlightLoggerInfo.getLogger();
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ProviderSubClassImplGenerator.class);
    private String invokerId;
    private Class providerClazz;
    private static AtomicInteger counter = new AtomicInteger();

    public ProviderSubClassImplGenerator(Class providerClazz, String invokerId) {
        this.providerClazz = providerClazz;
        this.invokerId = invokerId;
    }

    public <T> Class<T> generateAndDefineClass(Class<T> providerClazz, String invokerId) {
        int id = counter.incrementAndGet();
        String providerClassName = providerClazz.getName().replace('.', '/');
        String generatedClassName = providerClassName + invokerId + "_" + id;
        byte[] provClassData = null;
        try {
            InputStream is = providerClazz.getClassLoader().getResourceAsStream(providerClassName + ".class");
            int sz = is.available();
            provClassData = new byte[sz];
            int index = 0;
            while (index < sz) {
                int r = is.read(provClassData, index, sz - index);
                if (r <= 0) continue;
                index += r;
            }
        }
        catch (Exception ex) {
            return null;
        }
        ClassReader cr = new ClassReader(provClassData);
        ClassWriter cw = new ClassWriter(3);
        byte[] classData = null;
        ProbeProviderSubClassGenerator sgen = new ProbeProviderSubClassGenerator((ClassVisitor)cw, invokerId, "_" + id);
        cr.accept((ClassVisitor)sgen, 0);
        classData = cw.toByteArray();
        ProtectionDomain pd = providerClazz.getProtectionDomain();
        SubClassLoader scl = this.createSubClassLoader(providerClazz);
        if (scl == null) {
            return null;
        }
        try {
            String gcName = scl.defineClass(generatedClassName, classData, pd);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("**** DEFINE CLASS SUCCEEDED for " + gcName + "," + generatedClassName);
            }
            return scl.loadClass(gcName);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private SubClassLoader createSubClassLoader(Class<?> theClass) {
        try {
            return new SubClassLoader(theClass.getClassLoader());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class ProbeProviderSubClassGenerator
    extends ClassVisitor {
        String superClassName;
        String token;
        String id;

        ProbeProviderSubClassGenerator(ClassVisitor cv, String token, String id) {
            super(589824, cv);
            this.id = id;
            this.token = token;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superClassName = name;
            super.visit(version, access, name + this.token + this.id, signature, name, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor delegate = super.visitAnnotation(desc, visible);
            if ("Lorg/glassfish/external/probe/provider/annotations/ProbeProvider;".equals(desc)) {
                return new ProbeProviderAnnotationVisitor(delegate, this.token);
            }
            return delegate;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] strings) {
            if ("<init>".equals(name) && desc.equals("()V")) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, strings);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, this.superClassName, "<init>", desc, false);
                mv.visitInsn(177);
                mv.visitMaxs(1, 1);
                mv.visitEnd();
                return null;
            }
            return super.visitMethod(access, name, desc, signature, strings);
        }
    }

    static class SubClassLoader
    extends ClassLoader {
        SubClassLoader(ClassLoader cl) {
            super(cl);
        }

        String defineClass(String className, byte[] data, ProtectionDomain pd) throws Exception {
            className = className.replace('/', '.');
            super.defineClass(className, data, 0, data.length, pd);
            return className;
        }
    }

    private static class ProbeProviderAnnotationVisitor
    extends AnnotationVisitor {
        private AnnotationVisitor delegate;
        private String token;

        ProbeProviderAnnotationVisitor(AnnotationVisitor delegate, String token) {
            super(589824);
            this.delegate = delegate;
            this.token = token;
        }

        public void visit(String attrName, Object value) {
            this.delegate.visit(attrName, "probeProviderName".equals(attrName) ? String.valueOf(value) + this.token : value);
        }

        public void visitEnum(String s, String s1, String s2) {
            this.delegate.visitEnum(s, s1, s2);
        }

        public AnnotationVisitor visitAnnotation(String s, String s1) {
            return this.delegate.visitAnnotation(s, s1);
        }

        public AnnotationVisitor visitArray(String s) {
            return this.delegate.visitArray(s);
        }

        public void visitEnd() {
            this.delegate.visitEnd();
        }
    }
}

