/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.jaas;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class CallbackHandlerImpl
implements CallbackHandler {
    private static boolean DEBUG = false;
    private BrokerResources rb = Globals.getBrokerResources();
    private Logger logger = Globals.getLogger();
    private Properties authProps = null;
    private String userName = null;
    private String password = null;

    public CallbackHandlerImpl(Properties authProps, String userName, String password) {
        this.authProps = authProps;
        this.userName = userName;
        this.password = password;
    }

    protected synchronized void destroy() {
        this.authProps = null;
        this.userName = null;
        this.password = null;
    }

    @Override
    public synchronized void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof LanguageCallback) {
                LanguageCallback cb = (LanguageCallback)callbacks[i];
                if (DEBUG) {
                    this.logger.log(8, "JAAS CallbackHander handle LanguageCallback - returning " + String.valueOf(this.rb.getLocale()));
                }
                cb.setLocale(this.rb.getLocale());
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                if (this.userName == null) {
                    String emsg = Globals.getBrokerResources().getKString("B4299", "NameCallback");
                    this.logger.log(32, emsg);
                    throw new UnsupportedCallbackException(callbacks[i], emsg);
                }
                NameCallback cb = (NameCallback)callbacks[i];
                if (DEBUG) {
                    this.logger.log(8, "JAAS CallbackHander handle NameCallback prompt: " + ((NameCallback)callbacks[i]).getPrompt() + " - returning " + this.userName);
                }
                cb.setName(this.userName);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                if (this.password == null) {
                    String emsg = Globals.getBrokerResources().getKString("B4299", "PasswordCallback");
                    this.logger.log(32, emsg);
                    throw new UnsupportedCallbackException(callbacks[i], emsg);
                }
                PasswordCallback cb = (PasswordCallback)callbacks[i];
                if (DEBUG) {
                    this.logger.log(8, "JAAS CallbackHander handle PasswordCallback [" + cb.getClass().getName() + "] prompt:" + cb.getPrompt());
                }
                cb.setPassword(this.password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof TextInputCallback) {
                if (this.authProps == null) {
                    String emsg = Globals.getBrokerResources().getKString("B4299", "TextInputCallback");
                    this.logger.log(32, emsg);
                    throw new UnsupportedCallbackException(callbacks[i], emsg);
                }
                TextInputCallback cb = (TextInputCallback)callbacks[i];
                String text = null;
                if (cb.getPrompt().equals("imq.authentication.type")) {
                    text = this.authProps.getProperty("imq.authentication.type");
                } else if (cb.getPrompt().equals("imq.accesscontrol.type")) {
                    text = this.authProps.getProperty("imq.accesscontrol.type");
                } else if (cb.getPrompt().equals("imq.authentication.clientip")) {
                    text = this.authProps.getProperty("imq.authentication.clientip");
                } else if (cb.getPrompt().equals("imq.servicename")) {
                    text = this.authProps.getProperty("imq.servicename");
                } else if (cb.getPrompt().equals("imq.servicetype")) {
                    text = this.authProps.getProperty("imq.servicetype");
                } else {
                    String emsg = Globals.getBrokerResources().getKString("B2199", cb.getClass().getName(), cb.getPrompt());
                    this.logger.log(16, emsg);
                    throw new UnsupportedCallbackException(callbacks[i], emsg);
                }
                if (DEBUG) {
                    this.logger.log(8, "JAAS CallbackHander handle TextInputCallback prompt: " + ((TextInputCallback)callbacks[i]).getPrompt() + " - returning " + text);
                }
                cb.setText(text);
                continue;
            }
            if (callbacks[i] instanceof TextOutputCallback) {
                int level = Integer.MAX_VALUE;
                TextOutputCallback cb = (TextOutputCallback)callbacks[i];
                switch (cb.getMessageType()) {
                    case 0: {
                        level = 8;
                        break;
                    }
                    case 1: {
                        level = 16;
                        break;
                    }
                    case 2: {
                        level = 32;
                        break;
                    }
                    default: {
                        String emsg = Globals.getBrokerResources().getKString("B2200", cb.getClass().getName(), cb.getMessageType());
                        this.logger.log(16, emsg);
                        throw new UnsupportedCallbackException(callbacks[i], emsg);
                    }
                }
                this.logger.log(level, cb.getClass().getName() + ": " + cb.getMessage());
                continue;
            }
            String emsg = Globals.getBrokerResources().getKString("B2201", callbacks[i].getClass().getName());
            throw new UnsupportedCallbackException(callbacks[i], emsg);
        }
    }
}

