/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.monitoring.DefaultMonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringUtils;
import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.ProbeNotifier;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolInfo;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;

public class VirtualThreadExecutorService
extends AbstractExecutorService
implements ThreadPoolInfo,
Thread.UncaughtExceptionHandler {
    private static final Logger logger = Grizzly.logger(VirtualThreadExecutorService.class);
    private final ExecutorService internalExecutorService;
    private final Semaphore poolSemaphore;
    private final Semaphore queueSemaphore;
    private final AtomicInteger threadsCount = new AtomicInteger();
    private final AtomicInteger queueSize = new AtomicInteger();
    private final ThreadPoolConfig originalConfig;
    protected final DefaultMonitoringConfig<ThreadPoolProbe> monitoringConfig = new DefaultMonitoringConfig<ThreadPoolProbe>(ThreadPoolProbe.class){

        @Override
        public Object createManagementObject() {
            return VirtualThreadExecutorService.this.createJmxManagementObject();
        }
    };

    public static VirtualThreadExecutorService createInstance() {
        return VirtualThreadExecutorService.createInstance(ThreadPoolConfig.defaultConfig().setMaxPoolSize(-1).setPoolName("Grizzly-virt-"));
    }

    public static VirtualThreadExecutorService createInstance(ThreadPoolConfig cfg) {
        Objects.requireNonNull(cfg);
        return new VirtualThreadExecutorService(cfg);
    }

    protected VirtualThreadExecutorService(ThreadPoolConfig config) {
        this.originalConfig = config;
        if (config.getInitialMonitoringConfig().hasProbes()) {
            this.monitoringConfig.addProbes((ThreadPoolProbe[])config.getInitialMonitoringConfig().getProbes());
        }
        this.internalExecutorService = Executors.newThreadPerTaskExecutor(this.getThreadFactory(config));
        int poolSizeLimit = config.getMaxPoolSize() > 0 ? config.getMaxPoolSize() : Integer.MAX_VALUE;
        int queueLimit = config.getQueueLimit() >= 0 ? config.getQueueLimit() : Integer.MAX_VALUE;
        long totalLimit = (long)poolSizeLimit + (long)queueLimit;
        this.queueSemaphore = totalLimit > Integer.MAX_VALUE ? new Semaphore(Integer.MAX_VALUE, true) : new Semaphore((int)totalLimit, true);
        this.poolSemaphore = new Semaphore(poolSizeLimit, true);
    }

    private ThreadFactory getThreadFactory(ThreadPoolConfig threadPoolConfig) {
        String prefix = threadPoolConfig.getPoolName() + "-";
        ThreadFactory factory = Thread.ofVirtual().name(prefix, 0L).uncaughtExceptionHandler(this).factory();
        return r -> {
            Thread thread = factory.newThread(r);
            ClassLoader initial = threadPoolConfig.getInitialClassLoader();
            if (initial != null) {
                thread.setContextClassLoader(initial);
            }
            return thread;
        };
    }

    @Override
    public void shutdown() {
        this.internalExecutorService.shutdown();
        ProbeNotifier.notifyThreadPoolStopped(this);
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> tasks = this.internalExecutorService.shutdownNow();
        for (Runnable cancelledTask : tasks) {
            this.onTaskDequeued(cancelledTask);
            this.onTaskCancelled(cancelledTask);
        }
        ProbeNotifier.notifyThreadPoolStopped(this);
        return tasks;
    }

    @Override
    public boolean isShutdown() {
        return this.internalExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.internalExecutorService.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.internalExecutorService.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable task) {
        if (!this.queueSemaphore.tryAcquire()) {
            throw new RejectedExecutionException("Too Many Concurrent Requests");
        }
        this.internalExecutorService.execute(() -> {
            Thread currentThread = Thread.currentThread();
            this.onWorkerStarted(currentThread);
            this.threadsCount.incrementAndGet();
            try {
                this.onTaskQueued(task);
                try {
                    this.poolSemaphore.acquire();
                }
                finally {
                    this.onTaskDequeued(task);
                }
                if (this.poolSemaphore.availablePermits() == 0) {
                    this.onMaxNumberOfThreadsReached();
                }
                try {
                    task.run();
                    this.onTaskCompletedEvent(task);
                }
                finally {
                    this.poolSemaphore.release();
                }
            }
            catch (InterruptedException e) {
                currentThread.interrupt();
                this.onTaskCancelled(task);
            }
            finally {
                this.queueSemaphore.release();
                this.threadsCount.decrementAndGet();
                this.onWorkerExit(currentThread);
            }
        });
    }

    private void beforeExecute(AbstractThreadPool.Worker worker, Thread t, Runnable r) {
        ClassLoader initial = this.getConfig().getInitialClassLoader();
        if (initial != null) {
            t.setContextClassLoader(initial);
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        logger.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_THREADPOOL_UNCAUGHT_EXCEPTION(thread), throwable);
    }

    @Override
    public int getSize() {
        return this.threadsCount.get();
    }

    @Override
    public ThreadPoolConfig getConfig() {
        return this.originalConfig;
    }

    @Override
    public DefaultMonitoringConfig<ThreadPoolProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    @Override
    public int getQueueSize() {
        return 0;
    }

    Object createJmxManagementObject() {
        return MonitoringUtils.loadJmxObject("org.glassfish.grizzly.threadpool.jmx.ThreadPool", this, ThreadPoolInfo.class);
    }

    protected void onTaskCompletedEvent(Runnable task) {
        ProbeNotifier.notifyTaskCompleted(this, task);
    }

    protected void onWorkerStarted(Thread thread) {
        ProbeNotifier.notifyThreadAllocated(this, thread);
    }

    protected void onWorkerExit(Thread thread) {
        ProbeNotifier.notifyThreadReleased(this, thread);
    }

    protected void onMaxNumberOfThreadsReached() {
        ProbeNotifier.notifyMaxNumberOfThreads(this, this.getConfig().getMaxPoolSize());
    }

    protected void onTaskQueued(Runnable task) {
        this.queueSize.incrementAndGet();
        ProbeNotifier.notifyTaskQueued(this, task);
    }

    protected void onTaskDequeued(Runnable task) {
        this.queueSize.decrementAndGet();
        ProbeNotifier.notifyTaskDequeued(this, task);
    }

    protected void onTaskCancelled(Runnable task) {
        ProbeNotifier.notifyTaskCancelled(this, task);
    }
}

