/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.client;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.api.core.ActionException;
import org.glassfish.shoal.gms.api.core.CallBack;
import org.glassfish.shoal.gms.api.core.FailureNotificationAction;
import org.glassfish.shoal.gms.api.core.Signal;
import org.glassfish.shoal.gms.api.core.SignalAcquireException;
import org.glassfish.shoal.gms.api.core.SignalReleaseException;
import org.glassfish.shoal.gms.logging.GMSLogDomain;

public class FailureNotificationActionImpl
implements FailureNotificationAction {
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private CallBack caller;

    public FailureNotificationActionImpl(CallBack caller) {
        this.caller = caller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeSignal(Signal signal) throws ActionException {
        boolean signalAcquired = false;
        try {
            signal.acquire();
            signalAcquired = true;
            this.notifyListeners(signal);
        }
        catch (SignalAcquireException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        finally {
            if (signalAcquired) {
                try {
                    signal.release();
                }
                catch (SignalReleaseException e) {
                    this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    private void notifyListeners(Signal signal) {
        this.caller.processNotification(signal);
    }
}

