/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.client;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.transport.tcp.client.WSConnectionManager;
import com.sun.xml.ws.transport.tcp.io.Connection;
import com.sun.xml.ws.transport.tcp.util.ChannelContext;
import com.sun.xml.ws.transport.tcp.util.ConnectionSession;
import com.sun.xml.ws.transport.tcp.util.SessionCloseListener;
import com.sun.xml.ws.transport.tcp.util.WSTCPURI;
import java.util.HashMap;
import java.util.Map;

public final class ClientConnectionSession
extends ConnectionSession {
    private Map<String, Object> attributes = new HashMap<String, Object>(2);
    private Map<String, ChannelContext> url2ChannelMap = new HashMap<String, ChannelContext>();

    public ClientConnectionSession(Connection connection, SessionCloseListener sessionCloseListener) {
        super(connection, sessionCloseListener);
        this.init();
    }

    @Override
    public void registerChannel(@NotNull ChannelContext context) {
        this.url2ChannelMap.put(context.getTargetWSURI().toString(), context);
    }

    @Override
    public void deregisterChannel(@NotNull ChannelContext context) {
        String wsTCPURLString = context.getTargetWSURI().toString();
        ChannelContext channelToRemove = this.url2ChannelMap.get(wsTCPURLString);
        if (channelToRemove.getChannelId() == context.getChannelId()) {
            this.url2ChannelMap.remove(wsTCPURLString);
        }
    }

    @Override
    @Nullable
    public ChannelContext findWSServiceContextByURI(@NotNull WSTCPURI wsTCPURI) {
        return this.url2ChannelMap.get(wsTCPURI.toString());
    }

    @Override
    public void onReadCompleted() {
        WSConnectionManager.getInstance().freeConnection(this);
    }

    @Override
    public void close() {
        super.close();
        this.attributes = null;
    }

    @Override
    public void setAttribute(@NotNull String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    @Nullable
    public Object getAttribute(@NotNull String name) {
        return this.attributes.get(name);
    }

    @Override
    public int getChannelsAmount() {
        return this.url2ChannelMap.size();
    }
}

