/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import org.glassfish.rmic.tools.java.ClassFile;
import org.glassfish.rmic.tools.java.ClassPath;

public class ClassPathLoader
extends ClassLoader {
    private ClassPath classPath;

    public ClassPathLoader(ClassPath classPath) {
        this.classPath = classPath;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] b = this.loadClassData(name);
        return this.defineClass(name, b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassData(String className) throws ClassNotFoundException {
        String filename = className.replace('.', File.separatorChar) + ".class";
        ClassFile classFile = this.classPath.getFile(filename);
        if (classFile != null) {
            IOException reportedError = null;
            byte[] data = null;
            try {
                DataInputStream input = new DataInputStream(classFile.getInputStream());
                data = new byte[(int)classFile.length()];
                try {
                    input.readFully(data);
                }
                catch (IOException ex) {
                    data = null;
                    reportedError = ex;
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ex) {
                reportedError = ex;
            }
            if (data == null) {
                throw new ClassNotFoundException(className, reportedError);
            }
            return data;
        }
        throw new ClassNotFoundException(className);
    }
}

