/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.cdi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class BatchXMLMapper {
    private static final Logger logger = Logger.getLogger(BatchXMLMapper.class.getName());
    private static final String BATCH_XML = "META-INF/batch.xml";
    private static final QName BATCH_ROOT_ELEM = new QName("http://xmlns.jcp.org/xml/ns/javaee", "batch-artifacts");
    private static final QName BATCH_ROOT_ELEM_2 = new QName("https://jakarta.ee/xml/ns/jakartaee", "batch-artifacts");
    private ArtifactMap artifactMap;
    private static final Map<ClassLoader, ArtifactMap> loader2ArtifactMap = new WeakHashMap<ClassLoader, ArtifactMap>();

    public BatchXMLMapper(ClassLoader loader) {
        this.artifactMap = loader2ArtifactMap.get(loader);
        if (this.artifactMap == null) {
            this.artifactMap = BatchXMLMapper.populateArtifactMap(loader);
        }
    }

    public Class<?> getArtifactById(String id) {
        return (Class)this.artifactMap.idToArtifactClassMap.get(id);
    }

    private static synchronized ArtifactMap populateArtifactMap(ClassLoader loader) {
        ArtifactMap artifactMap = loader2ArtifactMap.get(loader);
        if (artifactMap != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Map already initialized for loader: " + loader);
            }
            return artifactMap;
        }
        artifactMap = new ArtifactMap(loader);
        InputStream is = loader.getResourceAsStream(BATCH_XML);
        if (is != null) {
            artifactMap = BatchXMLMapper.populateArtifactMapFromStream(artifactMap, is);
            loader2ArtifactMap.put(loader, artifactMap);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer("Did not find batch.xml in classloader: " + loader);
        }
        return artifactMap;
    }

    protected static ArtifactMap populateArtifactMapFromStream(ArtifactMap tempMap, InputStream is) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            int event;
            XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(is);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Loaded XMLStreamReader = " + xmlStreamReader);
            }
            boolean processedRoot = false;
            while (xmlStreamReader.hasNext() && (event = xmlStreamReader.next()) != 8) {
                if (event != 1) continue;
                if (!processedRoot) {
                    QName rootQName = xmlStreamReader.getName();
                    if (!rootQName.equals(BATCH_ROOT_ELEM) && !rootQName.equals(BATCH_ROOT_ELEM_2)) {
                        throw new IllegalStateException("Expecting document with root element QName: " + BATCH_ROOT_ELEM + " or " + BATCH_ROOT_ELEM_2 + ", but found root element with QName: " + rootQName);
                    }
                    processedRoot = true;
                    continue;
                }
                String annotationShortName = xmlStreamReader.getLocalName();
                String id = xmlStreamReader.getAttributeValue(null, "id");
                String className = xmlStreamReader.getAttributeValue(null, "class");
                tempMap.addEntry(annotationShortName, id, className);
                while (event != 2) {
                    event = xmlStreamReader.next();
                }
            }
            xmlStreamReader.close();
            is.close();
            return tempMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ArtifactMap {
        private final ClassLoader loader;
        private final Map<String, Class<?>> idToArtifactClassMap = new HashMap();
        private final Map<String, List<String>> idToArtifactTypeListMap = new HashMap<String, List<String>>();

        public ArtifactMap(ClassLoader loader) {
            this.loader = loader;
        }

        void addEntry(String batchTypeName, String id, String className) {
            try {
                if (!this.idToArtifactClassMap.containsKey(id)) {
                    Class<?> artifactClass = this.loader.loadClass(className);
                    this.idToArtifactClassMap.put(id, artifactClass);
                    ArrayList<String> typeList = new ArrayList<String>();
                    typeList.add(batchTypeName);
                    this.idToArtifactTypeListMap.put(id, typeList);
                } else {
                    Class<?> artifactClass = this.loader.loadClass(className);
                    if (!this.idToArtifactClassMap.get(id).equals(artifactClass)) {
                        Class<?> alreadyLoaded = this.idToArtifactClassMap.get(id);
                        String msg = "Attempted to load batch artifact with id: " + id + ", and className: " + className + ". Found: " + artifactClass + ", however the artifact id: " + id + " is already associated with: " + alreadyLoaded + ", of className: " + alreadyLoaded.getCanonicalName();
                        throw new IllegalArgumentException(msg);
                    }
                    List<String> typeList = this.idToArtifactTypeListMap.get(id);
                    typeList.add(batchTypeName);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private List<String> getBatchTypeList(String id) {
            return this.idToArtifactTypeListMap.get(id);
        }
    }
}

