/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import jakarta.ws.rs.core.Configuration;
import java.lang.annotation.Annotation;
import org.glassfish.jersey.internal.BootstrapBag;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.Bindings;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.model.internal.ComponentBag;
import org.glassfish.jersey.process.internal.AbstractExecutorProvidersConfigurator;
import org.glassfish.jersey.server.BackgroundScheduler;
import org.glassfish.jersey.server.BackgroundSchedulerLiteral;
import org.glassfish.jersey.server.ManagedAsyncExecutor;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerBootstrapBag;
import org.glassfish.jersey.spi.ExecutorServiceProvider;
import org.glassfish.jersey.spi.ScheduledExecutorServiceProvider;
import org.glassfish.jersey.spi.ScheduledThreadPoolExecutorProvider;
import org.glassfish.jersey.spi.ThreadPoolExecutorProvider;

class ServerExecutorProvidersConfigurator
extends AbstractExecutorProvidersConfigurator {
    ServerExecutorProvidersConfigurator() {
    }

    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        ResourceConfig runtimeConfig = serverBag.getRuntimeConfig();
        ComponentBag componentBag = runtimeConfig.getComponentBag();
        DefaultBackgroundSchedulerProvider defaultScheduledExecutorProvider = new DefaultBackgroundSchedulerProvider((Configuration)runtimeConfig);
        InstanceBinding schedulerBinding = (InstanceBinding)((InstanceBinding)Bindings.service((Object)((Object)defaultScheduledExecutorProvider)).to(ScheduledExecutorServiceProvider.class)).qualifiedBy((Annotation)BackgroundSchedulerLiteral.INSTANCE);
        injectionManager.register((Binding)schedulerBinding);
        DefaultManagedAsyncExecutorProvider defaultAsyncExecutorProvider = new DefaultManagedAsyncExecutorProvider();
        InstanceBinding executorBinding = (InstanceBinding)Bindings.service((Object)((Object)defaultAsyncExecutorProvider)).to(ExecutorServiceProvider.class);
        injectionManager.register((Binding)executorBinding);
        this.registerExecutors(injectionManager, componentBag, (ExecutorServiceProvider)defaultAsyncExecutorProvider, (ScheduledExecutorServiceProvider)defaultScheduledExecutorProvider, serverBag.getManagedObjectsFinalizer());
    }

    @ManagedAsyncExecutor
    private static class DefaultManagedAsyncExecutorProvider
    extends ThreadPoolExecutorProvider {
        public DefaultManagedAsyncExecutorProvider() {
            super("jersey-server-managed-async-executor");
        }
    }

    @BackgroundScheduler
    private static class DefaultBackgroundSchedulerProvider
    extends ScheduledThreadPoolExecutorProvider {
        public DefaultBackgroundSchedulerProvider(Configuration configuration) {
            super("jersey-background-task-scheduler", configuration);
        }

        protected int getCorePoolSize() {
            return 1;
        }
    }
}

