/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.keyinfo.BinarySecurityToken;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.impl.reference.X509Data;
import com.sun.xml.ws.security.opt.impl.reference.X509IssuerSerial;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;

public class X509TokenBuilder
extends TokenBuilder {
    AuthenticationTokenPolicy.X509CertificateBinding binding = null;

    public X509TokenBuilder(JAXBFilterProcessingContext context, AuthenticationTokenPolicy.X509CertificateBinding binding) {
        super(context);
        this.binding = binding;
    }

    @Override
    public BuilderResult process() throws XWSSecurityException {
        String x509id = this.binding.getUUID();
        if (x509id == null || x509id.equals("")) {
            x509id = this.context.generateID();
        }
        SecurityUtil.checkIncludeTokenPolicyOpt(this.context, this.binding, x509id);
        String referenceType = this.binding.getReferenceType();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, LogStringsMessages.WSS_1851_REFERENCETYPE_X_509_TOKEN(referenceType));
        }
        BuilderResult result = new BuilderResult();
        switch (referenceType) {
            case "Direct": {
                com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken bst = this.createBinarySecurityToken(this.binding, this.binding.getX509Certificate());
                if (bst == null) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY(), "creating binary security token failed");
                    throw new XWSSecurityException(LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY());
                }
                DirectReference dr = this.buildDirectReference(bst.getId(), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
                this.buildKeyInfo(dr, this.binding.getSTRID());
                break;
            }
            case "Identifier": {
                com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken bst = this.createBinarySecurityToken(this.binding, this.binding.getX509Certificate());
                this.buildKeyInfoWithKI(this.binding, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
                try {
                    if (this.binding.getSTRID() == null) break;
                    BinarySecurityToken bsToken = this.elementFactory.createBinarySecurityToken(null, this.binding.getX509Certificate().getEncoded());
                    SSEData data = new SSEData(bsToken, false, this.context.getNamespaceContext());
                    this.context.getSTRTransformCache().put(this.binding.getSTRID(), data);
                    break;
                }
                catch (CertificateEncodingException ce) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
                    throw new XWSSecurityException(LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
                }
            }
            case "Thumbprint": {
                com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken bst = this.createBinarySecurityToken(this.binding, this.binding.getX509Certificate());
                KeyIdentifier ki = this.buildKeyInfoWithKI(this.binding, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
                try {
                    if (this.binding.getSTRID() == null) break;
                    BinarySecurityToken bsToken = this.elementFactory.createBinarySecurityToken(null, this.binding.getX509Certificate().getEncoded());
                    SSEData data = new SSEData(bsToken, false, this.context.getNamespaceContext());
                    this.context.getSTRTransformCache().put(this.binding.getSTRID(), data);
                    break;
                }
                catch (CertificateEncodingException ce) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
                    throw new XWSSecurityException(LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
                }
            }
            case "IssuerSerialNumber": {
                com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken bst = this.createBinarySecurityToken(this.binding, this.binding.getX509Certificate());
                X509Certificate xCert = this.binding.getX509Certificate();
                X509IssuerSerial xis = this.elementFactory.createX509IssuerSerial(xCert.getIssuerX500Principal().getName(), xCert.getSerialNumber());
                X509Data x509Data = this.elementFactory.createX509DataWithIssuerSerial(xis);
                this.buildKeyInfo(x509Data, this.binding.getSTRID());
                try {
                    if (this.binding.getSTRID() == null) break;
                    BinarySecurityToken bsToken = this.elementFactory.createBinarySecurityToken(null, this.binding.getX509Certificate().getEncoded());
                    SSEData data = new SSEData(bsToken, false, this.context.getNamespaceContext());
                    this.context.getSTRTransformCache().put(this.binding.getSTRID(), data);
                    break;
                }
                catch (CertificateEncodingException ce) {
                    logger.log(Level.SEVERE, LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
                    throw new XWSSecurityException(LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
                }
            }
            default: {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
                throw new XWSSecurityException(LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
            }
        }
        result.setKeyInfo(this.keyInfo);
        return result;
    }
}

