/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.comet;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.comet.CometEvent;
import org.glassfish.grizzly.comet.CometHandler;
import org.glassfish.grizzly.comet.NotificationHandler;

public class DefaultNotificationHandler
implements NotificationHandler {
    private static final Logger logger = Logger.getLogger(DefaultNotificationHandler.class.getName());
    private static final IllegalStateException ISEempty = new IllegalStateException();
    protected ExecutorService threadPool;

    protected void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public void notify(CometEvent cometEvent, Iterator<CometHandler> iteratorHandlers) throws IOException {
        while (iteratorHandlers.hasNext()) {
            this.notify(cometEvent, iteratorHandlers.next());
        }
    }

    @Override
    public void notify(CometEvent cometEvent, CometHandler cometHandler) throws IOException {
        this.notify0(cometEvent, cometHandler);
    }

    protected void notify0(CometEvent cometEvent, CometHandler cometHandler) {
        try {
            switch (cometEvent.getType()) {
                case INTERRUPT: {
                    cometHandler.onInterrupt(cometEvent);
                    break;
                }
                case NOTIFY: 
                case READ: 
                case WRITE: {
                    if (cometEvent.getCometContext().isActive(cometHandler)) {
                        cometHandler.onEvent(cometEvent);
                    }
                    break;
                }
                case INITIALIZE: {
                    cometHandler.onInitialize(cometEvent);
                    break;
                }
                case TERMINATE: {
                    cometHandler.onTerminate(cometEvent);
                    break;
                }
                default: {
                    throw ISEempty;
                }
            }
        }
        catch (Throwable ex) {
            logger.log(Level.FINE, "Notification failed: ", ex);
            try {
                cometEvent.getCometContext().resumeCometHandler(cometHandler);
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "Resume phase failed: ", t);
            }
        }
    }
}

