/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work.monitor;

import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.RangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="connector-service-mon", group="monitoring")
@ManagedObject
@Description(value="Connector Container Work Management Statistics")
public class WorkManagementStatsProvider {
    private String moduleName;
    private static final String DOTTED_NAME = "glassfish:jca:work-management:";
    long time = System.currentTimeMillis();
    private final CountStatisticImpl submittedWorkCount = new CountStatisticImpl("SubmittedWorkCount", "count", "Number of work objects submitted by a connector module for execution");
    private final CountStatisticImpl rejectedWorkCount = new CountStatisticImpl("RejectedWorkCount", "count", "Number of work objects rejected by the application server");
    private final CountStatisticImpl completedWorkCount = new CountStatisticImpl("CompletedWorkCount", "count", "Number of work objects completed execution");
    private final RangeStatisticImpl activeWorkCount = new RangeStatisticImpl(0L, 0L, 0L, "ActiveWorkCount", "count", "Number of active work objects", this.time, this.time);
    private final RangeStatisticImpl waitQueueLength = new RangeStatisticImpl(0L, 0L, 0L, "WaitQueueLength", "count", "Number of work objects waiting in the queue for execution", this.time, this.time);
    private final RangeStatisticImpl workRequestWaitTime = new RangeStatisticImpl(0L, 0L, 0L, "WorkRequestWaitTime", "count", "Wait time of a work object before it gets executed", this.time, this.time);

    public WorkManagementStatsProvider(String moduleName) {
        this.moduleName = moduleName;
    }

    @ManagedAttribute(id="submittedworkcount")
    @Description(value="Number of work objects submitted by a connector module for execution")
    public CountStatistic getSubmittedWorkCount() {
        return this.submittedWorkCount;
    }

    @ManagedAttribute(id="rejectedworkcount")
    @Description(value="Number of work objects rejected by the application server")
    public CountStatistic getRejectedWorkCount() {
        return this.rejectedWorkCount;
    }

    @ManagedAttribute(id="completedworkcount")
    @Description(value="Number of work objects completed execution")
    public CountStatistic getCompletedWorkCount() {
        return this.completedWorkCount;
    }

    @ManagedAttribute(id="activeworkcount")
    @Description(value="Number of active work objects")
    public RangeStatistic getActiveWorkCount() {
        return this.activeWorkCount;
    }

    @ManagedAttribute(id="waitqueuelength")
    @Description(value="Number of work objects waiting in the queue for execution")
    public RangeStatistic getWaitQueueLength() {
        return this.waitQueueLength;
    }

    @ManagedAttribute(id="workrequestwaittime")
    @Description(value="Wait time of a work object before it gets executed")
    public RangeStatistic getWorkRequestWaitTime() {
        return this.workRequestWaitTime;
    }

    private boolean isValidEvent(String raName) {
        return raName != null && this.moduleName.equals(raName);
    }

    @ProbeListener(value="glassfish:jca:work-management:workSubmitted")
    public void workSubmitted(@ProbeParam(value="raName") String raName) {
        if (this.isValidEvent(raName)) {
            this.submittedWorkCount.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jca:work-management:workQueued")
    public void workQueued(@ProbeParam(value="raName") String raName) {
        if (this.isValidEvent(raName)) {
            RangeStatisticImpl rangeStatisticImpl = this.waitQueueLength;
            synchronized (rangeStatisticImpl) {
                this.waitQueueLength.setCurrent(this.waitQueueLength.getCurrent() + 1L);
            }
        }
    }

    @ProbeListener(value="glassfish:jca:work-management:workWaitedFor")
    public void workWaitedFor(@ProbeParam(value="raName") String raName, @ProbeParam(value="elapsedTime") long elapsedTime) {
        if (this.isValidEvent(raName)) {
            this.workRequestWaitTime.setCurrent(elapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jca:work-management:workDequeued")
    public void workDequeued(@ProbeParam(value="raName") String raName) {
        if (this.isValidEvent(raName)) {
            RangeStatisticImpl rangeStatisticImpl = this.waitQueueLength;
            synchronized (rangeStatisticImpl) {
                this.waitQueueLength.setCurrent(this.waitQueueLength.getCurrent() - 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jca:work-management:workProcessingStarted")
    public void workProcessingStarted(@ProbeParam(value="raName") String raName) {
        if (this.isValidEvent(raName)) {
            RangeStatisticImpl rangeStatisticImpl = this.activeWorkCount;
            synchronized (rangeStatisticImpl) {
                this.activeWorkCount.setCurrent(this.activeWorkCount.getCurrent() + 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:jca:work-management:workProcessingCompleted")
    public void workProcessingCompleted(@ProbeParam(value="raName") String raName) {
        if (this.isValidEvent(raName)) {
            RangeStatisticImpl rangeStatisticImpl = this.activeWorkCount;
            synchronized (rangeStatisticImpl) {
                this.activeWorkCount.setCurrent(this.activeWorkCount.getCurrent() - 1L);
            }
        }
    }

    @ProbeListener(value="glassfish:jca:work-management:workProcessed")
    public void workProcessed(@ProbeParam(value="raName") String raName) {
        if (this.isValidEvent(raName)) {
            this.completedWorkCount.increment();
        }
    }

    @ProbeListener(value="glassfish:jca:work-management:workTimedOut")
    public void workTimedOut(@ProbeParam(value="raName") String raName) {
        if (this.isValidEvent(raName)) {
            this.rejectedWorkCount.increment();
        }
    }
}

