/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.loader.ResourceLocator;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.glassfish.embeddable.client.ApplicationClientClassLoader;
import org.glassfish.main.jdke.cl.GlassfishUrlClassLoader;

public class TransformingClassLoader
extends GlassfishUrlClassLoader {
    private static final Function<Path, URL> PATH_TO_URL;
    private static TransformingClassLoader instance;
    private TransformingClassLoader shadow;
    private final boolean shouldTransform;
    private final List<ClassFileTransformer> transformers = Collections.synchronizedList(new ArrayList());

    public static synchronized TransformingClassLoader newInstance(ClassLoader parent, boolean shouldTransform) {
        if (instance != null) {
            throw new IllegalStateException("Already set");
        }
        instance = parent instanceof ApplicationClientClassLoader ? new TransformingClassLoader(new URL[0], parent, shouldTransform) : new TransformingClassLoader(TransformingClassLoader.createClassPath(), parent, shouldTransform);
        return instance;
    }

    public static TransformingClassLoader instance() {
        return instance;
    }

    private TransformingClassLoader(URL[] classpath, ClassLoader parent, boolean shouldTransform) {
        super("Transformer", classpath, parent);
        this.shouldTransform = shouldTransform;
    }

    public TransformingClassLoader(URL[] urls, ClassLoader parent) {
        super("Transformer", urls, parent);
        this.shouldTransform = false;
    }

    public synchronized void appendURL(URL url) {
        this.addURL(url);
        if (this.shadow != null) {
            this.shadow.addURL(url);
        }
    }

    public void addTransformer(ClassFileTransformer xf) {
        this.transformers.add(xf);
    }

    synchronized TransformingClassLoader shadow() {
        if (this.shadow == null) {
            this.shadow = new TransformingClassLoader(this.getURLs(), this.getParent());
        }
        return this.shadow;
    }

    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!this.shouldTransform) {
            return this.findClassUnshadowed(name);
        }
        return this.copyClass(this.shadow().findClassUnshadowed(name));
    }

    private Class<?> copyClass(Class<?> sourceClass) throws ClassNotFoundException {
        String name = sourceClass.getName();
        ProtectionDomain pd = sourceClass.getProtectionDomain();
        byte[] bytecode = this.readByteCode(name);
        for (ClassFileTransformer xf : this.transformers) {
            try {
                bytecode = xf.transform((ClassLoader)((Object)this), name, null, pd, bytecode);
            }
            catch (IllegalClassFormatException ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
        return this.defineClass(name, bytecode, 0, bytecode.length, pd);
    }

    private Class<?> findClassUnshadowed(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    private byte[] readByteCode(String className) throws ClassNotFoundException {
        byte[] byArray;
        block9: {
            String resourceName = className.replace('.', '/') + ".class";
            InputStream is = this.getResourceAsStream(resourceName);
            try {
                if (is == null) {
                    throw new ClassNotFoundException(className);
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileUtils.copy((InputStream)is, (OutputStream)baos);
                byArray = baos.toByteArray();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(className, e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        ResourceLocator locator = new ResourceLocator((URLClassLoader)((Object)this), this.getParent(), true);
        return locator.getResources(name);
    }

    private static URL[] createClassPath() {
        Stream<Path> cpPaths = TransformingClassLoader.convertClassPathToPaths(System.getProperty("java.class.path"));
        Stream<Path> envPaths = TransformingClassLoader.convertClassPathToPaths(System.getenv("APPCPATH"));
        Predicate<Path> filterOutGfClient = f -> !f.endsWith(Path.of("gf-client.jar", new String[0]));
        return (URL[])Stream.concat(cpPaths, envPaths).map(Path::toAbsolutePath).map(Path::normalize).distinct().filter(filterOutGfClient).map(PATH_TO_URL).toArray(URL[]::new);
    }

    private static Stream<Path> convertClassPathToPaths(String classPath) {
        if (classPath == null || classPath.isBlank()) {
            return Stream.empty();
        }
        try {
            return Stream.of(classPath.split(File.pathSeparator)).map(File::new).map(File::toPath);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse the classpath: " + classPath, e);
        }
    }

    static {
        TransformingClassLoader.registerAsParallelCapable();
        PATH_TO_URL = p -> {
            try {
                return p.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Could not convert path to url: " + String.valueOf(p), e);
            }
        };
    }
}

