/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin.handlers;

import com.sun.messaging.bridge.admin.BridgeServiceManagerImpl;
import com.sun.messaging.bridge.admin.handlers.AdminCmdHandler;
import com.sun.messaging.bridge.admin.handlers.AdminMessageHandler;
import com.sun.messaging.bridge.admin.resources.BridgeManagerResources;
import com.sun.messaging.bridge.admin.util.AdminMessageType;
import com.sun.messaging.bridge.api.BridgeException;
import jakarta.jms.JMSException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;

public class StopHandler
extends AdminCmdHandler {
    public StopHandler(AdminMessageHandler parent, BridgeServiceManagerImpl bsm) {
        super(parent, bsm);
    }

    @Override
    public void handle(Session session, ObjectMessage msg, ObjectMessage reply, BridgeManagerResources bmr) throws BridgeException, JMSException, Exception {
        String lname;
        int msgtype = msg.getIntProperty("JMQMessageType");
        if (msgtype != 26) {
            throw new BridgeException(this._bmr.getKString("BB4013", AdminMessageType.getString(msgtype)));
        }
        String bnameval = msg.getStringProperty("JMQBridgeName");
        String btypeval = msg.getStringProperty("JMQBridgeType");
        String lnameval = msg.getStringProperty("JMQLinkName");
        String bname = bnameval == null ? null : bnameval.trim();
        String btype = btypeval == null ? null : btypeval.trim().toUpperCase();
        String string = lname = lnameval == null ? null : lnameval.trim();
        if (bname != null && lname != null) {
            if (bname.length() == 0) {
                throw new BridgeException(this._bmr.getKString("BB3009", bname));
            }
            if (lname.trim().length() == 0) {
                throw new BridgeException(this._bmr.getKString("BB3010", lname));
            }
            this._bsm.stopBridge(bname, new String[]{"-ln", lname}, btype);
            this.parent.sendReply(session, msg, reply, 200, null, bmr);
            return;
        }
        if (lname != null) {
            throw new BridgeException(this._bmr.getKString("BB4017", msg));
        }
        if (bname != null && bname.length() == 0) {
            throw new BridgeException("Invalid bridge name: " + bname);
        }
        this._bsm.stopBridge(bname, null, btype);
        this.parent.sendReply(session, msg, reply, 200, null, bmr);
    }
}

