/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.acl;

import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.ee.web.integration.WebPrincipal;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.Role;
import org.glassfish.security.common.UserNameAndPassword;
import org.glassfish.security.common.UserPrincipal;

public class RoleMapper
implements Serializable,
SecurityRoleMapper {
    private static final long serialVersionUID = -4455830942007736853L;
    private static final Logger LOG = LogDomains.getLogger(RoleMapper.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    private String appName;
    private String defaultPrincipalToRoleMappingClassName;
    private final DefaultRoleToSubjectMapping defaultRoleToSubjectMapping = new DefaultRoleToSubjectMapping();
    private final Map<String, Subject> roleToSubject = new HashMap<String, Subject>();
    private final Map<String, Set<UserPrincipal>> roleToPrincipal = new HashMap<String, Set<UserPrincipal>>();
    private final Map<String, Set<Group>> roleToGroup = new HashMap<String, Set<Group>>();
    private Mapping currentMapping;
    private Set<Role> topLevelRoles;
    private static final String TOP_LEVEL = "sun-application.xml mapping file";
    private boolean conflictLogged;
    private Set<Role> conflictedRoles;
    private transient SecurityService securityService;

    RoleMapper(String appName) {
        this.appName = appName;
        this.securityService = (SecurityService)Globals.getDefaultBaseServiceLocator().getService(SecurityService.class, "default-instance-name", new Annotation[0]);
        this.defaultPrincipalToRoleMappingClassName = this.getDefaultPrincipalToRoleMappingClassName();
    }

    public RoleMapper(RoleMapper other) {
        this.appName = other.getName();
        Iterator<String> it = other.getRoles();
        while (it.hasNext()) {
            String role = it.next();
            Enumeration<Group> groups = other.getGroupsAssignedTo(new Role(role));
            HashSet<Group> groupsToRole = new HashSet<Group>();
            while (groups.hasMoreElements()) {
                Group gp = groups.nextElement();
                groupsToRole.add(new Group(gp.getName()));
                this.addRoleToSubject((Principal)gp, role);
            }
            this.roleToGroup.put(role, groupsToRole);
            Enumeration<UserPrincipal> users = other.getUsersAssignedTo(new Role(role));
            HashSet<UserNameAndPassword> usersToRole = new HashSet<UserNameAndPassword>();
            while (users.hasMoreElements()) {
                UserPrincipal principal = users.nextElement();
                usersToRole.add(new UserNameAndPassword(principal.getName()));
                this.addRoleToSubject((Principal)principal, role);
            }
            this.roleToPrincipal.put(role, usersToRole);
        }
    }

    public String getName() {
        return this.appName;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public Map<String, Subject> getRoleToSubjectMapping() {
        this.checkAndAddMappings();
        if (this.roleToSubject.isEmpty() && this.isDefaultPrincipalToRoleMapping()) {
            return this.defaultRoleToSubjectMapping;
        }
        return this.roleToSubject;
    }

    public Map<String, Set<String>> getGroupToRolesMapping() {
        HashMap<String, Set<String>> groupToRoles = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Subject> roleToSubject : this.getRoleToSubjectMapping().entrySet()) {
            for (String group : this.getGroups(roleToSubject.getValue())) {
                groupToRoles.computeIfAbsent(group, g -> new HashSet()).add(roleToSubject.getKey());
            }
        }
        return groupToRoles;
    }

    public Map<String, Set<String>> getCallerToRolesMapping() {
        HashMap<String, Set<String>> callerToRoles = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Subject> roleToSubject : this.getRoleToSubjectMapping().entrySet()) {
            for (String callerName : this.getCallerPrincipalNames(roleToSubject.getValue())) {
                callerToRoles.computeIfAbsent(callerName, g -> new HashSet()).add(roleToSubject.getKey());
            }
        }
        return callerToRoles;
    }

    public void assignRole(Principal principal, Role role, RootDeploymentDescriptor rootDeploymentDescriptor) {
        String callingModuleID = this.getModuleID(rootDeploymentDescriptor);
        if (this.currentMapping == null) {
            this.currentMapping = new Mapping(callingModuleID);
        } else if (!callingModuleID.equals(this.currentMapping.owner)) {
            this.checkAndAddMappings();
            this.currentMapping = new Mapping(callingModuleID);
        }
        if (callingModuleID.equals(TOP_LEVEL) && this.topLevelRoles == null) {
            this.topLevelRoles = new HashSet<Role>();
        }
        this.currentMapping.addMapping(principal, role);
    }

    public void unassignPrincipalFromRole(Role role, Principal principal) {
        String roleName = role.getName();
        Subject subject = this.roleToSubject.get(roleName);
        if (subject != null) {
            subject.getPrincipals().remove(principal);
            this.roleToSubject.put(roleName, subject);
        }
        if (principal instanceof Group) {
            Set<Group> groups = this.roleToGroup.get(roleName);
            if (groups != null) {
                groups.remove(principal);
                this.roleToGroup.put(roleName, groups);
            }
        } else {
            Set<UserPrincipal> principals = this.roleToPrincipal.get(roleName);
            if (principals != null) {
                principals.remove(principal);
                this.roleToPrincipal.put(roleName, principals);
            }
        }
    }

    public Iterator<String> getRoles() {
        return this.roleToSubject.keySet().iterator();
    }

    public Enumeration<Group> getGroupsAssignedTo(Role role) {
        Set<Group> groups = this.roleToGroup.get(role.getName());
        if (groups == null) {
            return Collections.enumeration(Collections.emptySet());
        }
        return Collections.enumeration(groups);
    }

    public Enumeration<UserPrincipal> getUsersAssignedTo(Role role) {
        Set<UserPrincipal> principals = this.roleToPrincipal.get(role.getName());
        if (principals == null) {
            return Collections.enumeration(Collections.emptySet());
        }
        return Collections.enumeration(principals);
    }

    public void unassignRole(Role role) {
        if (role != null) {
            String roleName = role.getName();
            this.roleToSubject.remove(roleName);
            this.roleToPrincipal.remove(roleName);
            this.roleToGroup.remove(roleName);
        }
    }

    public boolean isDefaultPrincipalToRoleMapping() {
        return this.defaultPrincipalToRoleMappingClassName != null;
    }

    public Set<String> getGroups(Subject subject) {
        return subject.getPrincipals().stream().filter(e -> e instanceof Group).map(e -> e.getName()).collect(Collectors.toSet());
    }

    public Principal getCallerPrincipal(Subject subject) {
        return this.getCustomPrincipal(subject.getPublicCredentials().stream().filter(DistinguishedPrincipalCredential.class::isInstance).map(Principal.class::cast).findAny().orElse(subject.getPrincipals().stream().filter(UserPrincipal.class::isInstance).findAny().orElse(null)));
    }

    public String toString() {
        StringBuilder s = new StringBuilder("RoleMapper:");
        Iterator<String> e = this.getRoles();
        while (e.hasNext()) {
            String r = e.next();
            s.append("\n\tRole (").append(r).append(") has Principals(");
            Subject sub = this.roleToSubject.get(r);
            for (Principal p : sub.getPrincipals()) {
                s.append(p.getName()).append(" ");
            }
            s.append(")");
        }
        return s.toString();
    }

    private void addRoleToSubject(Principal principal, String role) {
        this.roleToSubject.computeIfAbsent(role, e -> new Subject()).getPrincipals().add(principal);
    }

    private String getDefaultPrincipalToRoleMappingClassName() {
        String className = null;
        try {
            if (this.securityService != null && Boolean.parseBoolean(this.securityService.getActivateDefaultPrincipalToRoleMapping()) && Utility.isEmpty((String)(className = this.securityService.getMappedPrincipalClass()))) {
                className = Group.class.getName();
            }
            if (className == null) {
                return null;
            }
            Class.forName(className).getConstructor(String.class).newInstance("anystring");
            return className;
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "pc.getDefaultP2RMappingClass: " + className, e);
            return null;
        }
    }

    private Principal getCustomPrincipal(Principal principal) {
        if (principal instanceof DistinguishedPrincipalCredential) {
            DistinguishedPrincipalCredential distinguishedPrincipal = (DistinguishedPrincipalCredential)principal;
            return distinguishedPrincipal.getPrincipal();
        }
        if (principal instanceof WebPrincipal) {
            WebPrincipal webPrincipal = (WebPrincipal)((Object)principal);
            return webPrincipal.getCustomPrincipal();
        }
        return principal;
    }

    private Set<String> getCallerPrincipalNames(Subject subject) {
        return subject.getPrincipals().stream().filter(UserPrincipal.class::isInstance).map(Principal::getName).collect(Collectors.toSet());
    }

    private void checkAndAddMappings() {
        if (this.currentMapping == null) {
            return;
        }
        for (Role role : this.currentMapping.getRoles()) {
            if (this.topLevelRoles != null && this.topLevelRoles.contains(role)) {
                this.logConflictWarning();
                LOG.log(Level.FINE, "Role {0} from module {1} is being overridden by top-level mapping.", new Object[]{role, this.currentMapping.owner});
                continue;
            }
            if (this.currentMapping.owner.equals(TOP_LEVEL)) {
                this.topLevelRoles.add(role);
                if (this.roleToSubject.keySet().contains(role.getName())) {
                    this.logConflictWarning();
                    LOG.log(Level.FINE, "Role {0} from top-level mapping descriptor is overriding existing role in sub module.", role);
                    this.unassignRole(role);
                }
            } else if (this.roleConflicts(role, this.currentMapping.getPrincipals(role))) {
                this.logConflictWarning();
                this.unassignRole(role);
                continue;
            }
            for (Principal principal : this.currentMapping.getPrincipals(role)) {
                this.internalAssignRole(principal, role);
            }
        }
        this.currentMapping = null;
    }

    private void internalAssignRole(Principal principal, Role role) {
        String roleName = role.getName();
        LOG.log(Level.FINE, "SECURITY:RoleMapper Assigning Role {0} to {1}", new Object[]{roleName, principal});
        this.addRoleToSubject(principal, roleName);
        if (principal instanceof Group) {
            Group group = (Group)principal;
            this.roleToGroup.computeIfAbsent(roleName, e -> new HashSet()).add(group);
        } else if (principal instanceof UserPrincipal) {
            UserPrincipal userPrincipal = (UserPrincipal)principal;
            this.roleToPrincipal.computeIfAbsent(roleName, e -> new HashSet()).add(userPrincipal);
        } else {
            throw new IllegalArgumentException("Unknown principal class: " + String.valueOf(principal.getClass()));
        }
    }

    private String getModuleID(RootDeploymentDescriptor rootDeploymentDescriptor) {
        if (rootDeploymentDescriptor.isApplication()) {
            return TOP_LEVEL;
        }
        if (rootDeploymentDescriptor.getModuleDescriptor() != null) {
            return rootDeploymentDescriptor.getModuleDescriptor().getArchiveUri();
        }
        throw new AssertionError((Object)(String.valueOf(rootDeploymentDescriptor.getClass()) + " is not a known descriptor type"));
    }

    private boolean roleConflicts(Role r, Set<Principal> ps) {
        if (this.conflictedRoles != null && this.conflictedRoles.contains(r)) {
            LOG.log(Level.FINE, "Role {0} from module {1} has already had a conflict with other modules.", new Object[]{r, this.currentMapping.owner});
            return true;
        }
        if (!this.roleToSubject.keySet().contains(r.getName())) {
            return false;
        }
        int targetNumPrin = ps.size();
        int actualNum = 0;
        Set<UserPrincipal> pSet = this.roleToPrincipal.get(r.getName());
        Set<Group> gSet = this.roleToGroup.get(r.getName());
        actualNum += pSet == null ? 0 : pSet.size();
        if (targetNumPrin != (actualNum += gSet == null ? 0 : gSet.size())) {
            LOG.log(Level.FINE, "Module {0} has different number of mappings for role {1} than other mapping files", new Object[]{this.currentMapping.owner, r.getName()});
            if (this.conflictedRoles == null) {
                this.conflictedRoles = new HashSet<Role>();
            }
            this.conflictedRoles.add(r);
            return true;
        }
        boolean fail = false;
        for (Principal p : ps) {
            if (p instanceof Group) {
                if (gSet != null && !gSet.contains(p)) {
                    fail = true;
                }
            } else if (pSet != null && !pSet.contains(p)) {
                fail = true;
            }
            if (!fail) continue;
            LOG.log(Level.FINE, "Role {0} in module {1} is not included in other modules.", new Object[]{r, this.currentMapping.owner});
            if (this.conflictedRoles == null) {
                this.conflictedRoles = new HashSet<Role>();
            }
            this.conflictedRoles.add(r);
            return true;
        }
        return false;
    }

    private void logConflictWarning() {
        if (!this.conflictLogged) {
            LOG.log(Level.WARNING, "Role mapping conflicts found in application {0}. Some roles may not be mapped.", this.getName());
            this.conflictLogged = true;
        }
    }

    class DefaultRoleToSubjectMapping
    extends HashMap<String, Subject> {
        private static final long serialVersionUID = 3074733840327132690L;
        private final Map<String, Subject> roleMap = new HashMap<String, Subject>();

        DefaultRoleToSubjectMapping() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Subject get(Object key) {
            Map<String, Subject> map = this.roleMap;
            synchronized (map) {
                Subject subject = this.roleMap.get(key);
                if (subject == null && key instanceof String && !"**".equals(key)) {
                    subject = new Subject();
                    String roleName = (String)key;
                    subject.getPrincipals().add(this.getSameNamedPrincipal(roleName));
                    this.roleMap.put(roleName, subject);
                }
                return subject;
            }
        }

        Principal getSameNamedPrincipal(String roleName) {
            try {
                return (Principal)Class.forName(RoleMapper.this.defaultPrincipalToRoleMappingClassName).getConstructor(String.class).newInstance(roleName);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "rm.getSameNamedPrincipal", new Object[]{roleName, e});
                throw new RuntimeException("Unable to get principal by default p2r mapping");
            }
        }
    }

    private static class Mapping
    implements Serializable {
        private static final long serialVersionUID = 5863982599500877228L;
        private final String owner;
        private final Map<Role, Set<Principal>> roleMap;

        Mapping(String owner) {
            this.owner = owner;
            this.roleMap = new HashMap<Role, Set<Principal>>();
        }

        void addMapping(Principal principal, Role role) {
            this.roleMap.computeIfAbsent(role, e -> new HashSet()).add(principal);
        }

        Set<Role> getRoles() {
            return this.roleMap.keySet();
        }

        Set<Principal> getPrincipals(Role r) {
            return this.roleMap.get(r);
        }
    }
}

