/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.application;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FacesMessage
implements Serializable {
    private static final long serialVersionUID = -1180773928220076822L;
    public static final String FACES_MESSAGES = "jakarta.faces.Messages";
    private static final String SEVERITY_INFO_NAME = "INFO";
    public static final Severity SEVERITY_INFO = new Severity("INFO");
    private static final String SEVERITY_WARN_NAME = "WARN";
    public static final Severity SEVERITY_WARN = new Severity("WARN");
    private static final String SEVERITY_ERROR_NAME = "ERROR";
    public static final Severity SEVERITY_ERROR = new Severity("ERROR");
    private static final String SEVERITY_FATAL_NAME = "FATAL";
    public static final Severity SEVERITY_FATAL = new Severity("FATAL");
    private static final Severity[] values = new Severity[]{SEVERITY_INFO, SEVERITY_WARN, SEVERITY_ERROR, SEVERITY_FATAL};
    public static final List<Severity> VALUES = List.of(values);
    public static final Map<String, Severity> VALUES_MAP = Arrays.stream(values).collect(Collectors.toUnmodifiableMap(severity -> severity.severityName, Function.identity()));
    private transient Severity severity = SEVERITY_INFO;
    private transient String summary = null;
    private transient String detail = null;
    private transient boolean rendered;

    public FacesMessage() {
    }

    public FacesMessage(String summary) {
        this.setSummary(summary);
    }

    public FacesMessage(String summary, String detail) {
        this.setSummary(summary);
        this.setDetail(detail);
    }

    public FacesMessage(Severity severity, String summary, String detail) {
        this.setSeverity(severity);
        this.setSummary(summary);
        this.setDetail(detail);
    }

    public String getDetail() {
        if (this.detail == null) {
            return this.summary;
        }
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        if (severity.getOrdinal() < SEVERITY_INFO.getOrdinal() || severity.getOrdinal() > SEVERITY_FATAL.getOrdinal()) {
            throw new IllegalArgumentException(String.valueOf(severity));
        }
        this.severity = severity;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public boolean isRendered() {
        return this.rendered;
    }

    public void rendered() {
        this.rendered = true;
    }

    public int hashCode() {
        return Objects.hash(this.severity, this.summary, this.detail);
    }

    public boolean equals(Object object) {
        return object == this || object != null && object.getClass() == this.getClass() && Objects.equals(this.severity, ((FacesMessage)object).severity) && Objects.equals(this.summary, ((FacesMessage)object).summary) && Objects.equals(this.detail, ((FacesMessage)object).detail);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[severity='" + this.severity + "', summary='" + this.summary + "', detail='" + this.detail + "']";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.severity.getOrdinal());
        out.writeObject(this.summary);
        out.writeObject(this.detail);
        out.writeObject(this.rendered);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.severity = SEVERITY_INFO;
        this.summary = null;
        this.detail = null;
        int ordinal = in.readInt();
        if (ordinal == SEVERITY_INFO.getOrdinal()) {
            this.severity = SEVERITY_INFO;
        } else if (ordinal == SEVERITY_WARN.getOrdinal()) {
            this.severity = SEVERITY_WARN;
        } else if (ordinal == SEVERITY_ERROR.getOrdinal()) {
            this.severity = SEVERITY_ERROR;
        } else if (ordinal == SEVERITY_FATAL.getOrdinal()) {
            this.severity = SEVERITY_FATAL;
        }
        this.summary = (String)in.readObject();
        this.detail = (String)in.readObject();
        this.rendered = (Boolean)in.readObject();
    }

    public static class Severity
    implements Comparable {
        private final int ordinal = nextOrdinal++;
        String severityName;
        private static int nextOrdinal = 0;

        private Severity(String newSeverityName) {
            this.severityName = newSeverityName;
        }

        public int compareTo(Object severity) {
            return this.ordinal - ((Severity)severity).ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public String toString() {
            if (this.severityName == null) {
                return Integer.toString(this.ordinal);
            }
            return this.severityName + " " + this.ordinal;
        }
    }
}

