/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.connection;

import com.sun.corba.ee.impl.transport.connection.ConnectionCacheBlockingBase;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueue;
import com.sun.corba.ee.spi.transport.connection.Connection;
import com.sun.corba.ee.spi.transport.connection.InboundConnectionCache;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;

@Transport
public final class InboundConnectionCacheBlockingImpl<C extends Connection>
extends ConnectionCacheBlockingBase<C>
implements InboundConnectionCache<C> {
    private final Map<C, ConnectionState<C>> connectionMap = new HashMap<C, ConnectionState<C>>();

    @Override
    protected String thisClassName() {
        return "InboundConnectionCacheBlockingImpl";
    }

    public InboundConnectionCacheBlockingImpl(String cacheType, int highWaterMark, int numberToReclaim, long ttl) {
        super(cacheType, highWaterMark, numberToReclaim, ttl);
    }

    @InfoMethod
    private void display(String msg, Object value) {
    }

    @InfoMethod
    private void msg(String msg) {
    }

    @Override
    @Transport
    public synchronized void requestReceived(C conn) {
        int count;
        ConcurrentQueue.Handle reclaimHandle;
        ConnectionState<C> cs = this.getConnectionState(conn);
        int totalConnections = this.totalBusy + this.totalIdle;
        if (totalConnections > this.highWaterMark()) {
            this.reclaim();
        }
        if ((reclaimHandle = cs.reclaimableHandle) != null) {
            reclaimHandle.remove();
            this.display("removed from reclaimableQueue", conn);
        }
        if ((count = cs.busyCount++) == 0) {
            this.display("moved from idle to busy", conn);
            --this.totalIdle;
            ++this.totalBusy;
        }
    }

    @Override
    @Transport
    public synchronized void requestProcessed(C conn, int numResponsesExpected) {
        ConnectionState<C> cs = this.connectionMap.get(conn);
        if (cs == null) {
            this.msg("connection was closed");
            return;
        }
        cs.expectedResponseCount += numResponsesExpected;
        int numResp = cs.expectedResponseCount;
        int numBusy = --cs.busyCount;
        this.display("responses expected", numResp);
        this.display("connection busy count", numBusy);
        if (numBusy == 0) {
            --this.totalBusy;
            ++this.totalIdle;
            if (numResp == 0) {
                this.display("queuing reclaimable connection", conn);
                if (this.totalBusy + this.totalIdle > this.highWaterMark()) {
                    this.close(conn);
                } else {
                    cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
                }
            }
        }
    }

    @Override
    @Transport
    public synchronized void responseSent(C conn) {
        int waitCount;
        ConnectionState<C> cs = this.connectionMap.get(conn);
        if ((waitCount = --cs.expectedResponseCount) == 0) {
            this.display("reclaimable connection", conn);
            if (this.totalBusy + this.totalIdle > this.highWaterMark()) {
                this.close(conn);
            } else {
                cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
            }
        } else {
            this.display("wait count", waitCount);
        }
    }

    @Override
    @Transport
    public synchronized void close(C conn) {
        ConnectionState<C> cs = this.connectionMap.remove(conn);
        this.display("connection state", cs);
        int count = cs.busyCount;
        if (count == 0) {
            --this.totalIdle;
        } else {
            --this.totalBusy;
        }
        ConcurrentQueue.Handle rh = cs.reclaimableHandle;
        if (rh != null) {
            this.msg("connection was reclaimable");
            rh.remove();
        }
        try {
            conn.close();
        }
        catch (IOException exc) {
            this.display("close threw", exc);
        }
    }

    private ConnectionState<C> getConnectionState(C conn) {
        ConnectionState<C> result = this.connectionMap.get(conn);
        if (result == null) {
            result = new ConnectionState<C>(conn);
            this.connectionMap.put(conn, result);
            ++this.totalIdle;
        }
        return result;
    }

    private static final class ConnectionState<C extends Connection> {
        final C connection;
        int busyCount;
        int expectedResponseCount;
        ConcurrentQueue.Handle reclaimableHandle;

        ConnectionState(C conn) {
            this.connection = conn;
            this.busyCount = 0;
            this.expectedResponseCount = 0;
            this.reclaimableHandle = null;
        }
    }
}

