/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.sequence.invm;

import com.sun.xml.ws.rx.rm.runtime.LocalIDManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InMemoryLocalIDManager
implements LocalIDManager {
    private Map<String, LocalIDManager.BoundMessage> store = new HashMap<String, LocalIDManager.BoundMessage>();
    private static LocalIDManager instance = new InMemoryLocalIDManager();

    private InMemoryLocalIDManager() {
    }

    @Override
    public void createLocalID(String localID, String sequenceID, long messageNumber) {
        this.store.put(localID, new LocalIDManager.BoundMessage(sequenceID, messageNumber, System.currentTimeMillis(), 0L));
    }

    @Override
    public void removeLocalIDs(Iterator<String> localIDs) {
        if (localIDs != null) {
            while (localIDs.hasNext()) {
                this.store.remove(localIDs.next());
            }
        }
    }

    @Override
    public LocalIDManager.BoundMessage getBoundMessage(String localID) {
        return this.store.get(localID);
    }

    @Override
    public void markSequenceTermination(String sequenceID) {
        for (String localID : this.store.keySet()) {
            LocalIDManager.BoundMessage msg = this.store.get(localID);
            if (!sequenceID.equals(msg.sequenceID)) continue;
            LocalIDManager.BoundMessage updatedMsg = new LocalIDManager.BoundMessage(msg.sequenceID, msg.messageNumber, msg.createTime, System.currentTimeMillis());
            this.store.put(localID, updatedMsg);
        }
    }

    public static LocalIDManager getInstance() {
        return instance;
    }
}

