/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.util.ClientSniffer;
import com.sun.webui.jsf.util.ClientType;
import com.sun.webui.jsf.util.FocusManager;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;

public final class RenderingUtilities {
    private RenderingUtilities() {
    }

    public static void renderComponent(UIComponent component, FacesContext context) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        String id = component.getId();
        if (id != null) {
            component.setId(id);
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            for (UIComponent kid : component.getChildren()) {
                RenderingUtilities.renderComponent(kid, context);
            }
        }
        component.encodeEnd(context);
    }

    public static void writeStringAttributes(UIComponent component, ResponseWriter writer, String[] possibleAttributes) throws IOException {
        Map attributes = component.getAttributes();
        for (String attributeName : possibleAttributes) {
            Object attributeValue = attributes.get(attributeName);
            if (attributeValue == null) continue;
            writer.writeAttribute(attributeName.toLowerCase(), (Object)String.valueOf(attributeValue), attributeName);
        }
    }

    public static void writeStringAttributes(UIComponent component, ResponseWriter writer, String[] names, String extraHtml) throws IOException {
        if (component == null || names == null) {
            return;
        }
        Map attributes = component.getAttributes();
        for (String name : names) {
            Object value;
            if (extraHtml != null && (extraHtml.indexOf(name + "=") == 0 || extraHtml.contains(" " + name + "=")) || (value = attributes.get(name)) == null) continue;
            if (value instanceof String) {
                writer.writeAttribute(name.toLowerCase(), (Object)((String)value), name);
                continue;
            }
            writer.writeAttribute(name.toLowerCase(), (Object)value.toString(), name);
        }
        RenderingUtilities.renderExtraHtmlAttributes(writer, extraHtml);
    }

    public static void renderHiddenField(UIComponent component, ResponseWriter writer, String id, String value) throws IOException {
        if (id == null) {
            throw new IllegalArgumentException("An f:param tag had a null name attribute");
        }
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
    }

    public static String decodeHiddenField(FacesContext context, String parameterMapId) {
        Map params = context.getExternalContext().getRequestParameterMap();
        Object valueObject = params.get(parameterMapId);
        return (String)valueObject;
    }

    public static String getStyleClasses(FacesContext context, UIComponent component, String styles) {
        boolean componentNotVisible;
        Object styleClass = (String)component.getAttributes().get("styleClass");
        boolean bl = componentNotVisible = !RenderingUtilities.isVisible(component);
        if (componentNotVisible) {
            String hiddenStyleClass = ThemeUtilities.getTheme(context).getStyleClass("HIDDEN");
            styleClass = styleClass != null ? (String)styleClass + " " + hiddenStyleClass : hiddenStyleClass;
        }
        if (styleClass != null) {
            if (styles != null) {
                return (String)styleClass + " " + styles;
            }
            return styleClass;
        }
        if (styles != null) {
            return styles;
        }
        return null;
    }

    public static void renderStyleClass(FacesContext context, ResponseWriter writer, UIComponent component, String extraStyles) throws IOException {
        String classes = RenderingUtilities.getStyleClasses(context, component, extraStyles);
        if (classes != null) {
            writer.writeAttribute("class", (Object)classes, "styleClass");
        }
    }

    public static String renderStyleClass(FacesContext context, ResponseWriter writer, UIComponent component, String styleClass, String extraHtml) throws IOException {
        Object cssClass = styleClass;
        String xtraHtml = extraHtml;
        if (cssClass != null) {
            int first = -1;
            if (extraHtml != null && (first = extraHtml.indexOf("class=")) != -1) {
                try {
                    int quote = first + 6;
                    char ch = extraHtml.charAt(quote);
                    int last = extraHtml.indexOf(ch, quote + 1);
                    String s = extraHtml.substring(first, last + 1);
                    xtraHtml = xtraHtml.replaceAll(s, "");
                    s = s.substring(7, s.length() - 1);
                    cssClass = s + " " + (String)cssClass;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            RenderingUtilities.renderStyleClass(context, writer, component, (String)cssClass);
        }
        return xtraHtml;
    }

    public static boolean isPortlet(FacesContext context) {
        return !(context.getExternalContext().getContext() instanceof ServletContext);
    }

    public static String getLastClientID(FacesContext context) {
        return FocusManager.getRequestFocusElementId(context);
    }

    public static void setLastClientID(FacesContext context, String clientId) {
        FocusManager.setRequestFocusElementId(context, clientId);
    }

    public static String getFocusElementId(FacesContext context, UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof ComplexComponent) {
            return ((ComplexComponent)component).getFocusElementId(context);
        }
        return component.getClientId(context);
    }

    public static void renderSpacer(ResponseWriter writer, UIComponent component, String dotSrc, int height, int width) throws IOException {
        if (height == 0 && width == 0) {
            return;
        }
        writer.startElement("img", component);
        writer.writeAttribute("src", (Object)dotSrc, null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("height", (Object)height, null);
        writer.writeAttribute("width", (Object)width, null);
        writer.endElement("img");
    }

    public static void renderSpacer(FacesContext context, ResponseWriter writer, UIComponent component, int height, int width) throws IOException {
        if (height == 0 && width == 0) {
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        String dotSrc = theme.getImagePath("DOT");
        RenderingUtilities.renderSpacer(writer, component, dotSrc, height, width);
    }

    public static String getLabeledElementId(FacesContext context, String id) {
        UIComponent component;
        block6: {
            if (id == null || context == null) {
                return null;
            }
            String zId = id;
            char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
            if (id.charAt(0) != separatorChar) {
                zId = String.valueOf(separatorChar).concat(id);
            }
            component = null;
            try {
                component = context.getViewRoot().findComponent(zId);
            }
            catch (Exception e) {
                if (!LogUtil.fineEnabled()) break block6;
                LogUtil.fine("Component with that particular id cannot be found");
            }
        }
        if (component == null) {
            return id;
        }
        if (component instanceof ComplexComponent) {
            return ((ComplexComponent)component).getLabeledElementId(context);
        }
        return component.getClientId(context);
    }

    public static void renderStyleSheetLink(UIComponent component, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        ClientType clientType;
        String[] files = theme.getMasterStylesheets();
        if (files != null && files.length != 0) {
            RenderingUtilities.renderStylesheetLinks(files, component, writer);
        }
        if ((files = theme.getStylesheets((clientType = ClientSniffer.getClientType(context)).toString())) != null && files.length != 0) {
            RenderingUtilities.renderStylesheetLinks(files, component, writer);
        }
        if ((files = theme.getGlobalStylesheets()) != null && files.length != 0) {
            RenderingUtilities.renderStylesheetLinks(files, component, writer);
        }
    }

    public static void renderStylesheetLinks(String[] css, UIComponent component, ResponseWriter writer) throws IOException {
        for (String cs : css) {
            writer.startElement("link", component);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute("type", (Object)"text/css", null);
            writer.writeURIAttribute("href", (Object)cs, null);
            writer.endElement("link");
            writer.write("\n");
        }
    }

    public static void renderStyleSheetInline(UIComponent component, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        ClientType clientType;
        writer.startElement("style", component);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.write("\n");
        String[] files = theme.getMasterStylesheets();
        if (files != null && files.length != 0) {
            RenderingUtilities.renderImports(files, writer);
        }
        if ((files = theme.getStylesheets((clientType = ClientSniffer.getClientType(context)).toString())) != null && files.length != 0) {
            RenderingUtilities.renderImports(files, writer);
        }
        if ((files = theme.getGlobalStylesheets()) != null && files.length != 0) {
            RenderingUtilities.renderImports(files, writer);
        }
        writer.endElement("style");
    }

    public static void renderImports(String[] imports, ResponseWriter writer) throws IOException {
        for (String import1 : imports) {
            writer.write("@import(\"");
            writer.write(import1);
            writer.write("\");");
            writer.write("\n");
        }
    }

    public static void includeJsp(FacesContext context, ResponseWriter writer, String jspURI) throws IOException {
        if (jspURI == null) {
            return;
        }
        String zJspURI = jspURI;
        try {
            if (!zJspURI.startsWith("/")) {
                String contextPath = context.getExternalContext().getRequestContextPath();
                zJspURI = contextPath.concat("/").concat(zJspURI);
            }
            ServletRequest request = (ServletRequest)context.getExternalContext().getRequest();
            ServletResponse response = (ServletResponse)context.getExternalContext().getResponse();
            RequestDispatcher rd = request.getRequestDispatcher(zJspURI);
            class ResponseWrapper
            extends HttpServletResponseWrapper {
                private final PrintWriter printWriter;

                ResponseWrapper(HttpServletResponse response, Writer writer) {
                    super(response);
                    this.printWriter = new PrintWriter(writer);
                }

                public PrintWriter getWriter() {
                    return this.printWriter;
                }

                public ServletOutputStream getOutputStream() throws IOException {
                    throw new IllegalStateException();
                }

                public void resetBuffer() {
                }
            }
            rd.include(request, (ServletResponse)new ResponseWrapper((HttpServletResponse)response, (Writer)writer));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void renderExtraHtmlAttributes(ResponseWriter writer, String extraHtml) throws IOException {
        if (extraHtml == null) {
            return;
        }
        int n = extraHtml.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char quote;
            StringBuilder name = new StringBuilder();
            StringBuilder value = new StringBuilder();
            while (i < n && Character.isWhitespace(extraHtml.charAt(i))) {
                ++i;
            }
            block6: while (i < n) {
                char c2 = extraHtml.charAt(i);
                switch (c2) {
                    case '\"': 
                    case '\'': {
                        return;
                    }
                    case '=': {
                        break block6;
                    }
                    default: {
                        name.append(c2);
                        ++i;
                        continue block6;
                    }
                }
            }
            if ((quote = ++i < n ? extraHtml.charAt(i) : (char)'\u0000') != '\'' && quote != '\"') {
                return;
            }
            ++i;
            while (i < n && (c = extraHtml.charAt(i)) != quote) {
                value.append(c);
                ++i;
            }
            writer.writeAttribute(name.toString(), (Object)value.toString(), null);
        }
    }

    public static void renderURLAttribute(FacesContext context, ResponseWriter writer, UIComponent component, String name, String url, String compPropName) throws IOException {
        if (url == null) {
            return;
        }
        Param[] paramList = RenderingUtilities.getParamList(context, component);
        StringBuilder sb = new StringBuilder();
        int len = paramList.length;
        sb.append(url);
        if (0 < len) {
            sb.append("?");
        }
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                sb.append("&");
            }
            sb.append(paramList[i].getName());
            sb.append("=");
            sb.append(paramList[i].getValue());
        }
        String newName = null;
        if (compPropName != null) {
            newName = compPropName.equals(name) ? null : compPropName;
        }
        String value = url.trim().length() != 0 ? context.getExternalContext().encodeResourceURL(sb.toString()) : "";
        writer.writeURIAttribute(name, (Object)value, newName);
    }

    protected static Param[] getParamList(FacesContext context, UIComponent command) {
        ArrayList<Param> parameterList = new ArrayList<Param>();
        for (UIComponent kid : command.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            UIParameter uiParam = (UIParameter)kid;
            Object value = uiParam.getValue();
            String strValue = value == null ? null : value.toString();
            Param param = new Param(uiParam.getName(), strValue);
            parameterList.add(param);
        }
        return parameterList.toArray(new Param[parameterList.size()]);
    }

    public static void renderSkipLink(String anchorName, String styleClass, String style, String toolTip, Integer tabIndex, UIComponent component, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        } else {
            writer.writeAttribute("class", (Object)ThemeUtilities.getTheme(context).getStyleClass("SKIP_WHITE"), null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)styleClass, null);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("#").append(component.getClientId(context)).append("_").append(anchorName);
        writer.startElement("a", component);
        writer.writeAttribute("href", (Object)buffer.toString(), null);
        String defaultAlt = ThemeUtilities.getTheme(context).getMessage("skipLink.defaultAlt", new String[]{anchorName});
        if (toolTip != null) {
            writer.writeAttribute("alt", (Object)toolTip, null);
        } else {
            writer.writeAttribute("alt", (Object)defaultAlt, null);
        }
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", (Object)tabIndex.toString(), null);
        }
        Icon icon = ThemeUtilities.getIcon(ThemeUtilities.getTheme(context), "DOT");
        icon.setParent(component);
        icon.setWidth(1);
        icon.setHeight(1);
        icon.setBorder(0);
        if (toolTip == null) {
            icon.setToolTip(defaultAlt);
        } else {
            icon.setToolTip(toolTip);
        }
        buffer.setLength(0);
        buffer.append(anchorName).append("_icon");
        icon.setId(buffer.toString());
        RenderingUtilities.renderComponent((UIComponent)icon, context);
        writer.endElement("a");
        writer.endElement("div");
    }

    public static void renderAnchor(String anchorName, UIComponent component, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        StringBuilder buffer = new StringBuilder();
        buffer.append(component.getClientId(context));
        buffer.append("_");
        buffer.append(anchorName);
        writer.startElement("div", component);
        writer.write("\n");
        writer.startElement("a", component);
        writer.writeAttribute("name", (Object)buffer.toString(), null);
        writer.endElement("a");
        writer.write("\n");
        writer.endElement("div");
    }

    public static boolean isVisible(UIComponent component) {
        Object visible = component.getAttributes().get("visible");
        if (visible == null) {
            return true;
        }
        return (Boolean)visible;
    }

    protected static final class Param {
        private String name;
        private String value;

        public Param(String pName, String pValue) {
            this.set(pName, pValue);
        }

        public void set(String pName, String pValue) {
            this.name = pName;
            this.value = pValue;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

