/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.bridge.api.BridgeServiceManager;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.BridgeBaseContextAdapter;
import com.sun.messaging.jmq.jmsserver.BrokerShutdownHook;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.GlobalErrorHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.VMDiagnostics;
import com.sun.messaging.jmq.jmsserver.auth.MQAuthenticator;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.cluster.api.NoCluster;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.comm.CommBroker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMonitor;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.data.protocol.ProtocolImpl;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.net.tls.TLSProtocol;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.plugin.spi.CoreLifecycleSpi;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.jmsserver.service.PortMapper;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.ServiceRestriction;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.LockFile;
import com.sun.messaging.jmq.jmsserver.util.LoopbackAddressException;
import com.sun.messaging.jmq.jmsserver.util.StoreBeingTakenOverException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import com.sun.messaging.jmq.jmsservice.BrokerEventListener;
import com.sun.messaging.jmq.util.Debug;
import com.sun.messaging.jmq.util.DiagManager;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.MQThread;
import com.sun.messaging.jmq.util.PassfileObfuscatorImpl;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.logging.Level;

public class Broker
implements GlobalErrorHandler,
CommBroker {
    public static final String CLUSTER_BROADCASTER_SERVICE_NAME = "com.sun.messaging.jmq.jmsserver.multibroker.ClusterBroadcaster";
    static volatile Broker broker = null;
    private static final int DEFAULT_CLUSTER_VERSION = 500;
    private static final String MIN_JAVA_VERSION = "1.7";
    private BrokerResources rb = null;
    private Version version = null;
    private Store store = null;
    private boolean clearProps = false;
    private boolean saveProps = false;
    private boolean resetTakeoverThenExit = false;
    private Logger logger = null;
    private String adminKeyFile = null;
    private Hashtable debugAliases = null;
    public boolean startupComplete = false;
    private BrokerShutdownHook shutdownHook = null;
    private int diagInterval = -1;
    public boolean silent = false;
    public boolean force = false;
    public boolean background = false;
    public boolean initOnly = false;
    private boolean removeInstance = false;
    private boolean resetStore = false;
    private List<String> embeddedBrokerStartupMessages;
    private static BrokerEventListener bkrEvtListener = null;
    private static boolean runningInProcess = false;
    private String haltLogString = "HALT";
    private String dbPWProp = "imq.persist.jdbc.password";
    private String ldapPWProp = "imq.user_repository.ldap.password";
    private String keystorePWProp = "imq.keystore.password";
    private String bridgeManagerPWProp = "imq.bridge.admin.password";
    private boolean dbPWOverride = false;
    private boolean ldapPWOverride = false;
    private boolean keystorePWOverride = false;
    private boolean bridgeManagerPWOverride = false;
    static final String DEFAULT_PW_CONTENT = "admin:-2d5455c8583c24eec82c7a1e273ea02e:admin:1\nguest:-2c3c4a34aa2c392f39edd112333c230d:anonymous:1\n";
    static final String DEFAULT_ACL_CONTENT = "##########################################################\n# MQ access control file for JMQFileAccessControlModel\n##########################################################\n\nversion=JMQFileAccessControlModel/100\n\n########################################################\n# Please see the MQ Administration Guide for details\n# on how to customize access control\n#\n# (spaces in a rule are significant)\n########################################################\n\n# service connection access control\n##################################\n\nconnection.NORMAL.allow.user=*\nconnection.ADMIN.allow.group=admin\n\n# destination based access control\n##################################\n\nqueue.*.produce.allow.user=*\nqueue.*.consume.allow.user=*\nqueue.*.browse.allow.user=*\ntopic.*.produce.allow.user=*\ntopic.*.consume.allow.user=*\n\n\n# destination auto-create access control\n########################################\n\nqueue.create.allow.user=*\ntopic.create.allow.user=*\n\n# all permissions access control setup sample\n##############################################\n#connection.*.usernames=*\n#\n#queue.*.produce.allow.user=*\n#queue.*.consume.allow.user=*\n#queue.*.browse.allow.user=*\n#topic.*.produce.allow.user=*\n#topic.*.consume.allow.user=*\n\n#queue.create.allow.user=*\n#topic.create.allow.user=*\n##############################################\n";

    public static boolean isInProcess() {
        return runningInProcess;
    }

    @Override
    public boolean isInProcessBroker() {
        return Broker.isInProcess();
    }

    public void addEmbeddedBrokerStartupMessage(String embeddedBrokerStartupMessage) {
        if (this.embeddedBrokerStartupMessages == null) {
            this.embeddedBrokerStartupMessages = new ArrayList<String>();
        }
        this.embeddedBrokerStartupMessages.add(embeddedBrokerStartupMessage);
    }

    public static boolean imqcmdCanExit(boolean restartRequested) {
        if (bkrEvtListener != null) {
            BrokerEvent event = null;
            event = restartRequested ? new BrokerEvent(broker, BrokerEvent.Type.RESTART, "Broker is requesting restart") : new BrokerEvent(broker, BrokerEvent.Type.SHUTDOWN, "Broker is requesting shutdown");
            return bkrEvtListener.exitRequested(event, null);
        }
        return !Broker.isInProcess();
    }

    public static void setIsInProcess(boolean inprocess) {
        runningInProcess = inprocess;
    }

    private static void setBrokerEventListener(BrokerEventListener listen) {
        bkrEvtListener = listen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Broker getBroker() {
        Class<Broker> clazz = Broker.class;
        synchronized (Broker.class) {
            if (broker == null) {
                broker = new Broker();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return broker;
        }
    }

    public static void destroyBroker(boolean cleanup) {
        boolean triggerFailover = true;
        Broker.destroyBroker(cleanup, triggerFailover);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void destroyBroker(boolean cleanup, boolean triggerFailover) {
        if (broker == null) {
            return;
        }
        Broker tmp = broker;
        if (Globals.getBrokerStateHandler() != null) {
            Globals.getBrokerStateHandler().initiateShutdown("BrokerProcess", 0L, triggerFailover, 0, false, false, true);
        }
        if (cleanup) {
            PortMapper pm;
            BrokerMonitor.shutdownMonitor();
            Globals.getCoreLifecycle().cleanup();
            LockFile.clearLock();
            TLSProtocol.destroy();
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.stop();
                agent.unloadMBeans();
            }
            if ((pm = Globals.getPortMapper()) != null) {
                pm.destroy();
            }
            Globals.cleanup();
            Class<Broker> clazz = Broker.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsserver.Broker.class
            broker = null;
            // MONITOREXIT : clazz
        }
        if (bkrEvtListener == null) return;
        BrokerEvent event = new BrokerEvent(tmp, BrokerEvent.Type.SHUTDOWN, "Broker has been shutdown");
        bkrEvtListener.brokerEvent(event);
        Broker.setBrokerEventListener(null);
    }

    private Broker() {
        Globals.setCommBroker(this);
        this.version = Globals.getVersion();
        this.rb = Globals.getBrokerResources();
    }

    Properties convertArgs(String[] args) {
        Properties params = this.parseArgs(args);
        params.put("BrokerArgs", this.argsToString(args).trim());
        return params;
    }

    public static void initializePasswdFile() throws IOException {
        Logger logger = Globals.getLogger();
        BrokerConfig conf = Globals.getConfig();
        File localetcdir = new File(Globals.getInstanceEtcDir());
        if (!localetcdir.exists()) {
            if (!localetcdir.mkdir()) {
                String emsg = Globals.getBrokerResources().getKString("B3297", localetcdir);
                throw new IOException(emsg);
            }
            String aclfilename = conf.getProperty("imq.accesscontrol.file.filename", "accesscontrol.properties");
            File gACL = new File(Globals.getJMQ_ETC_HOME() + File.separator + aclfilename);
            File lACL = new File(localetcdir, aclfilename);
            String pwfilename = conf.getProperty("imq.user_repository.file.filename", "passwd");
            File gPW = new File(Globals.getJMQ_ETC_HOME() + File.separator + pwfilename);
            File lPW = new File(localetcdir, pwfilename);
            if (gACL.exists()) {
                try {
                    RandomAccessFile graf = new RandomAccessFile(gACL, "r");
                    FileChannel rfc = graf.getChannel();
                    RandomAccessFile oraf = new RandomAccessFile(lACL, "rw");
                    FileChannel wfc = oraf.getChannel();
                    wfc.transferFrom(rfc, 0L, graf.length());
                    rfc.close();
                    wfc.close();
                    graf.close();
                    oraf.close();
                    graf = new RandomAccessFile(gPW, "r");
                    rfc = graf.getChannel();
                    oraf = new RandomAccessFile(lPW, "rw");
                    wfc = oraf.getChannel();
                    wfc.transferFrom(rfc, 0L, graf.length());
                    rfc.close();
                    wfc.close();
                    graf.close();
                    oraf.close();
                    Object[] oargs = new Object[]{pwfilename, aclfilename, Globals.getJMQ_ETC_HOME()};
                    logger.logToAll(8, "B1119", oargs);
                }
                catch (IOException ex) {
                    logger.log(32, "Failed to copy files from the " + Globals.getJMQ_ETC_HOME() + " directory:", (Throwable)ex);
                    throw ex;
                }
            }
            try (FileOutputStream os1 = new FileOutputStream(lACL);
                 FileOutputStream os2 = new FileOutputStream(lPW);){
                os1.write(DEFAULT_ACL_CONTENT.getBytes());
                os2.write(DEFAULT_PW_CONTENT.getBytes());
            }
            catch (IOException ex) {
                logger.log(32, ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    int start(boolean inProcess, Properties params, BrokerEventListener bel, boolean initOnly, Throwable failStartThrowable) {
        Broker.setBrokerEventListener(bel);
        int startCode = this._start(inProcess, params, initOnly, failStartThrowable);
        if (bkrEvtListener != null) {
            BrokerEvent event = new BrokerEvent(this, BrokerEvent.Type.READY, "Broker has been started");
            bkrEvtListener.brokerEvent(event);
        }
        return startCode;
    }

    private int _start(boolean inProcess, Properties propsFromCommandLine, boolean initOnly, Throwable failStartThrowable) {
        try {
            String userrep;
            ClusterBroadcast mbus;
            Constructor<?> cons;
            boolean NO_CLUSTER;
            InetAddress ia;
            Broker.setIsInProcess(inProcess);
            Properties propsFromStdin = null;
            if (propsFromCommandLine != null && propsFromCommandLine.containsKey("imq.readstdin.enabled")) {
                propsFromStdin = this.readPropertiesFromStandardInput();
            }
            Properties combinedProps = new Properties();
            if (propsFromCommandLine != null) {
                combinedProps.putAll((Map<?, ?>)propsFromCommandLine);
            }
            if (propsFromStdin != null) {
                combinedProps.putAll((Map<?, ?>)propsFromStdin);
            }
            Globals.init(combinedProps, this.clearProps, this.saveProps);
            if (!this.removeInstance) {
                BrokerStateHandler.setShuttingDown(false);
                BrokerStateHandler.setShutdownStarted(false);
            }
            this.haltLogString = Globals.getBrokerResources().getKString("B2190");
            this.logger = Globals.getLogger();
            String configdir = Globals.getInstanceDir();
            File f = new File(configdir);
            if (!f.exists()) {
                while (!f.exists() && (f = f.getParentFile()) != null) {
                    if (!f.exists() || f.canWrite() && f.canRead()) continue;
                    String emsg = this.rb.getKString("B3124", f, Globals.getConfigName());
                    if (!this.silent) {
                        this.printErr(emsg);
                    }
                    if (failStartThrowable != null) {
                        failStartThrowable.initCause(new Exception(emsg));
                    }
                    return 12;
                }
            } else if (!f.canWrite() || !f.canRead()) {
                String emsg = this.rb.getKString("B3124", f, Globals.getConfigName());
                if (!this.silent) {
                    System.err.println(emsg);
                }
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(new Exception(emsg));
                }
                return 12;
            }
            if (this.removeInstance) {
                this.removeInstance();
            }
            try {
                this.parsePassfile();
            }
            catch (IOException ex) {
                this.logger.log(64, "B3037", (Throwable)ex);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(ex);
                }
                return 1;
            }
            try {
                Debug.setDebug((Properties)Globals.getConfig(), (String)"imq.debug.");
            }
            catch (Exception e) {
                this.logger.log(16, "B2014", (Throwable)e);
            }
            try {
                DiagManager.registerClasses((Properties)Globals.getConfig(), (String)"imq.diag.");
            }
            catch (Exception e) {
                this.logger.log(16, "B2071", (Throwable)e);
            }
            BrokerConfig conf = Globals.getConfig();
            try {
                this.checkBrokerConfig(conf);
            }
            catch (Exception e) {
                this.logger.logToAll(32, e.getMessage());
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(e);
                }
                return 1;
            }
            if (!Globals.isJMSRAManagedSpecified() && Globals.isJMSRAManagedBroker()) {
                String emsg = Globals.getBrokerResources().getKString("B3276");
                this.logger.log(32, emsg);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(new Exception(emsg));
                }
                return 1;
            }
            if (Globals.isJMSRAManagedBroker()) {
                try {
                    conf.updateBooleanProperty("imq.jmsra.managed", true, true);
                }
                catch (Exception e) {
                    this.logger.logStack(32, Globals.getBrokerResources().getKString("B3275", "imq.jmsra.managed=true", e.getMessage()), (Throwable)e);
                    if (failStartThrowable != null) {
                        failStartThrowable.initCause(e);
                    }
                    return 1;
                }
            }
            CoreLifecycleSpi coreLifecycle = Globals.getCoreLifecycle();
            String banner = this.version.getBanner(false, 0) + this.rb.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home");
            this.logger.logToAll(8, BrokerResources.NL + banner);
            if (!this.version.isProductValid()) {
                String emsg = this.rb.getKString("B3234");
                this.logger.log(32, emsg);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(new Exception(emsg));
                }
                return 1;
            }
            try {
                Broker.initializePasswdFile();
            }
            catch (IOException ex) {
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(ex);
                }
                return 1;
            }
            if (initOnly) {
                this.logger.log(8, "B1161");
                return 0;
            }
            if (!MQAuthenticator.authenticateCMDUserIfset()) {
                this.logger.log(8, "B1047");
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(new Exception("MQAuthenticator failed"));
                }
                return 1;
            }
            DiagManager.register((DiagManager.Data)new VMDiagnostics());
            if (Version.compareVersions(System.getProperty("java.specification.version"), MIN_JAVA_VERSION, true) < 0) {
                String emsg = this.rb.getKString("B3154", System.getProperty("java.specification.version"), MIN_JAVA_VERSION);
                this.logger.logToAll(32, emsg);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(new Exception(emsg));
                }
                return 1;
            }
            String hostname = conf.getProperty("imq.hostname");
            Globals.setHostname(hostname);
            if (hostname == null || hostname.equals("*")) {
                try {
                    ia = InetAddress.getLocalHost();
                    Globals.setBrokerInetAddress(ia);
                }
                catch (UnknownHostException e) {
                    this.logger.log(32, "B3152", (Throwable)e);
                    this.logger.log(8, "B0010");
                    if (failStartThrowable != null) {
                        failStartThrowable.initCause(e);
                    }
                    return 1;
                }
            }
            try {
                ia = InetAddress.getByName(hostname);
                Globals.setBrokerInetAddress(ia);
            }
            catch (UnknownHostException e) {
                this.logger.log(32, this.rb.getString("B3151", hostname, "imq.hostname"), (Throwable)e);
                this.logger.log(8, "B0010");
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(e);
                }
                return 1;
            }
            String jmxHostname = conf.getProperty("imq.jmx.hostname");
            Globals.setJMXHostname(jmxHostname);
            if (jmxHostname != null && !jmxHostname.equals("*")) {
                try {
                    InetAddress ia2 = InetAddress.getByName(jmxHostname);
                    Globals.setJMXInetAddress(ia2);
                }
                catch (UnknownHostException e) {
                    this.logger.log(32, this.rb.getString("B3151", hostname, "imq.jmx.hostname"), (Throwable)e);
                    this.logger.log(8, "B0010");
                    if (failStartThrowable != null) {
                        failStartThrowable.initCause(e);
                    }
                    return 1;
                }
            }
            try {
                this.logger.logToAll(8, "   IMQ_HOME=" + new File(Globals.getJMQ_HOME()).getCanonicalPath());
                this.logger.logToAll(8, "IMQ_VARHOME=" + new File(Globals.getJMQ_VAR_HOME()).getCanonicalPath());
            }
            catch (IOException e) {
                // empty catch block
            }
            this.logger.logToAll(8, System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + " " + Globals.getBrokerHostName() + " (" + Runtime.getRuntime().availableProcessors() + " cpu) " + System.getProperty("user.name"));
            this.logger.logToAll(8, this.rb.getString("B1086"), (Object)Long.toString(Runtime.getRuntime().maxMemory() / 1024L), (Object)Long.toString(Runtime.getRuntime().totalMemory() / 1024L));
            this.logger.logToAll(8, this.rb.getString("B1055"), propsFromCommandLine == null ? "" : propsFromCommandLine.get("BrokerArgs"));
            this.logProperties("JMSRA BrokerProps: ", propsFromStdin);
            if (this.embeddedBrokerStartupMessages != null) {
                for (String thisMessage : this.embeddedBrokerStartupMessages) {
                    this.logger.logToAll(8, thisMessage);
                }
            }
            this.logProperties(this.rb.getString("B1384"), propsFromCommandLine);
            if (inProcess) {
                this.logger.logToAll(8, this.rb.getString("B1299"));
            }
            Globals.setGlobalErrorHandler(this);
            String key = this.getAdminKey(this.adminKeyFile);
            String propname = "imq.adminkey";
            if (key == null || key.length() == 0) {
                conf.remove(propname);
            } else {
                try {
                    conf.updateProperty(propname, key);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean isHA = Globals.getHAEnabled();
            String brokerid = Globals.getBrokerID();
            String clusterid = Globals.getClusterID();
            if (Globals.getHAEnabled()) {
                if (brokerid == null) {
                    String emsg = this.rb.getKString("B3197");
                    this.logger.logToAll(32, emsg);
                    if (failStartThrowable != null) {
                        failStartThrowable.initCause(new Exception(emsg));
                    }
                    return 1;
                }
                this.logger.log(8, "B1202", (Object)brokerid, (Object)clusterid);
            } else if (brokerid != null) {
                this.logger.log(8, "B1203", (Object)brokerid);
            }
            PortMapper pm = Globals.getPortMapper();
            if (pm == null || pm.getServerSocket() == null && pm.isDoBind() && Globals.getPUService() == null) {
                String emsg = this.rb.getString("B3315");
                this.logger.logToAll(32, emsg);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(new Exception(emsg));
                }
                return 1;
            }
            BrokerMQAddress addr = null;
            try {
                addr = BrokerMQAddress.createAddress(Globals.getBrokerHostName(), pm.getPort());
            }
            catch (Exception e) {
                this.logger.logStack(8, "B3157", (Object)("[" + Globals.getBrokerHostName() + "]:" + pm.getPort()), (Throwable)e);
            }
            try {
                NO_CLUSTER = Globals.initClusterManager(addr);
                if (NO_CLUSTER) {
                    this.logger.log(16, "B1137");
                }
            }
            catch (Exception e) {
                this.logger.logStack(32, "B3198", (Throwable)e);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(e);
                }
                return 1;
            }
            if (Globals.useMasterBroker() && Globals.dynamicChangeMasterBrokerEnabled() && !Globals.isJMSRAManagedBroker() && Globals.isMasterBrokerSpecified()) {
                String emsg = Globals.getBrokerResources().getKString("B4355", "imq.cluster.masterbroker", "imq.cluster.dynamicChangeMasterBrokerEnabled=true");
                this.logger.log(32, emsg);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(new Exception(emsg));
                }
                return 1;
            }
            pm.updateProperties();
            if (pm.isDoBind()) {
                if (Globals.getPUService() == null) {
                    MQThread portMapperThread = new MQThread((Runnable)pm, "JMQPortMapper");
                    portMapperThread.setDaemon(true);
                    portMapperThread.start();
                } else {
                    try {
                        pm.startPUService();
                    }
                    catch (Exception e) {
                        this.logger.logStack(32, e.getMessage(), (Throwable)e);
                        if (failStartThrowable != null) {
                            failStartThrowable.initCause(e);
                        }
                        return 1;
                    }
                }
            }
            LockFile lf = null;
            try {
                lf = LockFile.getLock(conf.getProperty("imq.varhome"), Globals.getConfigName(), pm.getHostname() == null || pm.getHostname().equals("") ? Globals.getMQAddress().getHostName() : pm.getMQAddress().getHostName(), pm.getPort(), Globals.getUseFileLockForLockFile());
            }
            catch (Exception e) {
                Object[] msgargs = new Object[]{LockFile.getLockFilePath(conf.getProperty("imq.varhome"), Globals.getConfigName()), e.toString(), Globals.getConfigName()};
                this.logger.logStack(32, "B3086", msgargs, (Throwable)e);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(e);
                }
                return 1;
            }
            if (!lf.isMyLock()) {
                Object[] msgargs = new Object[]{lf.getFilePath(), lf.getHost() + ":" + lf.getPort(), Globals.getConfigName()};
                String emsg = this.rb.getKString("B3087", msgargs);
                this.logger.log(32, emsg);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(new Exception(emsg));
                }
                return 1;
            }
            if (this.resetStore) {
                Globals.getAuditSession().storeOperation(null, null, "reset store");
                if (isHA) {
                    this.logger.log(16, "B2108");
                }
            }
            try {
                Globals.isMinimumPersist();
                this.store = Globals.getStore();
            }
            catch (BrokerException ex) {
                this.logger.logStack(32, "B3000", (Throwable)ex);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(ex);
                }
                return 1;
            }
            if (Globals.useSharedConfigRecord()) {
                try {
                    Globals.getStore().getShareConfigChangeStore();
                }
                catch (BrokerException ex) {
                    this.logger.logStack(32, "B3251", (Throwable)ex);
                    if (failStartThrowable != null) {
                        failStartThrowable.initCause(ex);
                    }
                    return 1;
                }
            }
            BridgeServiceManager bridgeManager = null;
            if (BridgeBaseContextAdapter.bridgeEnabled() && !Globals.isNucleusManagedBroker()) {
                this.logger.log(8, "B1318");
                try {
                    Class<?> c = Class.forName(BridgeBaseContextAdapter.getManagerClass());
                    bridgeManager = (BridgeServiceManager)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    bridgeManager.init(new BridgeBaseContextAdapter(this, this.resetStore));
                }
                catch (Throwable t) {
                    bridgeManager = null;
                    this.logger.logStack(16, Globals.getBrokerResources().getKString("B2216"), t);
                }
            }
            HAMonitorService haMonitor = null;
            if (Globals.getHAEnabled()) {
                try {
                    String cname = "com.sun.messaging.jmq.jmsserver.cluster.manager.ha.HAMonitorServiceImpl";
                    if (Globals.getHAEnabled()) {
                        this.logger.log(8, "B1204");
                        if (Globals.isNucleusManagedBroker()) {
                            haMonitor = (HAMonitorService)Globals.getHabitat().getService(HAMonitorService.class, cname, new Annotation[0]);
                            if (haMonitor == null) {
                                throw new BrokerException("Class " + cname + " not found");
                            }
                            haMonitor.init(Globals.getClusterID(), Globals.getMQAddress(), this.resetTakeoverThenExit);
                        } else {
                            c = Class.forName(cname);
                            Class[] paramTypes = new Class[]{String.class, MQAddress.class, Boolean.class};
                            Object[] paramArgs = new Object[]{Globals.getClusterID(), Globals.getMQAddress(), this.resetTakeoverThenExit};
                            cons = c.getConstructor(paramTypes);
                            haMonitor = (HAMonitorService)cons.newInstance(paramArgs);
                        }
                        if (this.resetTakeoverThenExit) {
                            return 0;
                        }
                    } else if (Globals.isNucleusManagedBroker()) {
                        haMonitor = (HAMonitorService)Globals.getHabitat().getService(HAMonitorService.class, cname, new Annotation[0]);
                        if (haMonitor == null) {
                            throw new BrokerException("Class " + cname + " not found");
                        }
                    } else {
                        c = Class.forName(cname);
                        haMonitor = (HAMonitorService)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    Globals.setHAMonitorService(haMonitor);
                }
                catch (Exception ex) {
                    this.logger.logStack(32, "B3199", (Throwable)ex);
                    if (ex instanceof StoreBeingTakenOverException) {
                        if (failStartThrowable != null) {
                            failStartThrowable.initCause(ex);
                        }
                        return BrokerStateHandler.getRestartCode();
                    }
                    if (failStartThrowable != null) {
                        failStartThrowable.initCause(ex);
                    }
                    return 1;
                }
                if (Globals.getHAEnabled()) {
                    this.logger.log(8, "B1205");
                    try {
                        Class<?> c = Class.forName("com.sun.messaging.jmq.jmsserver.multibroker.heartbeat.HeartbeatService");
                        Object hbs = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Globals.registerHeartbeatService(hbs);
                    }
                    catch (Exception e) {
                        this.logger.logStack(32, "B3200", (Throwable)e);
                        if (failStartThrowable != null) {
                            failStartThrowable.initCause(e);
                        }
                        return 1;
                    }
                }
            }
            try {
                this.store.addPartitionListener(Globals.getClusterManager());
                this.store.partitionsReady();
            }
            catch (Exception e) {
                this.logger.logStack(32, e.getMessage(), (Throwable)e);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(e);
                }
                return 1;
            }
            if (NO_CLUSTER) {
                mbus = new NoCluster();
                this.logger.log(64, Globals.getBrokerResources().getKString("B1189", Globals.getBrokerResources().getString("B0075")));
            } else {
                try {
                    String cname = CLUSTER_BROADCASTER_SERVICE_NAME;
                    if (Globals.isNucleusManagedBroker()) {
                        mbus = (ClusterBroadcast)Globals.getHabitat().getService(ClusterBroadcast.class, cname, new Annotation[0]);
                        if (mbus == null) {
                            String emsg = "Failed to init cluster service because class " + cname + " not found";
                            if (Globals.getHAEnabled() || Globals.getClusterManager().getConfigBrokerCount() > 0) {
                                this.logger.log(32, emsg);
                                if (failStartThrowable != null) {
                                    failStartThrowable.initCause(new Exception(emsg));
                                }
                                return 1;
                            }
                            throw new BrokerException(emsg);
                        }
                        mbus.init(500);
                    } else {
                        Class<?> c = Class.forName(cname);
                        Class[] paramTypes = new Class[]{Integer.class};
                        cons = c.getConstructor(paramTypes);
                        Object[] paramArgs = new Object[]{500};
                        mbus = (ClusterBroadcast)cons.newInstance(paramArgs);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.logger.logStack(4, "B3100", (Object)"unable to use cluster broadcaster", (Throwable)cnfe);
                    this.logger.log(16, "B1137: " + String.valueOf(cnfe));
                    mbus = new NoCluster();
                }
                catch (InvocationTargetException ite) {
                    Throwable ex = ite.getCause();
                    if (ex instanceof InvocationTargetException) {
                        ex = ex.getCause();
                    }
                    if (!(ex instanceof LoopbackAddressException)) {
                        this.logger.logStack(8, "B4117", (Object)ex.getMessage(), ex);
                    }
                    this.logger.log(16, "B1137");
                    mbus = new NoCluster();
                }
                catch (Exception ex) {
                    this.logger.logStack(16, "Unable to use cluster broadcaster", (Throwable)ex);
                    this.logger.log(16, "B1137");
                    mbus = new NoCluster();
                }
            }
            Globals.setClusterBroadcast(mbus);
            Globals.setMyAddress(mbus.getMyAddress());
            String type = Globals.getConfig().getProperty("imq.authentication.type");
            if (type != null && (userrep = Globals.getConfig().getProperty("imq.authentication." + type + ".user_repository")).equals("ldap")) {
                String DN = Globals.getConfig().getProperty("imq.user_repository." + userrep + ".principal");
                String pwd = Globals.getConfig().getProperty("imq.user_repository." + userrep + ".password");
                if (DN != null && DN.trim().length() > 0 && (pwd == null || pwd.trim().length() == 0)) {
                    boolean setProp;
                    Password pw = null;
                    boolean bl = setProp = pwd == null || pwd.equals("");
                    for (int retry = 0; (pwd == null || pwd.trim().equals("")) && retry < 5; ++retry) {
                        pw = new Password();
                        if (pw.echoPassword()) {
                            System.err.println(Globals.getBrokerResources().getString("B2242"));
                        }
                        System.err.print(Globals.getBrokerResources().getString("B0031", DN));
                        System.err.flush();
                        pwd = pw.getPassword();
                    }
                    if (pwd == null || pwd.trim().equals("")) {
                        this.logger.log(16, "B2078", (Object)pwd);
                        Globals.getConfig().put("imq.user_repository." + userrep + ".principal", "");
                    } else if (setProp) {
                        Globals.getConfig().put("imq.user_repository." + userrep + ".password", pwd);
                    }
                }
            }
            ConnectionManager cmgr = new ConnectionManager();
            Globals.setConnectionManager(cmgr);
            try {
                coreLifecycle.getDestinationList();
                DestinationList.addPartitionListener(Globals.getClusterManager());
                coreLifecycle.initDestinations();
                coreLifecycle.initSubscriptions();
                BrokerMonitor.init();
            }
            catch (BrokerException ex) {
                this.logger.logStack(32, "B3101", (Throwable)ex);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(ex);
                }
                return 1;
            }
            try {
                Class.forName("javax.management.MBeanServer");
                Agent agent = new Agent();
                Globals.setAgent(agent);
                agent.start();
            }
            catch (Exception e) {
                this.logger.log(16, "JMX classes not present - JMX Agent is not created.");
            }
            Selector.setConvertTypes((boolean)conf.getBooleanProperty("imq.selector.convertTypes", false));
            Selector.setShortCircuit((boolean)conf.getBooleanProperty("imq.selector.shortCircuit", true));
            Selector.setShortCircuitCompileTimeTest((boolean)conf.getBooleanProperty("imq.selector.shortCircuitCompileTimeTest", true));
            PacketRouter pktrtr = new PacketRouter();
            PacketRouter admin_pktrtr = new PacketRouter();
            AdminDataHandler admin_datahdrl = new AdminDataHandler();
            Globals.setProtocol(new ProtocolImpl(pktrtr));
            try {
                coreLifecycle.initHandlers(pktrtr, cmgr, admin_pktrtr, admin_datahdrl);
            }
            catch (Exception e) {
                this.logger.logStack(32, e.getMessage(), (Throwable)e);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(e);
                }
                return 1;
            }
            try {
                PacketRouter pkr = new PacketRouter();
                CoreLifecycleSpi clc = Globals.getCorePlugin("COHERENCE_MESSAGE_PATTERN");
                if (clc != null) {
                    Class.forName("com.oracle.coherence.patterns.messaging.DefaultMessagingSession");
                    clc.initHandlers(pkr, cmgr, null, null);
                }
            }
            catch (Exception e) {
                this.logger.logStack(32, e.getMessage(), (Throwable)e);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(e);
                }
                return 1;
            }
            admin_datahdrl.setPacketRouter(admin_pktrtr);
            PacketRouter[] routers = new PacketRouter[]{pktrtr, admin_pktrtr};
            Globals.setPacketRouters(routers);
            if (Globals.useSharedConfigRecord()) {
                try {
                    mbus.syncChangeRecordOnStartup();
                }
                catch (Exception e) {
                    this.logger.logStack(32, this.rb.getKString("B3261", Globals.getClusterID(), e.getMessage()), (Throwable)e);
                    if (failStartThrowable != null) {
                        failStartThrowable.initCause(e);
                    }
                    return 1;
                }
            }
            TLSProtocol.init();
            ServiceManager sm = new ServiceManager(cmgr);
            Globals.setServiceManager(sm);
            List allActiveServiceNames = sm.getAllActiveServiceNames();
            if (allActiveServiceNames.isEmpty()) {
                String noActiveServiceMessage = this.rb.getKString("B3316");
                this.logger.log(32, noActiveServiceMessage);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(new RuntimeException(noActiveServiceMessage));
                }
                return 1;
            }
            sm.updateServiceList(allActiveServiceNames, 1, false);
            if (mbus.waitForConfigSync()) {
                sm.updateServiceList(sm.getAllActiveServiceNames(), 0, true);
                if (Globals.nowaitForMasterBroker()) {
                    sm.addServiceRestriction(0, ServiceRestriction.NO_SYNC_WITH_MASTERBROKER);
                    this.logger.log(16, "B1262");
                    try {
                        sm.resumeAllActiveServices(0, true);
                    }
                    catch (BrokerException e) {
                        this.logger.logStack(32, e.getMessage(), (Throwable)e);
                    }
                } else {
                    this.logger.log(16, "B1073");
                }
            } else {
                sm.updateServiceList(sm.getAllActiveServiceNames(), 0, false, true);
            }
            Globals.setBrokerStateHandler(new BrokerStateHandler());
            boolean noShutdownHook = Boolean.getBoolean("imq.noShutdownHook");
            if (inProcess || noShutdownHook || (this.shutdownHook = this.addBrokerShutdownHook()) == null) {
                this.logger.log(4, "B1050");
            } else {
                this.logger.log(4, "B1049");
            }
            if (!inProcess) {
                Globals.getMemManager().startManagement();
            } else {
                Globals.setMemMgrOn(false);
            }
            MetricManager mm = new MetricManager();
            Globals.setMetricManager(mm);
            mm.setParameters(Globals.getConfig());
            Properties matchProps = new Properties();
            matchProps.setProperty("imq.useFileLockForLockFile.enabled", String.valueOf(Globals.getUseFileLockForLockFile()));
            matchProps.setProperty("imq.autocreate.queue", Globals.getConfig().getProperty("imq.autocreate.queue", "false"));
            matchProps.setProperty("imq.autocreate.topic", Globals.getConfig().getProperty("imq.autocreate.topic", "false"));
            if (Globals.getClusterID() != null) {
                matchProps.setProperty("imq.cluster.clusterid", Globals.getClusterID());
            }
            if (isHA) {
                matchProps.setProperty("imq.cluster.ha", Globals.getConfig().getProperty("imq.cluster.ha"));
                matchProps.setProperty("imq.persist.store", Globals.getConfig().getProperty("imq.persist.store"));
                if (Globals.getJDBCHAEnabled()) {
                    matchProps.setProperty("imq.cluster.monitor.interval", String.valueOf(haMonitor.getMonitorInterval()));
                    matchProps.setProperty("imq.cluster.heartbeat.class", Globals.getConfig().getProperty("imq.cluster.heartbeat.class"));
                }
                matchProps.setProperty("imq.service.activelist", Globals.getConfig().getProperty("imq.service.activelist"));
                matchProps.setProperty("imq.bridge.enabled", Globals.getConfig().getProperty("imq.bridge.enabled", "false"));
            } else if (Globals.isNewTxnLogEnabled()) {
                matchProps.setProperty("imq.persist.file.newTxnLog.enabled", "true");
            }
            if (Globals.getConfig().getProperty("imq.cluster.autocluster.brokermapclass") != null) {
                matchProps.setProperty("imq.cluster.autocluster.brokermapclass", Globals.getConfig().getProperty("imq.cluster.autocluster.brokermapclass"));
            }
            if (Globals.getClusterManager().getMasterBroker() != null && Globals.nowaitForMasterBroker()) {
                matchProps.setProperty("imq.cluster.nowaitForMasterBroker", "true");
            }
            if (Globals.useMasterBroker() && Globals.dynamicChangeMasterBrokerEnabled()) {
                matchProps.setProperty("imq.cluster.dynamicChangeMasterBrokerEnabled", "true");
            }
            if (Globals.useSharedConfigRecord()) {
                matchProps.setProperty("imq.cluster.nomasterbroker", "true");
            }
            try {
                Map<String, String> props = Globals.getStore().getClusterMatchProperties();
                Map.Entry<String, String> pair2 = null;
                for (Map.Entry<String, String> pair2 : props.entrySet()) {
                    matchProps.setProperty(pair2.getKey(), pair2.getValue());
                }
            }
            catch (Exception e) {
                this.logger.logStack(32, e.getMessage(), (Throwable)e);
                if (failStartThrowable != null) {
                    failStartThrowable.initCause(e);
                }
                return 1;
            }
            mbus.setMatchProps(matchProps);
            mbus.startClusterIO();
            this.startupComplete = true;
            Globals.getAuditSession().brokerOperation(null, null, "broker startup");
            Object[] sargs = new Object[]{Globals.getConfigName() + "@" + (pm.getHostname() == null || pm.getHostname().equals("") ? Globals.getMQAddress().getHostName() : pm.getMQAddress().getHostName()) + ":" + pm.getPort()};
            this.logger.logToAll(8, "B1039", sargs);
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.loadMBeans();
            }
            if (BridgeBaseContextAdapter.bridgeEnabled() && bridgeManager != null) {
                try {
                    Globals.getBrokerResources();
                    this.logger.log(8, "B1319");
                    bridgeManager.start();
                    Globals.setBridgeServiceManager(bridgeManager);
                    Globals.getBrokerResources();
                    this.logger.log(8, "B1320");
                }
                catch (Throwable t) {
                    Globals.getBrokerResources();
                    this.logger.logStack(16, "B2217", t);
                }
            }
        }
        catch (OutOfMemoryError err) {
            Globals.handleGlobalError(err, this.rb.getKString("B0017"), 1);
            if (failStartThrowable != null) {
                failStartThrowable.initCause(err);
            }
            return 1;
        }
        if (this.diagInterval > 0) {
            MQTimer timer = Globals.getTimer();
            int _interval = this.diagInterval * 1000;
            timer.schedule((TimerTask)new BrokerDiagTask(), (long)_interval, (long)_interval);
        } else if (this.diagInterval == 0) {
            this.logger.log(8, DiagManager.allToString());
        }
        return 0;
    }

    private void checkBrokerConfig(BrokerConfig bcf) throws BrokerException {
        int val = bcf.getIntProperty("imq.autocreate.queue.maxNumActiveConsumers", -1);
        if (val == 0 || val < -1) {
            String emsg = Globals.getBrokerResources().getKString("B4358", "imq.autocreate.queue.maxNumActiveConsumers", String.valueOf(val));
            throw new BrokerException(emsg);
        }
        val = bcf.getIntProperty("imq.autocreate.destination.maxNumProducers", 100);
        if (val == 0 || val < -1) {
            String emsg = Globals.getBrokerResources().getKString("B4359", "imq.autocreate.destination.maxNumProducers", String.valueOf(val));
            throw new BrokerException(emsg);
        }
    }

    private String argsToString(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(arg);
            sb.append(' ');
        }
        return sb.toString();
    }

    private Properties parseArgs(String[] args) {
        Properties props = new Properties();
        boolean logLevelSet = false;
        for (int n = 0; n < args.length; ++n) {
            if (args[n].equals("-loglevel")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing log argument");
                }
                try {
                    int legacyLogLevel = Logger.levelStrToInt((String)args[n]);
                    Level julLevel = Logger.levelIntToJULLevel((int)legacyLogLevel);
                    props.put(".level", julLevel.getName());
                    logLevelSet = true;
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.printErr(this.rb.getString("B0003"));
                    throw new IllegalArgumentException("Bad log level");
                }
            }
            if (args[n].equals("-save")) {
                this.saveProps = true;
                continue;
            }
            if (args[n].equals("-shared")) {
                props.put("imq.jms.threadpool_model", "shared");
                continue;
            }
            if (args[n].equals("-debug")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing debug argument");
                }
                if (!logLevelSet) {
                    props.put(".level", Level.FINEST.getName());
                }
                if (this.enableDebug(args[n], props)) continue;
                throw new IllegalArgumentException("bad debug argument");
            }
            if (args[n].equals("-dbuser")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing dbuser argument");
                }
                props.put("imq.persist.jdbc.user", args[n]);
                continue;
            }
            if (args[n].equals("-dbpassword")) {
                this.printPasswordError(args[n]);
                throw new IllegalArgumentException("argument unsupported");
            }
            if (args[n].equals("-dbpwd")) {
                this.printPasswordWarning(args[n]);
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing dbpassword argument");
                }
                props.put(this.dbPWProp, args[n]);
                this.dbPWOverride = true;
                continue;
            }
            if (args[n].equals("-diag")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing diag interval");
                }
                try {
                    this.diagInterval = Integer.parseInt(args[n]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("bad diag interval");
                }
            }
            if (args[n].equals("-name")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing broker instancename");
                }
                props.put("imq.instancename", args[n]);
                continue;
            }
            if (args[n].equals("-port")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing port");
                }
                props.put("imq.portmapper.port", args[n]);
                continue;
            }
            if (args[n].equals("-nobind")) {
                props.put("imq.portmapper.bind", "false");
                continue;
            }
            if (args[n].equals("-metrics")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing metrics");
                }
                props.put("imq.metrics.interval", args[n]);
                continue;
            }
            if (args[n].equals("-password")) {
                this.printPasswordError(args[n]);
                throw new IllegalArgumentException("argument unsupported");
            }
            if (args[n].equals("-pwd")) {
                this.printPasswordWarning(args[n]);
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing password");
                }
                props.put(this.keystorePWProp, args[n]);
                this.keystorePWOverride = true;
                continue;
            }
            if (args[n].equals("-ldappassword")) {
                this.printPasswordError(args[n]);
                throw new IllegalArgumentException("argument unsupported");
            }
            if (args[n].equals("-ldappwd")) {
                this.printPasswordWarning(args[n]);
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing ldab password");
                }
                props.put(this.ldapPWProp, args[n]);
                this.ldapPWOverride = true;
                continue;
            }
            if (args[n].equals("-read-stdin")) {
                props.put("imq.readstdin.enabled", "true");
                continue;
            }
            if (args[n].equals("-passfile")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing passfile name");
                }
                File passfile = null;
                try {
                    passfile = new File(args[n]).getCanonicalFile();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("unknown passfile: " + String.valueOf(e));
                }
                props.put("imq.passfile.enabled", "true");
                props.put("imq.passfile.dirpath", passfile.getParent());
                props.put("imq.passfile.name", passfile.getName());
                continue;
            }
            if (args[n].equals("-backup")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing backup argument");
                }
                props.put("imq.cluster.masterbroker.backup", args[n]);
                continue;
            }
            if (args[n].equals("-restore")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing restore argument");
                }
                props.put("imq.cluster.masterbroker.restore", args[n]);
                continue;
            }
            if (args[n].equals("-cluster")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing cluster list");
                }
                props.put("imq.cluster.brokerlist.manual", args[n]);
                continue;
            }
            if (args[n].equals("-force")) {
                this.force = true;
                continue;
            }
            if (args[n].equals("-silent") || args[n].equals("-s")) {
                props.put("java.util.logging.ConsoleHandler.level", Level.OFF.getName());
                this.silent = true;
                continue;
            }
            if (args[n].equals("-ttyerrors") || args[n].equals("-te")) {
                props.put("java.util.logging.ConsoleHandler.level", Level.SEVERE.getName());
                continue;
            }
            if (args[n].equals("-tty")) {
                props.put("java.util.logging.ConsoleHandler.level", Level.ALL.getName());
                continue;
            }
            if (args[n].startsWith("-D")) {
                int value_index = 0;
                String prop_name = null;
                String prop_value = "";
                value_index = args[n].indexOf(61);
                if (args[n].length() <= 2) continue;
                if (value_index < 0) {
                    prop_name = args[n].substring(2);
                } else if (value_index == args[n].length() - 1) {
                    prop_name = args[n].substring(2, value_index);
                } else {
                    prop_name = args[n].substring(2, value_index);
                    prop_value = args[n].substring(value_index + 1);
                }
                props.put(prop_name, prop_value);
                continue;
            }
            if (args[n].equals("-varhome") || args[n].equals("-jmqvarhome")) {
                ++n;
                continue;
            }
            if (args[n].equals("-imqhome")) {
                ++n;
                continue;
            }
            if (args[n].equals("-libhome")) {
                ++n;
                continue;
            }
            if (args[n].equals("-javahome")) {
                ++n;
                continue;
            }
            if (args[n].equals("-jrehome")) {
                ++n;
                continue;
            }
            if (args[n].equals("-bgnd")) {
                this.background = true;
                continue;
            }
            if (args[n].equals("-init")) {
                this.initOnly = true;
                continue;
            }
            if (args[n].equals("-version") || args[n].equals("-v")) {
                Globals.pathinit(System.getProperties());
                this.println(this.version.getBanner(true));
                this.println(this.rb.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
                this.println(this.rb.getString("B1054") + System.getProperty("java.class.path"));
                try {
                    this.println("   IMQ_HOME=" + new File(Globals.getJMQ_HOME()).getCanonicalPath());
                    this.println("IMQ_VARHOME=" + new File(Globals.getJMQ_VAR_HOME()).getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.exit(0);
                continue;
            }
            if (args[n].equals("-ntservice")) continue;
            if (args[n].equals("-adminkeyfile")) {
                this.adminKeyFile = args[++n];
                continue;
            }
            if (args[n].equals("-help") || args[n].equals("-h")) {
                throw new EmptyStackException();
            }
            if (args[n].equals("-remove")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing remove argument");
                }
                if (args[n].equals("instance")) {
                    this.removeInstance = true;
                    props.put("imq.persist.storeremove.all", "true");
                    continue;
                }
                this.printErr(this.rb.getString("B0028"));
                throw new IllegalArgumentException("unknown remove argument");
            }
            if (args[n].equals("-reset")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing reset argument");
                }
                if (args[n].equals("store")) {
                    props.put("imq.persist.storereset.all", "true");
                    this.resetStore = true;
                    continue;
                }
                if (args[n].equals("messages")) {
                    props.put("imq.persist.storereset.messages", "true");
                    continue;
                }
                if (args[n].equals("durables")) {
                    props.put("imq.persist.storereset.durables", "true");
                    continue;
                }
                if (args[n].equals("props")) {
                    this.clearProps = true;
                    continue;
                }
                if (args[n].equals("takeover-then-exit")) {
                    this.resetTakeoverThenExit = true;
                    continue;
                }
                this.printErr(this.rb.getString("B0009"));
                throw new IllegalArgumentException("bad reset argument");
            }
            if (args[n].equals("-upgrade-store-nobackup")) {
                props.put("imq.persist.storeupgrade.nobackup", "true");
                continue;
            }
            if (args[n].equals("-useRmiRegistry")) {
                props.put("imq.jmx.rmiregistry.use", "true");
                props.put("imq.jmx.rmiregistry.start", "false");
                continue;
            }
            if (args[n].equals("-startRmiRegistry")) {
                props.put("imq.jmx.rmiregistry.start", "true");
                props.put("imq.jmx.rmiregistry.use", "false");
                continue;
            }
            if (args[n].equals("-rmiRegistryPort")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing rmi port");
                }
                props.put("imq.jmx.rmiregistry.port", args[n]);
                continue;
            }
            if (args[n].equals("-activateServices")) {
                if (++n >= args.length) {
                    throw new IllegalArgumentException("missing service list");
                }
                props.put("imq.service.activate", args[n]);
                continue;
            }
            this.printErr(this.rb.getString("B3058", args[n]));
            throw new IllegalArgumentException("unknown option " + args[n]);
        }
        return props;
    }

    public boolean isSilentMode() {
        return this.silent;
    }

    public boolean isResetStore() {
        return this.resetStore;
    }

    private void printPasswordWarning(String option) {
        if (!this.silent) {
            this.printErr(this.rb.getString("B2088", option));
            this.printErr("");
        }
    }

    private void printPasswordError(String option) {
        if (!this.silent) {
            this.printErr(this.rb.getString("B3217", option));
            this.printErr("");
        }
        Broker.getBroker().exit(1, this.rb.getString("B3217"), BrokerEvent.Type.FATAL_ERROR);
    }

    private String getAdminKey(String keyFile) {
        if (keyFile == null || keyFile.length() == 0) {
            return null;
        }
        byte[] buf = new byte[256];
        File f = new File(keyFile);
        int nbytes = 0;
        try (FileInputStream fis = new FileInputStream(f);){
            nbytes = fis.read(buf);
        }
        catch (IOException e) {
            this.logger.log(16, "B2064", (Object)keyFile, (Throwable)e);
            return null;
        }
        String key = null;
        try {
            key = new String(buf, 0, nbytes, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.log(16, "B3100", (Object)"Could not convert key to String using ASCII encoding ");
        }
        if (!f.delete()) {
            this.logger.log(16, "B2065", (Object)keyFile);
        }
        return key;
    }

    private synchronized boolean enableDebug(String alias, Properties props) {
        String propNames;
        String prefix = "imq.debug.com.sun.messaging.jmq.";
        if (this.debugAliases == null) {
            this.debugAliases = new Hashtable();
            this.debugAliases.put("admin", prefix + "jmsserver.data.handlers.admin.AdminCmdHandler");
            this.debugAliases.put("jmx", "imq.jmx.debug.all");
            this.debugAliases.put("jesmf", "imq.jesmf.debug.all");
            this.debugAliases.put("pkt", "imq.packet.debug.all");
            this.debugAliases.put("pktin", "imq.packet.debug.in");
            this.debugAliases.put("pktout", "imq.packet.debug.out");
            this.debugAliases.put("cluster", "imq.cluster.debug.all");
            this.debugAliases.put("lock", "imq.cluster.debug.lock");
            this.debugAliases.put("clscon", "imq.cluster.debug.conn");
            this.debugAliases.put("clspkt", "imq.cluster.debug.packet");
            this.debugAliases.put("clstxn", "imq.cluster.debug.txn imq.cluster.debug.ha");
            this.debugAliases.put("clsmsg", "imq.cluster.debug.msg imq.cluster.debug.txn imq.cluster.debug.ha");
            this.debugAliases.put("clsha", "imq.cluster.debug.ha imq.cluster.debug.msg imq.cluster.debug.txn");
        }
        if ((propNames = (String)this.debugAliases.get(alias)) == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(propNames);
        while (st.hasMoreTokens()) {
            props.put(st.nextToken(), "true");
        }
        return true;
    }

    String usage() {
        return this.rb.getString("B0002");
    }

    private BrokerShutdownHook addBrokerShutdownHook() {
        BrokerShutdownHook hk = new BrokerShutdownHook();
        Runtime rt = Runtime.getRuntime();
        try {
            rt.addShutdownHook(hk);
        }
        catch (Exception e) {
            this.printErr("Runtime.addShutdownHook(): " + String.valueOf(e));
            return null;
        }
        return hk;
    }

    public boolean removeBrokerShutdownHook() {
        BrokerShutdownHook hk = this.shutdownHook;
        try {
            if (hk != null) {
                Runtime rt = Runtime.getRuntime();
                rt.removeShutdownHook(hk);
            }
        }
        catch (Exception e) {
            this.printErr("Runtime.removeShutdownHook(): " + String.valueOf(e));
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        Integer ret = Broker.brokerMain(args, null);
        if (ret != null) {
            System.exit(ret);
        }
    }

    public static Integer brokerMain(String[] args, Throwable failStartThrowable) {
        Broker b = Broker.getBroker();
        Properties p = null;
        Globals.init(System.getProperties(), false, false);
        try {
            p = b.convertArgs(args);
        }
        catch (EmptyStackException ex) {
            b.printErr(b.usage());
            return 0;
        }
        catch (Exception ex) {
            b.printErr(b.usage());
            return 1;
        }
        try {
            int exitCode = b.start(false, p, null, b.initOnly, failStartThrowable);
            if (exitCode != 0) {
                return exitCode;
            }
        }
        catch (Exception ex) {
            Globals.getLogger().logStack(8, "Exception running broker ", (Throwable)ex);
            if (failStartThrowable != null) {
                failStartThrowable.initCause(ex);
            }
            return 1;
        }
        return null;
    }

    private void removeInstance() {
        BrokerResources rb = Globals.getBrokerResources();
        Logger logger = Globals.getLogger();
        String topdir = Globals.getInstanceDir();
        if (!new File(topdir).exists()) {
            if (!this.silent) {
                System.err.println(rb.getString("B3119", Globals.getConfigName()));
            }
            Broker.getBroker().exit(10, rb.getString("B3119", Globals.getConfigName()), BrokerEvent.Type.FATAL_ERROR);
        }
        BrokerStateHandler.setShuttingDown(false);
        BrokerStateHandler.setShutdownStarted(false);
        BrokerConfig conf = Globals.getConfig();
        LockFile lf = null;
        try {
            lf = LockFile.getLock(conf.getProperty("imq.varhome"), Globals.getConfigName(), "localhost", 0, Globals.getUseFileLockForLockFile());
        }
        catch (Exception e) {
            Object[] msgargs = new Object[]{LockFile.getLockFilePath(conf.getProperty("imq.varhome"), Globals.getConfigName()), e.toString(), Globals.getConfigName()};
            logger.logStack(32, "B3086", msgargs, (Throwable)e);
            Broker.getBroker().exit(14, rb.getKString("B3086", msgargs), BrokerEvent.Type.FATAL_ERROR);
        }
        if (!lf.isMyLock()) {
            Object[] msgargs = new Object[]{lf.getFilePath(), lf.getHost() + ":" + lf.getPort(), Globals.getConfigName()};
            logger.log(32, "B3087", msgargs);
            Broker.getBroker().exit(11, rb.getKString("B3087", msgargs), BrokerEvent.Type.FATAL_ERROR);
        }
        boolean loggerClosed = false;
        try {
            if (!this.force) {
                String yes = rb.getString("B0029");
                String yes_s = rb.getString("B0026");
                String no_s = rb.getString("B0027");
                Object[] objs = new String[]{Globals.getConfigName(), yes_s, no_s};
                System.out.print(rb.getString("B0025", objs));
                System.out.flush();
                String val = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (!yes_s.equalsIgnoreCase(val) && !yes.equalsIgnoreCase(val)) {
                    this.printErr(rb.getString("B1097"));
                    Broker.getBroker().exit(1, rb.getString("B1097"), BrokerEvent.Type.SHUTDOWN);
                }
            }
            Globals.getAuditSession().brokerOperation(null, null, "remove instance");
            try {
                this.store = Globals.getStore();
            }
            catch (BrokerException ex) {
                logger.log(32, ex.toString());
                Broker.getBroker().exit(13, ex.toString(), BrokerEvent.Type.EXCEPTION);
            }
            if (!this.silent) {
                this.println(rb.getString("B1096"));
            }
            logger.close();
            loggerClosed = true;
            FileUtil.removeFiles((File)new File(topdir), (boolean)true);
            Broker.getBroker().exit(0, rb.getString("B1096"), BrokerEvent.Type.SHUTDOWN);
        }
        catch (IOException ex) {
            if (loggerClosed) {
                ex.printStackTrace(System.err);
            } else {
                logger.log(32, ex.toString());
            }
            Broker.getBroker().exit(14, ex.toString(), BrokerEvent.Type.FATAL_ERROR);
        }
    }

    public int getDiagInterval() {
        return this.diagInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePassfile() throws IOException {
        BrokerConfig bcfg = Globals.getConfig();
        Properties props = new Properties();
        if (bcfg.getBooleanProperty("imq.passfile.enabled")) {
            String pf_value = null;
            Object pf_dir = null;
            pf_value = bcfg.getProperty("imq.passfile.dirpath");
            if (pf_value != null) {
                pf_value = StringUtil.expandVariables((String)pf_value, (Properties)bcfg);
                pf_dir = pf_value;
            } else {
                pf_dir = bcfg.getProperty("imq.etchome") + File.separator + "security";
            }
            String passfile_location = (String)pf_dir + File.separator + bcfg.getProperty("imq.passfile.name");
            File pf = new File(passfile_location);
            if (!pf.exists()) throw new FileNotFoundException(this.rb.getKString("B3020", passfile_location));
            try {
                PassfileObfuscatorImpl po = new PassfileObfuscatorImpl();
                InputStream fis = po.retrieveObfuscatedFile(passfile_location, "imq");
                props.load(fis);
                if (!po.isObfuscated(passfile_location, "imq")) {
                    this.logger.log(16, this.rb.getKString("B2287", passfile_location, "'imqusermgr encode'"));
                }
            }
            catch (IOException e) {
                String emsg = this.rb.getKString("B4023", passfile_location);
                this.logger.logStack(32, emsg, (Throwable)e);
                throw new IOException(emsg, e);
            }
        }
        if (!Globals.isReadPropertiessFromStdin() && !bcfg.getBooleanProperty("imq.passfile.enabled")) return;
        if (this.dbPWOverride) {
            props.put(this.dbPWProp, bcfg.getProperty(this.dbPWProp));
        }
        if (this.ldapPWOverride) {
            props.put(this.ldapPWProp, bcfg.getProperty(this.ldapPWProp));
        }
        if (this.keystorePWOverride) {
            props.put(this.keystorePWProp, bcfg.getProperty(this.keystorePWProp));
        }
        if (this.bridgeManagerPWOverride) {
            props.put(this.bridgeManagerPWProp, bcfg.getProperty(this.bridgeManagerPWProp));
        }
        bcfg.putAll((Map)props);
    }

    private Properties readPropertiesFromStandardInput() {
        Properties props = new Properties();
        try {
            props.load(System.in);
        }
        catch (IOException ioe) {
            this.logger.log(32, this.rb.getKString("B4316"), (Throwable)ioe);
        }
        return props;
    }

    private void logProperties(String prefix, Properties props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        boolean first = true;
        StringBuilder stringToLog = new StringBuilder();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String thisPropertyName = (String)e.nextElement();
            String thisPropertyValue = "";
            if (thisPropertyName.equals("BrokerArgs")) continue;
            thisPropertyValue = thisPropertyName.endsWith("password") ? "*****" : props.getProperty(thisPropertyName);
            if (first) {
                first = false;
            } else {
                stringToLog.append(", ");
            }
            stringToLog.append(thisPropertyName + "=" + thisPropertyValue);
        }
        if (stringToLog.isEmpty()) {
            return;
        }
        this.logger.logToAll(8, prefix + ": " + stringToLog.toString());
    }

    public void println(String line) {
        if (!this.silent) {
            System.out.println(line);
        }
    }

    public void printErr(String line) {
        if (!this.silent) {
            System.err.println(line);
        }
    }

    @Override
    public void exit(int status, String reason, BrokerEvent.Type type) {
        this.exit(status, reason, type, null);
    }

    public void exit(int status, String reason, BrokerEvent.Type type, Throwable thr) {
        this.exit(status, reason, type, thr, true, false, false);
    }

    public void exit(final int status, final String reason, final BrokerEvent.Type type, final Throwable thr, final boolean triggerFailover, boolean threadoff, boolean halt) {
        boolean exitVM;
        boolean bl = exitVM = !Broker.isInProcess();
        if (halt) {
            Globals.getLogger().log(16, this.haltLogString + " " + reason);
            Runtime.getRuntime().halt(status);
            return;
        }
        if (threadoff) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Broker.this.exitBroker(status, reason, type, thr, triggerFailover, exitVM);
                }
            };
            MQThread t = new MQThread(r, "shutdown thread");
            t.start();
        } else {
            this.exitBroker(status, reason, type, thr, triggerFailover, exitVM);
        }
    }

    private void exitBroker(int status, String reason, BrokerEvent.Type type, Throwable thr, boolean triggerFailover, boolean exitVM) {
        BrokerEvent event;
        Globals.getLogger().log(4, "Broker exiting with status=" + status + " because " + reason);
        BridgeServiceManager bridgeManager = Globals.getBridgeServiceManager();
        if (bridgeManager != null && !Globals.isNucleusManagedBroker()) {
            try {
                Logger logger = Globals.getLogger();
                Globals.getBrokerResources();
                logger.log(8, "B1321");
                bridgeManager.stop();
                Globals.setBridgeServiceManager(null);
                Logger logger2 = Globals.getLogger();
                Globals.getBrokerResources();
                logger2.log(8, "B1322");
            }
            catch (Throwable t) {
                Globals.getBrokerResources();
                this.logger.logStack(16, "B2218", t);
            }
        }
        BrokerEventListener tempListener = bkrEvtListener;
        if (bkrEvtListener != null) {
            event = new BrokerEvent(this, type, reason);
            bkrEvtListener.exitRequested(event, thr);
        }
        Broker.destroyBroker(!exitVM, triggerFailover);
        if (exitVM) {
            if (this.shutdownHook != null) {
                this.shutdownHook.setTriggerFailover(triggerFailover);
            }
            System.exit(status);
        }
        if (type == BrokerEvent.Type.RESTART && !runningInProcess && tempListener != null) {
            event = new BrokerEvent(this, type, "Broker restart");
            tempListener.brokerEvent(event);
        }
    }

    @Override
    public boolean handleGlobalError(Throwable ex, String reason) {
        return this.handleGlobalError(ex, reason, null);
    }

    @Override
    public boolean handleGlobalError(Throwable ex, String reason, Integer exitCode) {
        this.logger.logStack(32, ex.toString() + "[" + reason + "]", ex);
        Globals.getBrokerStateHandler();
        int exit = BrokerStateHandler.getRestartCode();
        if (exitCode != null) {
            exit = exitCode;
        }
        if (ex instanceof OutOfMemoryError) {
            Broker.getBroker().exit(exit, "Received Out Of Memory Error [" + reason + "]", BrokerEvent.Type.ERROR, ex);
            if (!runningInProcess) {
                Globals.getMemManager().forceRedState();
            }
            return true;
        }
        Broker.getBroker().exit(exit, "Unexpected Exception " + reason, BrokerEvent.Type.EXCEPTION, ex);
        return false;
    }

    class BrokerDiagTask
    extends TimerTask {
        BrokerDiagTask() {
        }

        @Override
        public void run() {
            String s = DiagManager.allToString();
            if (s != null) {
                Broker.this.logger.log(8, s);
            }
        }
    }
}

