/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.api;

import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import java.util.Hashtable;
import java.util.Vector;

public class RemoteTransactionAckEntry {
    TransactionAcknowledgement[] acks = null;
    boolean processed = false;
    boolean recovery = false;
    boolean localremote = false;

    public RemoteTransactionAckEntry(TransactionAcknowledgement[] acks, boolean localremote) {
        this(acks, false, localremote, false);
    }

    public RemoteTransactionAckEntry(TransactionAcknowledgement[] acks, boolean recovery, boolean done) {
        this(acks, recovery, false, done);
    }

    private RemoteTransactionAckEntry(TransactionAcknowledgement[] acks, boolean recovery, boolean localremote, boolean done) {
        this.acks = acks;
        this.recovery = recovery;
        this.localremote = localremote;
        this.processed = done;
    }

    public synchronized boolean processed() {
        if (this.processed) {
            return true;
        }
        this.processed = true;
        return false;
    }

    public synchronized boolean isProcessed() {
        return this.processed;
    }

    public synchronized boolean isLocalRemote() {
        return this.localremote;
    }

    public TransactionAcknowledgement[] getAcks() {
        return this.acks;
    }

    public boolean isRecovery() {
        return this.recovery;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("processed", String.valueOf(this.processed));
        ht.put("recovery", String.valueOf(this.recovery));
        ht.put("localremote", String.valueOf(this.localremote));
        if (this.acks != null) {
            Vector<String> v = new Vector<String>();
            for (int i = 0; i < this.acks.length; ++i) {
                v.add(this.acks[i].toString());
            }
            ht.put("txnacks", v);
        }
        return ht;
    }
}

