/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.io.OutputBuffer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.localization.LogMessages;

public class ServerOutputBuffer
extends OutputBuffer {
    private volatile Response serverResponse;

    public void initialize(Response response, FilterChainContext ctx) {
        this.serverResponse = response;
        super.initialize(response.getResponse(), response.isSendFileEnabled(), ctx);
    }

    @Override
    public void sendfile(File file, long offset, long length, CompletionHandler<WriteResult> handler) {
        if (!this.sendfileEnabled) {
            throw new IllegalStateException("sendfile support isn't available.");
        }
        Response localServerResponse = this.serverResponse;
        if (localServerResponse == null) {
            throw new IllegalStateException("ServerOutputBuffer is not initialized in a Response");
        }
        boolean suspendedAtStart = localServerResponse.isSuspended();
        CompletionHandler<WriteResult> ch = suspendedAtStart && handler != null ? handler : (!suspendedAtStart && handler != null ? this.suspendAndCreateHandler(handler, localServerResponse) : this.createInternalCompletionHandler(file, suspendedAtStart, localServerResponse));
        super.sendfile(file, offset, length, ch);
    }

    @Override
    public void recycle() {
        this.serverResponse = null;
        super.recycle();
    }

    @Override
    protected Executor getThreadPool() {
        Response localServerResponse = this.serverResponse;
        if (localServerResponse == null) {
            return null;
        }
        Request serverRequest = localServerResponse.getRequest();
        return serverRequest != null ? serverRequest.getRequestExecutor() : null;
    }

    @Override
    protected void blockAfterWriteIfNeeded() throws IOException {
        if (!this.initialized()) {
            return;
        }
        super.blockAfterWriteIfNeeded();
    }

    private boolean initialized() {
        return this.serverResponse != null;
    }

    private CompletionHandler<WriteResult> createInternalCompletionHandler(final File file, boolean suspendedAtStart, final Response serverResponse) {
        if (!suspendedAtStart) {
            serverResponse.suspend();
        }
        CompletionHandler<WriteResult> ch = new CompletionHandler<WriteResult>(){

            @Override
            public void cancelled() {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_SERVEROUTPUTBUFFER_FILE_TRANSFER_CANCELLED(file.getAbsolutePath()));
                }
                serverResponse.resume();
            }

            @Override
            public void failed(Throwable throwable) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_SERVEROUTPUTBUFFER_FILE_TRANSFER_FAILED(file.getAbsolutePath(), throwable.getMessage()), throwable);
                }
                serverResponse.resume();
            }

            @Override
            public void completed(WriteResult result) {
                serverResponse.resume();
            }

            @Override
            public void updated(WriteResult result) {
            }
        };
        return ch;
    }

    private CompletionHandler<WriteResult> suspendAndCreateHandler(final CompletionHandler<WriteResult> handler, final Response serverResponse) {
        serverResponse.suspend();
        return new CompletionHandler<WriteResult>(){

            @Override
            public void cancelled() {
                handler.cancelled();
                serverResponse.resume();
            }

            @Override
            public void failed(Throwable throwable) {
                handler.failed(throwable);
                serverResponse.resume();
            }

            @Override
            public void completed(WriteResult result) {
                handler.completed(result);
                serverResponse.resume();
            }

            @Override
            public void updated(WriteResult result) {
                handler.updated(result);
            }
        };
    }
}

