/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.utils.Holder;

public class UDPNIOConnection
extends NIOConnection {
    private static final Logger LOGGER = Grizzly.logger(UDPNIOConnection.class);
    private final Object multicastSync = new Object();
    private Map<InetAddress, Set<MembershipKey>> membershipKeysMap;
    Holder<SocketAddress> localSocketAddressHolder;
    Holder<SocketAddress> peerSocketAddressHolder;
    private int readBufferSize = -1;
    private int writeBufferSize = -1;

    public UDPNIOConnection(UDPNIOTransport transport, DatagramChannel channel) {
        super(transport);
        this.channel = channel;
        this.resetProperties();
    }

    public boolean isConnected() {
        return this.channel != null && ((DatagramChannel)this.channel).isConnected();
    }

    public void join(InetAddress group, NetworkInterface networkInterface) throws IOException {
        this.join(group, networkInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(InetAddress group, NetworkInterface networkInterface, InetAddress source) throws IOException {
        if (group == null) {
            throw new IllegalArgumentException("group parameter can't be null");
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("networkInterface parameter can't be null");
        }
        Object object = this.multicastSync;
        synchronized (object) {
            MembershipKey membershipKey;
            MembershipKey membershipKey2 = membershipKey = source == null ? ((DatagramChannel)this.channel).join(group, networkInterface) : ((DatagramChannel)this.channel).join(group, networkInterface, source);
            if (this.membershipKeysMap == null) {
                this.membershipKeysMap = new HashMap<InetAddress, Set<MembershipKey>>();
            }
            Set keySet = this.membershipKeysMap.computeIfAbsent(group, k -> new HashSet());
            keySet.add(membershipKey);
        }
    }

    public void drop(InetAddress group, NetworkInterface networkInterface) throws IOException {
        this.drop(group, networkInterface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(InetAddress group, NetworkInterface networkInterface, InetAddress source) throws IOException {
        if (group == null) {
            throw new IllegalArgumentException("group parameter can't be null");
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("networkInterface parameter can't be null");
        }
        Object object = this.multicastSync;
        synchronized (object) {
            Set<MembershipKey> keys;
            if (this.membershipKeysMap != null && (keys = this.membershipKeysMap.get(group)) != null) {
                Iterator<MembershipKey> it = keys.iterator();
                while (it.hasNext()) {
                    MembershipKey key = it.next();
                    if (networkInterface.equals(key.networkInterface()) && (source == null && key.sourceAddress() == null || source != null && source.equals(key.sourceAddress()))) {
                        key.drop();
                        it.remove();
                    }
                    if (!keys.isEmpty()) continue;
                    this.membershipKeysMap.remove(group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAll(InetAddress group, NetworkInterface networkInterface) throws IOException {
        if (group == null) {
            throw new IllegalArgumentException("group parameter can't be null");
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("networkInterface parameter can't be null");
        }
        Object object = this.multicastSync;
        synchronized (object) {
            Set<MembershipKey> keys;
            if (this.membershipKeysMap != null && (keys = this.membershipKeysMap.get(group)) != null) {
                Iterator<MembershipKey> it = keys.iterator();
                while (it.hasNext()) {
                    MembershipKey key = it.next();
                    if (!networkInterface.equals(key.networkInterface())) continue;
                    key.drop();
                    it.remove();
                }
                if (keys.isEmpty()) {
                    this.membershipKeysMap.remove(group);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block(InetAddress group, NetworkInterface networkInterface, InetAddress source) throws IOException {
        if (group == null) {
            throw new IllegalArgumentException("group parameter can't be null");
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("networkInterface parameter can't be null");
        }
        Object object = this.multicastSync;
        synchronized (object) {
            Set<MembershipKey> keys;
            if (this.membershipKeysMap != null && (keys = this.membershipKeysMap.get(group)) != null) {
                for (MembershipKey key : keys) {
                    if (!networkInterface.equals(key.networkInterface()) || key.sourceAddress() != null) continue;
                    key.block(source);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock(InetAddress group, NetworkInterface networkInterface, InetAddress source) throws IOException {
        if (group == null) {
            throw new IllegalArgumentException("group parameter can't be null");
        }
        if (networkInterface == null) {
            throw new IllegalArgumentException("networkInterface parameter can't be null");
        }
        Object object = this.multicastSync;
        synchronized (object) {
            Set<MembershipKey> keys;
            if (this.membershipKeysMap != null && (keys = this.membershipKeysMap.get(group)) != null) {
                for (MembershipKey key : keys) {
                    if (!networkInterface.equals(key.networkInterface()) || key.sourceAddress() != null) continue;
                    key.unblock(source);
                }
            }
        }
    }

    @Override
    protected void setSelectionKey(SelectionKey selectionKey) {
        super.setSelectionKey(selectionKey);
    }

    @Override
    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        super.setSelectorRunner(selectorRunner);
    }

    protected boolean notifyReady() {
        return connectCloseSemaphoreUpdater.compareAndSet(this, null, NOTIFICATION_INITIALIZED);
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.peerSocketAddressHolder.get();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localSocketAddressHolder.get();
    }

    protected final void resetProperties() {
        if (this.channel != null) {
            this.setReadBufferSize(this.transport.getReadBufferSize());
            this.setWriteBufferSize(this.transport.getWriteBufferSize());
            int transportMaxAsyncWriteQueueSize = this.transport.getAsyncQueueIO().getWriter().getMaxPendingBytesPerConnection();
            this.setMaxAsyncWriteQueueSize(transportMaxAsyncWriteQueueSize == -2 ? this.getWriteBufferSize() * 4 : transportMaxAsyncWriteQueueSize);
            this.localSocketAddressHolder = Holder.lazyHolder(new Supplier<SocketAddress>(){

                @Override
                public SocketAddress get() {
                    return ((DatagramChannel)UDPNIOConnection.this.channel).socket().getLocalSocketAddress();
                }
            });
            this.peerSocketAddressHolder = Holder.lazyHolder(new Supplier<SocketAddress>(){

                @Override
                public SocketAddress get() {
                    return ((DatagramChannel)UDPNIOConnection.this.channel).socket().getRemoteSocketAddress();
                }
            });
        }
    }

    @Override
    public int getReadBufferSize() {
        if (this.readBufferSize >= 0) {
            return this.readBufferSize;
        }
        try {
            this.readBufferSize = ((DatagramChannel)this.channel).socket().getReceiveBufferSize();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, LogMessages.WARNING_GRIZZLY_CONNECTION_GET_READBUFFER_SIZE_EXCEPTION(), e);
            this.readBufferSize = 0;
        }
        return this.readBufferSize;
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        if (readBufferSize > 0) {
            try {
                int currentReadBufferSize = ((DatagramChannel)this.channel).socket().getReceiveBufferSize();
                if (readBufferSize > currentReadBufferSize) {
                    ((DatagramChannel)this.channel).socket().setReceiveBufferSize(readBufferSize);
                }
                this.readBufferSize = readBufferSize;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_READBUFFER_SIZE_EXCEPTION(), e);
            }
        }
    }

    @Override
    public int getWriteBufferSize() {
        if (this.writeBufferSize >= 0) {
            return this.writeBufferSize;
        }
        try {
            this.writeBufferSize = ((DatagramChannel)this.channel).socket().getSendBufferSize();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, LogMessages.WARNING_GRIZZLY_CONNECTION_GET_WRITEBUFFER_SIZE_EXCEPTION(), e);
            this.writeBufferSize = 0;
        }
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        if (writeBufferSize > 0) {
            try {
                int currentSendBufferSize = ((DatagramChannel)this.channel).socket().getSendBufferSize();
                if (writeBufferSize > currentSendBufferSize) {
                    ((DatagramChannel)this.channel).socket().setSendBufferSize(writeBufferSize);
                }
                this.writeBufferSize = writeBufferSize;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_CONNECTION_SET_WRITEBUFFER_SIZE_EXCEPTION(), e);
            }
        }
    }

    @Override
    protected void enableInitialOpRead() throws IOException {
        super.enableInitialOpRead();
    }

    protected final void onConnect() throws IOException {
        UDPNIOConnection.notifyProbesConnect(this);
    }

    protected final void onRead(Buffer data, int size) {
        if (size > 0) {
            UDPNIOConnection.notifyProbesRead(this, data, size);
        }
        this.checkEmptyRead(size);
    }

    protected final void onWrite(Buffer data, int size) {
        UDPNIOConnection.notifyProbesWrite(this, data, size);
    }

    @Override
    public boolean canWrite() {
        return this.transport.getWriter(this).canWrite(this);
    }

    @Override
    @Deprecated
    public boolean canWrite(int length) {
        return this.transport.getWriter(this).canWrite(this);
    }

    @Override
    public void notifyCanWrite(WriteHandler writeHandler) {
        this.transport.getWriter(this).notifyWritePossible(this, writeHandler);
    }

    @Override
    @Deprecated
    public void notifyCanWrite(WriteHandler handler, int length) {
        this.transport.getWriter(this).notifyWritePossible(this, handler);
    }

    void setMonitoringProbes(ConnectionProbe[] monitoringProbes) {
        this.monitoringConfig.addProbes(monitoringProbes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UDPNIOConnection");
        sb.append("{localSocketAddress=").append(this.localSocketAddressHolder);
        sb.append(", peerSocketAddress=").append(this.peerSocketAddressHolder);
        sb.append('}');
        return sb.toString();
    }
}

