/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.servermgmt.cli.ServerLifeSignCheck;
import com.sun.enterprise.admin.servermgmt.util.CommandAction;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.glassfish.api.admin.CommandException;

public class ServerLifeSignChecker {
    private static final System.Logger LOG = System.getLogger(ServerLifeSignChecker.class.getName());
    private final ServerLifeSignCheck checks;
    private final File pidFile;
    private final Supplier<List<HostAndPort>> adminEndpointsSupplier;
    private final boolean verbose;

    public ServerLifeSignChecker(ServerLifeSignCheck checks, File pidFile, Supplier<List<HostAndPort>> adminEndpointsSupplier, boolean verbose) {
        this.checks = checks;
        this.pidFile = pidFile;
        this.adminEndpointsSupplier = adminEndpointsSupplier;
        this.verbose = verbose;
    }

    public ServerLifeSigns watchStartup(GlassFishProcess process, Duration timeout) throws CommandException {
        ServerLifeSigns signs = new ServerLifeSigns();
        CommandAction action = () -> {
            if (timeout != null && timeout.isNegative()) {
                signs.situationReport = this.createSituationReport(process);
                this.createTimeoutReport(signs);
                return;
            }
            if (!(this.checks.isPidFile() || this.checks.isProcessAlive() || this.checks.isAdminEndpoint() || this.checks.isCustomEndpoints())) {
                signs.summary = "All checks of the server state were disabled. Assuming the server is running.";
                signs.situationReport = this.createSituationReport(process);
                signs.suggestion = this.getSuggestions();
                return;
            }
            boolean wasTimeout = !this.waitFor(process, timeout);
            signs.situationReport = this.createSituationReport(process);
            if (wasTimeout) {
                this.createTimeoutReport(signs);
                return;
            }
            if (process.isAlive()) {
                signs.summary = "Successfully started the " + this.checks.getServerTitleAndName() + ".";
                return;
            }
            signs.error = true;
            signs.suggestion = this.getSuggestions();
            Integer exitCode = process.exitCode();
            if (exitCode == null) {
                signs.summary = "The process died.";
            } else {
                signs.summary = "The startup command return code was " + exitCode + " which means that the start ";
                signs.summary = exitCode == 0 ? signs.summary + "succeded, however later the process stopped for some reason." : signs.summary + "failed.";
            }
        };
        CommandAction.step("Waiting until start of " + this.checks.getServerTitleAndName() + " completes.", timeout, action);
        return signs;
    }

    private boolean waitFor(GlassFishProcess process, Duration timeout) {
        Supplier<Boolean> signOfFinishedStartup = () -> {
            if (this.checks.isProcessAlive() && !process.isAlive()) {
                return true;
            }
            if (this.checks.isCustomEndpoints() && !this.isListeningOnAllEndpoints(this.checks.getCustomEndpoints())) {
                return false;
            }
            if (this.checks.isAdminEndpoint() && !this.isListeningOnAnyEndpoint(this.adminEndpointsSupplier.get())) {
                return false;
            }
            if (this.checks.isPidFile() && ProcessUtils.loadPid((File)this.pidFile) == null) {
                return false;
            }
            return true;
        };
        return ProcessUtils.waitFor(signOfFinishedStartup, (Duration)timeout, (boolean)this.verbose);
    }

    private ServerLifeSigns createTimeoutReport(ServerLifeSigns signs) {
        signs.error = true;
        signs.summary = "Failed to confirm that the server is running - timed out. The command is either taking too long to complete or the startup has failed or we are not permitted to complete all checks.";
        signs.suggestion = this.getSuggestions();
        return signs;
    }

    private String createSituationReport(GlassFishProcess process) {
        List<HostAndPort> adminEndpoints;
        if (!this.verbose) {
            return null;
        }
        StringBuilder report = new StringBuilder(4096);
        if (this.checks.isPidFile()) {
            report.append("\n  The pid file ").append(this.pidFile.getAbsolutePath());
            if (this.pidFile.exists()) {
                Long pid = ProcessUtils.loadPid((File)this.pidFile);
                if (pid == null) {
                    report.append(" exists but does not contain parseable pid.");
                } else {
                    report.append(" contains pid ").append(pid).append('.');
                    if (pid.longValue() != process.pid()) {
                        report.append(" WARNING: The process we started has different pid!");
                        report.append(" The process with the pid ").append(pid);
                        report.append(ProcessUtils.isAlive((long)pid) ? " is" : " is not").append(" alive.");
                    }
                }
            } else {
                report.append(" does not exist.");
            }
        }
        report.append("\n  Process with pid ").append(process.pid()).append(" is ");
        report.append(process.isAlive() ? "alive" : "dead");
        if (this.checks.isAdminEndpoint() && !(adminEndpoints = this.adminEndpointsSupplier.get()).isEmpty()) {
            report.append("\n  Admin Endpoints:");
            this.appendEndpoints(adminEndpoints, report);
        }
        if (!this.checks.getCustomEndpoints().isEmpty()) {
            report.append("\n  Custom Endpoints:");
            this.appendEndpoints(this.checks.getCustomEndpoints(), report);
        }
        return report.toString();
    }

    private void appendEndpoints(List<HostAndPort> endpoints, StringBuilder report) {
        for (HostAndPort endpoint : endpoints) {
            boolean listening = ProcessUtils.isListening((HostAndPort)endpoint);
            report.append("\n    ").append(endpoint.isSecure() ? "https://" : "http://").append(endpoint.getHost()).append(':').append(endpoint.getPort());
            report.append(' ').append(listening ? "is" : "is not").append(" reachable.");
        }
    }

    private String getSuggestions() {
        return "Please see the server log files for command status.\nYou can also start with the --verbose option in order to see early messages in this output.";
    }

    private boolean isListeningOnAnyEndpoint(List<HostAndPort> endpoints) {
        for (HostAndPort endpoint : endpoints) {
            if (!ProcessUtils.isListening((HostAndPort)endpoint)) continue;
            LOG.log(System.Logger.Level.TRACE, "Server is listening on {0}.", endpoint);
            return true;
        }
        return false;
    }

    private boolean isListeningOnAllEndpoints(List<HostAndPort> endpoints) {
        for (HostAndPort endpoint : endpoints) {
            if (ProcessUtils.isListening((HostAndPort)endpoint)) continue;
            LOG.log(System.Logger.Level.TRACE, "Server is not listening on {0}.", endpoint);
            return false;
        }
        return true;
    }

    public static final class ServerLifeSigns {
        private boolean error;
        private String summary;
        private String situationReport;
        private String suggestion;

        public boolean isError() {
            return this.error;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getSituationReport() {
            return this.situationReport;
        }

        public String getSuggestion() {
            return this.suggestion;
        }
    }

    public static interface GlassFishProcess {
        public boolean isAlive();

        public long pid();

        public Integer exitCode();

        public static GlassFishProcess of(Process process) {
            return new GlassFishProcessInstance(process);
        }

        public static GlassFishProcess of(long pid) {
            return new GlassFishProcessHandle(pid);
        }
    }

    private static final class GlassFishProcessHandle
    implements GlassFishProcess {
        private final long pid;

        private GlassFishProcessHandle(long pid) {
            this.pid = pid;
        }

        @Override
        public boolean isAlive() {
            return ProcessUtils.isAlive((long)this.pid);
        }

        @Override
        public long pid() {
            return this.pid;
        }

        @Override
        public Integer exitCode() {
            return null;
        }
    }

    private static final class GlassFishProcessInstance
    implements GlassFishProcess {
        private final Process process;

        private GlassFishProcessInstance(Process process) {
            this.process = process;
        }

        @Override
        public boolean isAlive() {
            return this.process.isAlive();
        }

        @Override
        public long pid() {
            return this.process.pid();
        }

        @Override
        public Integer exitCode() {
            return this.process.exitValue();
        }
    }
}

