/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jms.management.server.DestinationType;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class DestinationManagerConfig
extends MQMBeanReadWrite
implements ConfigListener {
    private Properties brokerProps = null;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] createSignature1;
    private static MBeanParameterInfo[] createSignature2;
    private static MBeanParameterInfo[] destroySignature;
    private static MBeanParameterInfo[] pauseSignature;
    private static MBeanOperationInfo[] ops;
    private static String[] attrChangeTypes;
    private static MBeanNotificationInfo[] notifs;

    public DestinationManagerConfig() {
        this.initProps();
        BrokerConfig cfg = Globals.getConfig();
        cfg.addListener("imq.autocreate.queue", this);
        cfg.addListener("imq.autocreate.queue.maxNumActiveConsumers", this);
        cfg.addListener("imq.autocreate.queue.maxNumBackupConsumers", this);
        cfg.addListener("imq.autocreate.topic", this);
        cfg.addListener("imq.destination.DMQ.truncateBody", this);
        cfg.addListener("imq.destination.logDeadMsgs", this);
        cfg.addListener("imq.message.max_size", this);
        cfg.addListener("imq.system.max_count", this);
        cfg.addListener("imq.system.max_size", this);
    }

    public void setAutoCreateQueues(Boolean b) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.autocreate.queue", b.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("AutoCreateQueues", e);
        }
    }

    public Boolean getAutoCreateQueues() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.autocreate.queue");
        Boolean b = null;
        try {
            b = Boolean.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("AutoCreateQueues", e);
        }
        return b;
    }

    public void setAutoCreateQueueMaxNumActiveConsumers(Integer i) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.autocreate.queue.maxNumActiveConsumers", i.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("AutoCreateQueueMaxNumActiveConsumers", e);
        }
    }

    public Integer getAutoCreateQueueMaxNumActiveConsumers() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.autocreate.queue.maxNumActiveConsumers");
        Integer i = null;
        try {
            i = Integer.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("AutoCreateQueues", e);
        }
        return i;
    }

    public void setAutoCreateQueueMaxNumBackupConsumers(Integer i) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.autocreate.queue.maxNumBackupConsumers", i.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("AutoCreateQueueMaxNumBackupConsumers", e);
        }
    }

    public Integer getAutoCreateQueueMaxNumBackupConsumers() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.autocreate.queue.maxNumBackupConsumers");
        Integer i = null;
        try {
            i = Integer.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("AutoCreateQueueMaxNumBackupConsumers", e);
        }
        return i;
    }

    public void setAutoCreateTopics(Boolean b) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.autocreate.topic", b.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("AutoCreateTopics", e);
        }
    }

    public Boolean getAutoCreateTopics() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.autocreate.topic");
        Boolean b = null;
        try {
            b = Boolean.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("AutoCreateTopics", e);
        }
        return b;
    }

    public void setDMQTruncateBody(Boolean b) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.destination.DMQ.truncateBody", b.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("DMQTruncateBody", e);
        }
    }

    public Boolean getDMQTruncateBody() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.destination.DMQ.truncateBody");
        Boolean b = null;
        try {
            b = Boolean.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("DMQTruncateBody", e);
        }
        return b;
    }

    public void setLogDeadMsgs(Boolean b) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.destination.logDeadMsgs", b.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("LogDeadMsgs", e);
        }
    }

    public Boolean getLogDeadMsgs() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.destination.logDeadMsgs");
        Boolean b = null;
        try {
            b = Boolean.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("LogDeadMsgs", e);
        }
        return b;
    }

    public void setMaxBytesPerMsg(Long l) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.message.max_size", l.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("MaxBytesPerMsg", e);
        }
    }

    public Long getMaxBytesPerMsg() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.message.max_size");
        Long l = null;
        try {
            SizeString ss = new SizeString(s);
            l = ss.getBytes();
        }
        catch (Exception e) {
            this.handleGetterException("MaxBytesPerMsg", e);
        }
        return l;
    }

    public void setMaxNumMsgs(Long l) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.system.max_count", l.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("MaxNumMsgs", e);
        }
    }

    public Long getMaxNumMsgs() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.system.max_count");
        Long l = null;
        try {
            l = Long.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("MaxNumMsgs", e);
        }
        return l;
    }

    public void setMaxTotalMsgBytes(Long l) throws MBeanException {
        Properties p = new Properties();
        p.setProperty("imq.system.max_size", l.toString());
        try {
            BrokerConfig cfg = Globals.getConfig();
            cfg.updateProperties(p, true);
        }
        catch (Exception e) {
            this.handleSetterException("MaxTotalMsgBytes", e);
        }
    }

    public Long getMaxTotalMsgBytes() throws MBeanException {
        String s = this.brokerProps.getProperty("imq.system.max_size");
        Long l = null;
        try {
            l = Long.valueOf(s);
        }
        catch (Exception e) {
            this.handleGetterException("MaxTotalMsgBytes", e);
        }
        return l;
    }

    public Integer getNumDestinations() {
        List l = DestinationUtil.getVisibleDestinations();
        return l.size();
    }

    public void create(String type, String name) throws MBeanException {
        this.create(type, name, null);
    }

    public void create(String type, String name, AttributeList attrs) throws MBeanException {
        DestinationInfo info = DestinationUtil.getDestinationInfoFromAttrs(type, name, attrs);
        try {
            DestinationUtil.checkCreateDestinationAttrs(type, attrs);
            DestinationUtil.createDestination(info);
        }
        catch (BrokerException e) {
            this.handleOperationException("create", e);
        }
    }

    public void compact() throws MBeanException {
        try {
            DestinationUtil.compactAllDestinations();
        }
        catch (BrokerException e) {
            this.handleOperationException("compact", e);
        }
    }

    public void destroy(String type, String name) throws MBeanException {
        try {
            DestinationUtil.checkDestType(type);
            Destination[] ds = DestinationList.removeDestination(null, name, type.equals("q"), "JMX API");
            Destination d = ds[0];
            if (d == null) {
                String subError = rb.getString("B3128", DestinationType.toStringLabel(type), name);
                String errMsg = rb.getString("B4087", name, subError);
                throw new BrokerException(errMsg);
            }
        }
        catch (Exception e) {
            this.handleOperationException("destroy", e);
        }
    }

    public ObjectName[] getDestinations() throws MBeanException {
        List dests = DestinationUtil.getVisibleDestinations();
        if (dests.size() == 0) {
            return null;
        }
        ObjectName[] destONames = new ObjectName[dests.size()];
        for (int i = 0; i < dests.size(); ++i) {
            Destination d = (Destination)dests.get(i);
            try {
                ObjectName o;
                destONames[i] = o = MQObjectName.createDestinationConfig(d.isQueue() ? "q" : "t", d.getDestinationName());
                continue;
            }
            catch (Exception e) {
                this.handleOperationException("getDestinations", e);
            }
        }
        return destONames;
    }

    public void pause() throws MBeanException {
        this.pause("ALL");
    }

    public void pause(String pauseType) throws MBeanException {
        try {
            DestinationUtil.checkPauseType(pauseType);
            this.logger.log(8, "B1250", pauseType);
            DestinationUtil.pauseAllDestinations(DestinationUtil.toInternalPauseType(pauseType));
        }
        catch (Exception e) {
            this.handleOperationException("pause", e);
        }
    }

    public void resume() {
        this.logger.log(8, "Resuming all destinations");
        DestinationUtil.resumeAllDestinations();
    }

    @Override
    public String getMBeanName() {
        return "DestinationManagerConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1165");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
    }

    @Override
    public boolean update(String name, String value) {
        if (name.equals("imq.autocreate.queue")) {
            Boolean oldVal;
            Boolean newVal = Boolean.valueOf(value);
            try {
                oldVal = this.getAutoCreateQueues();
            }
            catch (MBeanException e) {
                this.logProblemGettingOldVal("AutoCreateQueues", e);
                oldVal = null;
            }
            this.notifyAttrChange("AutoCreateQueues", newVal, oldVal);
        } else if (name.equals("imq.autocreate.queue.maxNumActiveConsumers")) {
            Integer oldVal;
            Integer newVal;
            try {
                newVal = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of AutoCreateQueueMaxNumActiveConsumers: " + String.valueOf(nfe));
                newVal = null;
            }
            try {
                oldVal = this.getAutoCreateQueueMaxNumActiveConsumers();
            }
            catch (MBeanException e) {
                this.logProblemGettingOldVal("AutoCreateQueueMaxNumActiveConsumers", e);
                oldVal = null;
            }
            this.notifyAttrChange("AutoCreateQueueMaxNumActiveConsumers", newVal, oldVal);
        } else if (name.equals("imq.autocreate.queue.maxNumBackupConsumers")) {
            Integer oldVal;
            Integer newVal;
            try {
                newVal = Integer.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of AutoCreateQueueMaxNumBackupConsumers: " + String.valueOf(nfe));
                newVal = null;
            }
            try {
                oldVal = this.getAutoCreateQueueMaxNumBackupConsumers();
            }
            catch (MBeanException e) {
                this.logProblemGettingOldVal("AutoCreateQueueMaxNumBackupConsumers", e);
                oldVal = null;
            }
            this.notifyAttrChange("AutoCreateQueueMaxNumBackupConsumers", newVal, oldVal);
        } else if (name.equals("imq.autocreate.topic")) {
            Boolean oldVal;
            Boolean newVal = Boolean.valueOf(value);
            try {
                oldVal = this.getAutoCreateTopics();
            }
            catch (MBeanException e) {
                this.logProblemGettingOldVal("AutoCreateTopics", e);
                oldVal = null;
            }
            this.notifyAttrChange("AutoCreateTopics", newVal, oldVal);
        } else if (name.equals("imq.destination.DMQ.truncateBody")) {
            Boolean oldVal;
            Boolean newVal = Boolean.valueOf(value);
            try {
                oldVal = this.getDMQTruncateBody();
            }
            catch (MBeanException e) {
                this.logProblemGettingOldVal("DMQTruncateBody", e);
                oldVal = null;
            }
            this.notifyAttrChange("DMQTruncateBody", newVal, oldVal);
        } else if (name.equals("imq.destination.logDeadMsgs")) {
            Boolean oldVal;
            Boolean newVal = Boolean.valueOf(value);
            try {
                oldVal = this.getLogDeadMsgs();
            }
            catch (MBeanException e) {
                this.logProblemGettingOldVal("LogDeadMsgs", e);
                oldVal = null;
            }
            this.notifyAttrChange("LogDeadMsgs", newVal, oldVal);
        } else if (name.equals("imq.message.max_size")) {
            Long oldVal;
            Long newVal;
            try {
                SizeString ss = new SizeString(value);
                newVal = ss.getBytes();
            }
            catch (NumberFormatException nfe) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of MaxBytesPerMsg: " + String.valueOf(nfe));
                newVal = null;
            }
            try {
                oldVal = this.getMaxBytesPerMsg();
            }
            catch (MBeanException e) {
                this.logProblemGettingOldVal("MaxBytesPerMsg", e);
                oldVal = null;
            }
            this.notifyAttrChange("MaxBytesPerMsg", newVal, oldVal);
        } else if (name.equals("imq.system.max_count")) {
            Long oldVal;
            Long newVal;
            try {
                newVal = Long.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of MaxNumMsgs: " + String.valueOf(nfe));
                newVal = null;
            }
            try {
                oldVal = this.getMaxNumMsgs();
            }
            catch (MBeanException e) {
                this.logProblemGettingOldVal("MaxNumMsgs", e);
                oldVal = null;
            }
            this.notifyAttrChange("MaxNumMsgs", newVal, oldVal);
        } else if (name.equals("imq.system.max_size")) {
            Long oldVal;
            Long newVal;
            try {
                newVal = Long.valueOf(value);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(32, this.getMBeanName() + ": cannot parse internal value of MaxTotalMsgBytes: " + String.valueOf(nfe));
                newVal = null;
            }
            try {
                oldVal = this.getMaxTotalMsgBytes();
            }
            catch (MBeanException e) {
                this.logProblemGettingOldVal("MaxTotalMsgBytes", e);
                oldVal = null;
            }
            this.notifyAttrChange("MaxTotalMsgBytes", newVal, oldVal);
        }
        this.initProps();
        return true;
    }

    public void notifyAttrChange(String attrName, Object newVal, Object oldVal) {
        this.sendNotification(new AttributeChangeNotification(this, this.sequenceNumber++, new Date().getTime(), "Attribute change", attrName, newVal == null ? "" : newVal.getClass().getName(), oldVal, newVal));
    }

    private void initProps() {
        this.brokerProps = Globals.getConfig().toProperties();
        Version version = Globals.getVersion();
        this.brokerProps.putAll((Map<?, ?>)version.getProps());
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[10];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("AutoCreateQueues", Boolean.class.getName(), mbr.getString("MB1166"), true, true, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("AutoCreateQueueMaxNumActiveConsumers", Integer.class.getName(), mbr.getString("MB1167"), true, true, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("AutoCreateQueueMaxNumBackupConsumers", Integer.class.getName(), mbr.getString("MB1168"), true, true, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("AutoCreateTopics", Boolean.class.getName(), mbr.getString("MB1169"), true, true, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("DMQTruncateBody", Boolean.class.getName(), mbr.getString("MB1170"), true, true, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("LogDeadMsgs", Boolean.class.getName(), mbr.getString("MB1171"), true, true, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("MaxBytesPerMsg", Long.class.getName(), mbr.getString("MB1172"), true, true, false);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("MaxNumMsgs", Long.class.getName(), mbr.getString("MB1173"), true, true, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("MaxTotalMsgBytes", Long.class.getName(), mbr.getString("MB1174"), true, true, false);
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("NumDestinations", Integer.class.getName(), mbr.getString("MB1175"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[2];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        createSignature1 = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[3];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray2[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        mBeanParameterInfoArray2[2] = new MBeanParameterInfo("destinationAttrs", AttributeList.class.getName(), mbr.getString("MB1189"));
        createSignature2 = mBeanParameterInfoArray2;
        MBeanParameterInfo[] mBeanParameterInfoArray3 = new MBeanParameterInfo[2];
        mBeanParameterInfoArray3[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray3[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        destroySignature = mBeanParameterInfoArray3;
        MBeanParameterInfo[] mBeanParameterInfoArray4 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray4[0] = new MBeanParameterInfo("pauseType", String.class.getName(), mbr.getString("MB1125"));
        pauseSignature = mBeanParameterInfoArray4;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[8];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("create", mbr.getString("MB1180"), createSignature1, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("create", mbr.getString("MB1180"), createSignature2, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("compact", mbr.getString("MB1181"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("destroy", mbr.getString("MB1182"), destroySignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getDestinations", mbr.getString("MB1183"), null, ObjectName[].class.getName(), 0);
        mBeanOperationInfoArray[5] = new MBeanOperationInfo("pause", mbr.getString("MB1184"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[6] = new MBeanOperationInfo("pause", mbr.getString("MB1185"), pauseSignature, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[7] = new MBeanOperationInfo("resume", mbr.getString("MB1186"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
        attrChangeTypes = new String[]{"jmx.attribute.change"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(attrChangeTypes, AttributeChangeNotification.class.getName(), mbr.getString("MB1025"));
        notifs = mBeanNotificationInfoArray;
    }
}

