/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.module.config;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.ClientAuthConfig;
import jakarta.security.auth.message.config.ClientAuthContext;
import jakarta.security.auth.message.module.ClientAuthModule;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.epicyro.config.delegate.MessagePolicyDelegate;
import org.glassfish.epicyro.config.helper.EpochCarrier;
import org.glassfish.epicyro.config.helper.ModulesManager;
import org.glassfish.epicyro.config.module.config.BaseAuthConfigImpl;

public class ClientAuthConfigImpl
extends BaseAuthConfigImpl
implements ClientAuthConfig {
    private static final System.Logger LOG = System.getLogger(ClientAuthConfigImpl.class.getName());
    private static final AuthStatus[] validateResponseSuccessValues = new AuthStatus[]{AuthStatus.SUCCESS};
    private static final AuthStatus[] secureResponseSuccessValues = new AuthStatus[]{AuthStatus.SEND_SUCCESS};
    private Map<String, Map<Integer, ClientAuthContext>> contextMap;
    private final ModulesManager authContextHelper;

    public ClientAuthConfigImpl(EpochCarrier providerEpoch, ModulesManager acHelper, MessagePolicyDelegate mpDelegate, String layer, String appContext, CallbackHandler cbh) throws AuthException {
        super(providerEpoch, mpDelegate, layer, appContext, cbh);
        this.authContextHelper = acHelper;
    }

    @Override
    protected void initializeContextMap() {
        this.contextMap = new HashMap<String, Map<Integer, ClientAuthContext>>();
    }

    protected void refreshContextHelper() {
        this.authContextHelper.refresh();
    }

    @Override
    protected <M> M createAuthContext(final String authContextID, final Map<String, ?> properties) throws AuthException {
        if (!this.authContextHelper.isProtected(new ClientAuthModule[0], authContextID)) {
            return null;
        }
        ClientAuthContext context = new ClientAuthContext(){
            ClientAuthModule[] module = this.init();

            ClientAuthModule[] init() throws AuthException {
                ClientAuthModule[] clientModules;
                try {
                    clientModules = ClientAuthConfigImpl.this.authContextHelper.getModules(new ClientAuthModule[0], authContextID);
                }
                catch (AuthException ae) {
                    LOG.log(System.Logger.Level.ERROR, "ClientAuthContext: " + authContextID + " of AppContext: " + ClientAuthConfigImpl.this.getAppContext() + " - unable to load client auth modules", (Throwable)ae);
                    throw ae;
                }
                MessagePolicy requestPolicy = ClientAuthConfigImpl.this.policyDelegate.getRequestPolicy(authContextID, properties);
                MessagePolicy responsePolicy = ClientAuthConfigImpl.this.policyDelegate.getResponsePolicy(authContextID, properties);
                boolean noModules = true;
                for (int i = 0; i < clientModules.length; ++i) {
                    if (clientModules[i] == null) continue;
                    LOG.log(System.Logger.Level.DEBUG, "ClientAuthContext: {0} of AppContext: {1} - initializing module", authContextID, ClientAuthConfigImpl.this.getAppContext());
                    noModules = false;
                    ClientAuthConfigImpl.this.checkMessageTypes(clientModules[i].getSupportedMessageTypes());
                    clientModules[i].initialize(requestPolicy, responsePolicy, ClientAuthConfigImpl.this.callbackHandler, ClientAuthConfigImpl.this.authContextHelper.getInitProperties(i, properties));
                }
                if (noModules) {
                    LOG.log(System.Logger.Level.WARNING, "CLientAuthContext: {0} of AppContext: {1} - contains no Auth Modules", authContextID, ClientAuthConfigImpl.this.getAppContext());
                }
                return clientModules;
            }

            public AuthStatus validateResponse(MessageInfo arg0, Subject arg1, Subject arg2) throws AuthException {
                AuthStatus[] status = new AuthStatus[this.module.length];
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    LOG.log(System.Logger.Level.DEBUG, "ClientAuthContext: {0} of AppContext: {1} - calling vaidateResponse on module", authContextID, ClientAuthConfigImpl.this.getAppContext());
                    status[i] = this.module[i].validateResponse(arg0, arg1, arg2);
                    if (!ClientAuthConfigImpl.this.authContextHelper.shouldStopProcessingModules(validateResponseSuccessValues, i, status[i])) continue;
                    return ClientAuthConfigImpl.this.authContextHelper.getReturnStatus(validateResponseSuccessValues, AuthStatus.SEND_FAILURE, status, i);
                }
                return ClientAuthConfigImpl.this.authContextHelper.getReturnStatus(validateResponseSuccessValues, AuthStatus.SEND_FAILURE, status, status.length - 1);
            }

            public AuthStatus secureRequest(MessageInfo arg0, Subject arg1) throws AuthException {
                AuthStatus[] status = new AuthStatus[this.module.length];
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    LOG.log(System.Logger.Level.DEBUG, "ClientAuthContext: {0} of AppContext: {1} - calling secureResponse on module", authContextID, ClientAuthConfigImpl.this.getAppContext());
                    status[i] = this.module[i].secureRequest(arg0, arg1);
                    if (!ClientAuthConfigImpl.this.authContextHelper.shouldStopProcessingModules(secureResponseSuccessValues, i, status[i])) continue;
                    return ClientAuthConfigImpl.this.authContextHelper.getReturnStatus(secureResponseSuccessValues, AuthStatus.SEND_FAILURE, status, i);
                }
                return ClientAuthConfigImpl.this.authContextHelper.getReturnStatus(secureResponseSuccessValues, AuthStatus.SEND_FAILURE, status, status.length - 1);
            }

            public void cleanSubject(MessageInfo arg0, Subject arg1) throws AuthException {
                for (ClientAuthModule element : this.module) {
                    if (element == null) continue;
                    LOG.log(System.Logger.Level.DEBUG, "ClientAuthContext: {0} of AppContext: {1} - calling cleanSubject on module", authContextID, ClientAuthConfigImpl.this.getAppContext());
                    element.cleanSubject(arg0, arg1);
                }
            }
        };
        return (M)context;
    }

    public ClientAuthContext getAuthContext(String authContextID, Subject subject, Map properties) throws AuthException {
        return (ClientAuthContext)super.getContext(this.contextMap, authContextID, subject, properties);
    }

    public boolean isProtected() {
        return !this.authContextHelper.returnsNullContexts() || this.policyDelegate.isProtected();
    }
}

