/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.sse.OutboundSseEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Pattern;
import org.glassfish.jersey.media.sse.SseFeature;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.MessageUtils;

class OutboundEventWriter
implements MessageBodyWriter<OutboundSseEvent> {
    private static final byte[] COMMENT_LEAD = ": ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NAME_LEAD = "event: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ID_LEAD = "id: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RETRY_LEAD = "retry: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] DATA_LEAD = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EOL = new byte[]{10};
    private static final Pattern EOL_PATTERN = Pattern.compile("\r\n|\r|\n");
    private final Provider<MessageBodyWorkers> workersProvider;

    @Inject
    public OutboundEventWriter(@Context Provider<MessageBodyWorkers> workersProvider) {
        this.workersProvider = workersProvider;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OutboundSseEvent.class.isAssignableFrom(type) && SseFeature.SERVER_SENT_EVENTS_TYPE.isCompatible(mediaType);
    }

    public long getSize(OutboundSseEvent incomingEvent, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(OutboundSseEvent outboundEvent, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Charset charset = MessageUtils.getCharset((MediaType)mediaType);
        if (outboundEvent.getComment() != null) {
            for (String comment : EOL_PATTERN.split(outboundEvent.getComment())) {
                entityStream.write(COMMENT_LEAD);
                entityStream.write(comment.getBytes(charset));
                entityStream.write(EOL);
            }
        }
        if (outboundEvent.getType() != null) {
            if (outboundEvent.getName() != null) {
                entityStream.write(NAME_LEAD);
                entityStream.write(outboundEvent.getName().replace("\r", "").replace("\n", "").getBytes(charset));
                entityStream.write(EOL);
            }
            if (outboundEvent.getId() != null) {
                entityStream.write(ID_LEAD);
                entityStream.write(outboundEvent.getId().replace("\r", "").replace("\n", "").getBytes(charset));
                entityStream.write(EOL);
            }
            if (outboundEvent.getReconnectDelay() > -1L) {
                entityStream.write(RETRY_LEAD);
                entityStream.write(Long.toString(outboundEvent.getReconnectDelay()).getBytes(charset));
                entityStream.write(EOL);
            }
            MediaType eventMediaType = outboundEvent.getMediaType() == null ? MediaType.TEXT_PLAIN_TYPE : outboundEvent.getMediaType();
            MessageBodyWriter messageBodyWriter = ((MessageBodyWorkers)this.workersProvider.get()).getMessageBodyWriter(outboundEvent.getType(), outboundEvent.getGenericType(), annotations, eventMediaType);
            DataLeadStream dataLeadStream = new DataLeadStream(entityStream);
            messageBodyWriter.writeTo(outboundEvent.getData(), outboundEvent.getType(), outboundEvent.getGenericType(), annotations, eventMediaType, httpHeaders, (OutputStream)dataLeadStream);
            dataLeadStream.finish();
            entityStream.write(EOL);
        }
    }

    static final class DataLeadStream
    extends OutputStream {
        private final OutputStream entityStream;
        private int lastChar = -1;

        DataLeadStream(OutputStream entityStream) {
            this.entityStream = entityStream;
        }

        @Override
        public void write(int i) throws IOException {
            if (this.lastChar == -1) {
                this.entityStream.write(DATA_LEAD);
            } else if (this.lastChar != 10 && this.lastChar != 13) {
                this.entityStream.write(this.lastChar);
            } else if (this.lastChar == 10 || this.lastChar == 13 && i != 10) {
                this.entityStream.write(EOL);
                this.entityStream.write(DATA_LEAD);
            }
            this.lastChar = i;
        }

        private static int indexOfEol(byte[] b, int fromIndex, int toIndex) {
            for (int i = fromIndex; i < toIndex; ++i) {
                if (b[i] != 10 && b[i] != 13) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Objects.checkFromIndexSize(off, len, b.length);
            if (len == 0) {
                return;
            }
            this.write(b[off]);
            if (len > 1) {
                int end = off + len - 1;
                int i = off;
                int j = DataLeadStream.indexOfEol(b, i, end);
                while (j != -1) {
                    this.entityStream.write(b, i, j - i);
                    this.entityStream.write(EOL);
                    this.entityStream.write(DATA_LEAD);
                    if (b[j] == 13 && b[j + 1] == 10) {
                        ++j;
                    }
                    i = ++j;
                    j = DataLeadStream.indexOfEol(b, i, end);
                }
                if (i < end) {
                    this.entityStream.write(b, i, end - i);
                }
                this.lastChar = b[end];
            }
        }

        void finish() throws IOException {
            if (this.lastChar != -1) {
                this.write(-1);
            }
        }
    }
}

