/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.fscontext;

import com.sun.jndi.fscontext.FSContext;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;

public class FSContextFactory
implements InitialContextFactory,
ObjectFactory {
    private static final boolean debug = false;
    public static final String FILE_PROTOCOL = "file";
    private static final String DEFAULT_URL = "file:///";
    static /* synthetic */ Class class$com$sun$jndi$fscontext$FSContextFactory;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Context createContext(String string, Hashtable hashtable) throws NamingException {
        String string2 = FSContextFactory.getFileNameFromURLString(string);
        return new FSContext(string2, hashtable);
    }

    protected Context createContextAux(String string, Hashtable hashtable) throws NamingException {
        return FSContextFactory.createContext(string, hashtable);
    }

    public static String getFileNameFromURLString(String string) throws NamingException {
        File file;
        URL uRL = null;
        String string2 = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            InvalidNameException invalidNameException = new InvalidNameException(string);
            invalidNameException.setRootCause(malformedURLException);
            throw invalidNameException;
        }
        if (!uRL.getProtocol().equals(FILE_PROTOCOL)) {
            throw new InvalidNameException("unknown protocol: " + uRL.getProtocol());
        }
        string2 = uRL.getFile();
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        try {
            if (string2.indexOf(37) >= 0) {
                string2 = UrlUtil.decode(string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            InvalidNameException invalidNameException = new InvalidNameException(string);
            invalidNameException.setRootCause(malformedURLException);
            throw invalidNameException;
        }
        if (string2.length() > 0 && !(file = new File(string2)).isAbsolute()) {
            string2 = file.getAbsolutePath();
        }
        return string2;
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        String string = null;
        if (hashtable != null) {
            string = (String)hashtable.get("java.naming.provider.url");
        }
        if (string == null) {
            string = DEFAULT_URL;
        }
        return this.createContextAux(string, hashtable);
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (!this.isFileRef(object)) {
            return null;
        }
        Reference reference = (Reference)object;
        StringRefAddr stringRefAddr = (StringRefAddr)reference.get("URL");
        if (stringRefAddr == null) {
            throw new ConfigurationException("no refAddr of type URL");
        }
        String string = (String)stringRefAddr.getContent();
        return this.createContextAux(string, hashtable);
    }

    protected boolean isFileRef(Object object) {
        if (!(object instanceof Reference)) {
            return false;
        }
        String string = (class$com$sun$jndi$fscontext$FSContextFactory != null ? class$com$sun$jndi$fscontext$FSContextFactory : (class$com$sun$jndi$fscontext$FSContextFactory = FSContextFactory.class$("com.sun.jndi.fscontext.FSContextFactory"))).getName();
        Reference reference = (Reference)object;
        return string.equals(reference.getFactoryClassName());
    }
}

