/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.http;

import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelSocket;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jmq.jmsclient.protocol.SocketConnectionHandler;
import jakarta.jms.JMSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HTTPConnectionHandler
extends SocketConnectionHandler {
    private static final String socketClass = "com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelSocketImpl";
    private HttpTunnelSocket socket = null;
    private String URLString = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectionHandler(Object conn) throws JMSException {
        ConnectionImpl connection = (ConnectionImpl)conn;
        this.URLString = connection.getProperty("imqConnectionURL");
        if (this.URLString == null) {
            throw new JMSException("imqConnectionURL property not found.");
        }
        try {
            this.socket = (HttpTunnelSocket)Class.forName(socketClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.socket.init(this.URLString);
        }
        catch (Exception e) {
            ExceptionHandler.handleConnectException(e, this.URLString);
        }
        finally {
            connection.setLastContactedBrokerAddress(this.URLString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectionHandler(MQAddress addr, ConnectionImpl conn) throws JMSException {
        this.URLString = addr.getURL();
        if (this.URLString == null) {
            throw new JMSException("URL not found.");
        }
        try {
            this.socket = (HttpTunnelSocket)Class.forName(socketClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.socket.init(this.URLString);
        }
        catch (Exception e) {
            ExceptionHandler.handleConnectException(e, this.URLString);
        }
        finally {
            conn.setLastContactedBrokerAddress(this.URLString);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public int getLocalPort() throws IOException {
        return this.socket.getConnId();
    }

    @Override
    protected void closeSocket() throws IOException {
        this.socket.close();
    }

    @Override
    public String getBrokerHostName() {
        return this.URLString;
    }

    @Override
    public String getBrokerAddress() {
        return this.URLString;
    }
}

