/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.sun.enterprise.admin.remote.reader.ActionReportJsonProprietaryReader;
import com.sun.enterprise.admin.remote.reader.CliActionReport;
import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import com.sun.enterprise.admin.util.AdminLoggerInfo;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandState;

public final class AdminCommandStateJsonProprietaryReader
implements ProprietaryReader<AdminCommandState> {
    @Override
    public boolean isReadable(Class<?> type, String mimetype) {
        return type.isAssignableFrom(AdminCommandState.class);
    }

    public AdminCommandState readFrom(HttpURLConnection urlConnection) throws IOException {
        return this.readFrom(urlConnection.getInputStream(), urlConnection.getContentType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdminCommandState readFrom(InputStream is, String contentType) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FileUtils.copy((InputStream)is, (OutputStream)baos);
        }
        finally {
            is.close();
        }
        String str = baos.toString(StandardCharsets.UTF_8);
        try {
            JSONObject json = new JSONObject(str);
            return AdminCommandStateJsonProprietaryReader.readAdminCommandState(json);
        }
        catch (JSONException ex) {
            LoggerRef.logger.log(Level.SEVERE, "NCLS-ADMIN-00011", ex);
            throw new IOException(ex);
        }
    }

    public static AdminCommandState readAdminCommandState(JSONObject json) throws JSONException {
        CliActionReport report;
        String strState = json.optString("state");
        AdminCommandState.State state = strState == null ? null : AdminCommandState.State.valueOf((String)strState);
        boolean emptyPayload = json.optBoolean("empty-payload", true);
        JSONObject jsonReport = json.optJSONObject("action-report");
        if (jsonReport == null) {
            report = null;
        } else {
            report = new CliActionReport();
            ActionReportJsonProprietaryReader.fillActionReport(report, jsonReport);
        }
        String id = json.optString("id");
        return new AsadminCommandState(id, state, report, emptyPayload);
    }

    static class LoggerRef {
        private static final Logger logger = AdminLoggerInfo.getLogger();

        LoggerRef() {
        }
    }

    private static final class AsadminCommandState
    implements AdminCommandState {
        private final String id;
        private final AdminCommandState.State state;
        private final ActionReport actionReport;
        private final boolean emptyPayload;

        AsadminCommandState(String id, AdminCommandState.State state, ActionReport actionReport, boolean emptyPayload) {
            this.id = id;
            this.state = state;
            this.actionReport = actionReport;
            this.emptyPayload = emptyPayload;
        }

        public AdminCommandState.State getState() {
            return this.state;
        }

        public ActionReport getActionReport() {
            return this.actionReport;
        }

        public boolean isOutboundPayloadEmpty() {
            return this.emptyPayload;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return null;
        }
    }
}

