/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.mgmt.transport.grizzly;

import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.base.PeerID;
import org.glassfish.shoal.gms.mgmt.transport.Message;
import org.glassfish.shoal.gms.mgmt.transport.MessageEvent;
import org.glassfish.shoal.gms.mgmt.transport.MessageIOException;
import org.glassfish.shoal.gms.mgmt.transport.MessageListener;
import org.glassfish.shoal.gms.mgmt.transport.grizzly.GrizzlyNetworkManager;

public class PongMessageListener
implements MessageListener {
    private static final Logger LOG = GrizzlyNetworkManager.getLogger();

    @Override
    public void receiveMessageEvent(MessageEvent event) throws MessageIOException {
        if (event == null) {
            return;
        }
        Message msg = event.getMessage();
        if (msg == null) {
            return;
        }
        Object obj = event.getSource();
        if (!(obj instanceof GrizzlyNetworkManager)) {
            return;
        }
        GrizzlyNetworkManager networkManager = (GrizzlyNetworkManager)obj;
        PeerID sourcePeerId = event.getSourcePeerID();
        if (sourcePeerId == null) {
            return;
        }
        CountDownLatch pingMessageLock = networkManager.getPingMessageLock(sourcePeerId);
        if (pingMessageLock != null) {
            pingMessageLock.countDown();
        }
    }

    @Override
    public int getType() {
        return 6;
    }
}

