/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Addressing;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.RespectBinding;
import com.sun.enterprise.deployment.WSDolSupport;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.WebServiceHandlerChain;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.runtime.ws.ReliabilityConfig;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.web.SecurityConstraint;
import com.sun.enterprise.deployment.web.UserDataConstraint;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.internal.api.Globals;

public class WebServiceEndpoint
extends Descriptor
implements HandlerChainContainer {
    private static final long serialVersionUID = 1L;
    private static final String TRANSPORT_INTEGRAL = "INTEGRAL";
    private static final String TRANSPORT_CONFIDENTIAL = "CONFIDENTIAL";
    private static final String CLIENT_CERT = "CLIENT-CERT";
    public static final String PUBLISHING_SUBCONTEXT = "__container$publishing$subctx";
    private String endpointName;
    private String serviceEndpointInterface;
    private QName wsdlPort;
    private String wsdlPortNamespacePrefix;
    private QName wsdlService;
    private String wsdlServiceNamespacePrefix;
    private String mtomEnabled;
    private String mtomThreshold;
    private String protocolBinding;
    private boolean securePipeline;
    private String ejbLink;
    private EjbDescriptor ejbComponentImpl;
    private String webComponentLink;
    private WebComponentDescriptor webComponentImpl;
    private LinkedList<WebServiceHandler> handlers;
    private LinkedList<WebServiceHandlerChain> handlerChains;
    private Addressing addressing;
    private RespectBinding respectBinding;
    private WebService webService;
    private String endpointAddressUri;
    private String authMethod;
    private String realm;
    private String transportGuarantee;
    private String serviceNamespaceUri;
    private String serviceLocalPart;
    private String servletImplClass;
    private String tieClassName;
    private MessageSecurityBindingDescriptor messageSecBindingDesc;
    private ReliabilityConfig reliabilityConfig;
    private String httpResponseBufferSize;
    private String debuggingEnabled = "true";
    private List<NameValuePairDescriptor> props;
    private String wsdlExposed;
    private String validateRequest;
    private String streamAttachments;

    public WebServiceEndpoint(WebServiceEndpoint other) {
        super((Descriptor)other);
        this.endpointName = other.endpointName;
        this.serviceEndpointInterface = other.serviceEndpointInterface;
        this.wsdlPort = other.wsdlPort;
        this.wsdlPortNamespacePrefix = other.wsdlPortNamespacePrefix;
        this.wsdlService = other.wsdlService;
        this.wsdlServiceNamespacePrefix = other.wsdlServiceNamespacePrefix;
        this.mtomEnabled = other.mtomEnabled;
        this.protocolBinding = other.protocolBinding;
        this.ejbLink = other.ejbLink;
        this.ejbComponentImpl = other.ejbComponentImpl;
        this.webComponentLink = other.webComponentLink;
        this.webComponentImpl = other.webComponentImpl;
        this.handlers = other.handlers;
        this.addressing = other.addressing;
        this.respectBinding = other.respectBinding;
        if (other.handlers == null) {
            this.handlers = null;
        } else {
            this.handlers = new LinkedList();
            for (WebServiceHandler handler : other.handlers) {
                this.handlers.addLast(new WebServiceHandler(handler));
            }
        }
        if (other.handlerChains == null) {
            this.handlers = null;
        } else {
            this.handlerChains = new LinkedList();
            for (WebServiceHandlerChain handlerChain : other.handlerChains) {
                this.handlerChains.addLast(new WebServiceHandlerChain(handlerChain));
            }
        }
        this.webService = other.webService;
        this.endpointAddressUri = other.endpointAddressUri;
        this.authMethod = other.authMethod;
        this.transportGuarantee = other.transportGuarantee;
        this.serviceNamespaceUri = other.serviceNamespaceUri;
        this.serviceLocalPart = other.serviceLocalPart;
        this.servletImplClass = other.servletImplClass;
        this.tieClassName = other.tieClassName;
        this.wsdlExposed = other.wsdlExposed;
    }

    public WebServiceEndpoint() {
        this.handlers = new LinkedList();
        this.handlerChains = new LinkedList();
        this.authMethod = null;
        this.wsdlPort = null;
    }

    public void setWebService(WebService service) {
        this.webService = service;
    }

    public String getMtomThreshold() {
        return this.mtomThreshold;
    }

    public void setMtomThreshold(String mtomThreshold) {
        this.mtomThreshold = mtomThreshold;
    }

    public WebService getWebService() {
        return this.webService;
    }

    public Addressing getAddressing() {
        return this.addressing;
    }

    public void setAddressing(Addressing addressing) {
        this.addressing = addressing;
    }

    public RespectBinding getRespectBinding() {
        return this.respectBinding;
    }

    public void setRespectBinding(RespectBinding respectBinding) {
        this.respectBinding = respectBinding;
    }

    public void setSecurePipeline() {
        this.securePipeline = true;
    }

    public boolean hasSecurePipeline() {
        return this.securePipeline;
    }

    public void setEndpointName(String name) {
        this.endpointName = name;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setServiceEndpointInterface(String endpointInterface) {
        this.serviceEndpointInterface = endpointInterface;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setProtocolBinding(String value) {
        WSDolSupport dolSupport = (WSDolSupport)Globals.getDefaultHabitat().getService(WSDolSupport.class, new Annotation[0]);
        this.protocolBinding = dolSupport == null ? value : dolSupport.getProtocolBinding(value);
    }

    public String getProtocolBinding() {
        WSDolSupport dolSupport = (WSDolSupport)Globals.getDefaultHabitat().getService(WSDolSupport.class, new Annotation[0]);
        if (this.protocolBinding == null && dolSupport != null) {
            this.protocolBinding = dolSupport.getProtocolBinding(null);
        }
        return this.protocolBinding;
    }

    public boolean hasUserSpecifiedProtocolBinding() {
        return this.protocolBinding != null;
    }

    public void setMtomEnabled(String value) {
        this.mtomEnabled = value;
    }

    public String getMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setWsdlService(QName svc, String prefix) {
        this.wsdlService = svc;
        this.wsdlServiceNamespacePrefix = prefix;
        this.serviceNamespaceUri = svc.getNamespaceURI();
        this.serviceLocalPart = svc.getLocalPart();
    }

    public void setWsdlService(QName service) {
        this.wsdlService = service;
        this.wsdlServiceNamespacePrefix = service.getPrefix();
        this.serviceNamespaceUri = service.getNamespaceURI();
        this.serviceLocalPart = service.getLocalPart();
    }

    public String getWsdlServiceNamespacePrefix() {
        return this.wsdlServiceNamespacePrefix;
    }

    public boolean hasWsdlServiceNamespacePrefix() {
        return this.wsdlServiceNamespacePrefix != null;
    }

    public QName getWsdlService() {
        return this.wsdlService;
    }

    public void setWsdlPort(QName port, String prefix) {
        this.wsdlPort = port;
        this.wsdlPortNamespacePrefix = prefix;
    }

    public void setWsdlPort(QName port) {
        this.wsdlPort = port;
        this.wsdlPortNamespacePrefix = port.getPrefix();
    }

    public String getWsdlPortNamespacePrefix() {
        return this.wsdlPortNamespacePrefix;
    }

    public boolean hasWsdlPortNamespacePrefix() {
        return this.wsdlPortNamespacePrefix != null;
    }

    public boolean hasWsdlPort() {
        return this.wsdlPort != null;
    }

    public QName getWsdlPort() {
        return this.wsdlPort;
    }

    public void setMessageSecurityBinding(MessageSecurityBindingDescriptor messageSecBindingDesc) {
        this.messageSecBindingDesc = messageSecBindingDesc;
    }

    public MessageSecurityBindingDescriptor getMessageSecurityBinding() {
        return this.messageSecBindingDesc;
    }

    public ReliabilityConfig getReliabilityConfig() {
        return this.reliabilityConfig;
    }

    public void setReliabilityConfig(ReliabilityConfig reliabilityConfig) {
        this.reliabilityConfig = reliabilityConfig;
    }

    public String getHttpResponseBufferSize() {
        return this.httpResponseBufferSize;
    }

    public void setHttpResponseBufferSize(String httpResponseBufferSize) {
        this.httpResponseBufferSize = httpResponseBufferSize;
    }

    public BundleDescriptor getBundleDescriptor() {
        return this.getWebService().getBundleDescriptor();
    }

    public boolean implementedByEjbComponent() {
        return this.ejbLink != null;
    }

    public boolean implementedByEjbComponent(EjbDescriptor ejb) {
        return this.ejbLink != null && this.ejbLink.equals(ejb.getName());
    }

    public boolean implementedByWebComponent() {
        return this.webComponentLink != null;
    }

    public boolean implementedByWebComponent(WebComponentDescriptor webComp) {
        return this.webComponentLink != null && this.webComponentLink.equals(webComp.getCanonicalName());
    }

    public String getLinkName() {
        if (this.implementedByEjbComponent()) {
            return this.ejbLink;
        }
        if (this.implementedByWebComponent()) {
            return this.webComponentLink;
        }
        return null;
    }

    public void setEjbLink(String link) {
        this.ejbLink = link;
    }

    public String getEjbLink() {
        return this.ejbLink;
    }

    public void setEjbComponentImpl(EjbDescriptor ejbComponent) {
        this.webComponentImpl = null;
        this.webComponentLink = null;
        this.ejbLink = ejbComponent.getName();
        this.ejbComponentImpl = ejbComponent;
    }

    public EjbDescriptor getEjbComponentImpl() {
        return this.ejbComponentImpl;
    }

    public void setWebComponentLink(String link) {
        this.webComponentLink = link;
    }

    public String getWebComponentLink() {
        return this.webComponentLink;
    }

    public void setWebComponentImpl(WebComponentDescriptor webComponent) {
        this.ejbComponentImpl = null;
        this.ejbLink = null;
        this.webComponentLink = webComponent.getCanonicalName();
        this.webComponentImpl = webComponent;
    }

    public WebComponentDescriptor getWebComponentImpl() {
        return this.webComponentImpl;
    }

    public boolean hasHandlers() {
        return !this.handlers.isEmpty();
    }

    public void addHandler(WebServiceHandler handler) {
        this.handlers.addLast(handler);
    }

    public void removeHandler(WebServiceHandler handler) {
        this.handlers.remove((Object)handler);
    }

    public void removeHandlerByName(String handlerName) {
        Iterator iter = this.handlers.iterator();
        while (iter.hasNext()) {
            WebServiceHandler next = (WebServiceHandler)((Object)iter.next());
            if (!next.getHandlerName().equals(handlerName)) continue;
            iter.remove();
            break;
        }
    }

    public LinkedList<WebServiceHandler> getHandlers() {
        return this.handlers;
    }

    public LinkedList<WebServiceHandlerChain> getHandlerChain() {
        return this.handlerChains;
    }

    @Override
    public boolean hasHandlerChain() {
        return !this.handlerChains.isEmpty();
    }

    @Override
    public void addHandlerChain(WebServiceHandlerChain handlerChain) {
        this.handlerChains.addLast(handlerChain);
    }

    public void removeHandlerChain(WebServiceHandlerChain handlerChain) {
        this.handlerChains.remove((Object)handlerChain);
    }

    public boolean hasEndpointAddressUri() {
        return this.endpointAddressUri != null;
    }

    public void setEndpointAddressUri(String uri) {
        if (!((String)uri).startsWith("/")) {
            uri = "/" + (String)uri;
        }
        this.endpointAddressUri = uri;
    }

    public String getEndpointAddressUri() {
        if (this.implementedByEjbComponent() && !this.hasEndpointAddressUri()) {
            this.setEndpointAddressUri("/" + this.getWebService().getName() + "/" + this.getEndpointName());
        }
        return this.endpointAddressUri;
    }

    public boolean isSecure() {
        return this.hasTransportGuarantee() && (this.transportGuarantee.equals(TRANSPORT_INTEGRAL) || this.transportGuarantee.equals(TRANSPORT_CONFIDENTIAL));
    }

    public void setAuthMethod(String authType) {
        this.authMethod = authType;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public boolean hasAuthMethod() {
        return this.authMethod != null;
    }

    public boolean hasBasicAuth() {
        return this.authMethod != null && this.authMethod.equals("BASIC");
    }

    public boolean hasClientCertAuth() {
        return this.authMethod != null && this.authMethod.equals(CLIENT_CERT);
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setTransportGuarantee(String guarantee) {
        this.transportGuarantee = guarantee;
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public boolean hasTransportGuarantee() {
        return this.transportGuarantee != null;
    }

    public void setServiceNamespaceUri(String uri) {
        this.serviceNamespaceUri = uri;
    }

    public void setServiceLocalPart(String localpart) {
        this.serviceLocalPart = localpart;
    }

    public boolean hasServiceName() {
        return this.serviceNamespaceUri != null && this.serviceLocalPart != null;
    }

    public QName getServiceName() {
        return this.hasServiceName() ? new QName(this.serviceNamespaceUri, this.serviceLocalPart) : null;
    }

    public boolean hasServletImplClass() {
        return this.servletImplClass != null;
    }

    public void setServletImplClass(String implClass) {
        this.servletImplClass = implClass;
    }

    public String getServletImplClass() {
        return this.servletImplClass;
    }

    public boolean hasTieClassName() {
        return this.tieClassName != null;
    }

    public void setTieClassName(String tieClass) {
        this.tieClassName = tieClass;
    }

    public String getTieClassName() {
        return this.tieClassName;
    }

    public String getDebugging() {
        return this.debuggingEnabled;
    }

    public void setDebugging(String debuggingEnabled) {
        this.debuggingEnabled = debuggingEnabled;
    }

    public void addProperty(NameValuePairDescriptor newProp) {
        if (this.props == null) {
            this.props = new ArrayList<NameValuePairDescriptor>();
        }
        this.props.add(newProp);
    }

    public Iterator<NameValuePairDescriptor> getProperties() {
        if (this.props == null) {
            return null;
        }
        return this.props.iterator();
    }

    public String getWsdlExposed() {
        return this.wsdlExposed;
    }

    public void setWsdlExposed(String wsdlExposed) {
        this.wsdlExposed = wsdlExposed;
    }

    public String getValidateRequest() {
        return this.validateRequest;
    }

    public void setValidateRequest(String validateRequests) {
        this.validateRequest = validateRequests;
    }

    public String getStreamAttachments() {
        return this.streamAttachments;
    }

    public void setStreamAttachments(String streamAttachments) {
        this.streamAttachments = streamAttachments;
    }

    public URL composeEndpointAddress(URL root) throws MalformedURLException {
        return this.composeEndpointAddress(root, null);
    }

    public URL composeEndpointAddress(URL root, String contextRoot) throws MalformedURLException {
        String uri = this.getEndpointAddressPath(contextRoot);
        return new URL(root.getProtocol(), root.getHost(), root.getPort(), uri);
    }

    public String getEndpointAddressPath() {
        return this.getEndpointAddressPath(null);
    }

    private String getEndpointAddressPath(String cr) {
        if (this.implementedByWebComponent()) {
            Object contextRoot;
            if (this.endpointAddressUri == null) {
                this.updateServletEndpointRuntime();
            }
            WebBundleDescriptor webBundle = this.webComponentImpl.getWebBundleDescriptor();
            Object object = contextRoot = cr == null ? webBundle.getContextRoot() : cr;
            if (contextRoot == null) {
                return null;
            }
            if (!((String)contextRoot).startsWith("/")) {
                contextRoot = "/" + (String)contextRoot;
            }
            return (String)contextRoot + (String)(this.endpointAddressUri.startsWith("/") ? this.endpointAddressUri : "/" + this.endpointAddressUri);
        }
        return this.getEndpointAddressUri();
    }

    public boolean resolveComponentLink() {
        boolean resolved = false;
        if (this.ejbLink == null) {
            WebBundleDescriptor webBundle;
            WebComponentDescriptor webComponent;
            if (this.webComponentLink != null && (webComponent = (webBundle = this.getWebBundle()).getWebComponentByCanonicalName(this.webComponentLink)) != null) {
                resolved = true;
                this.setWebComponentImpl(webComponent);
            }
        } else {
            EjbBundleDescriptor ejbBundle = this.getEjbBundle();
            if (ejbBundle.hasEjbByName(this.ejbLink)) {
                resolved = true;
                EjbDescriptor ejb = ejbBundle.getEjbByName(this.ejbLink);
                this.setEjbComponentImpl(ejb);
            }
        }
        return resolved;
    }

    public URL composeFinalWsdlUrl(URL root) throws MalformedURLException {
        URL context = this.composeEndpointAddress(root);
        String mainFile = context.getFile() + "/__container$publishing$subctx/" + this.webService.getWsdlFileUri();
        return new URL(context.getProtocol(), context.getHost(), context.getPort(), mainFile);
    }

    public String getPublishingUri() {
        String uri = this.endpointAddressUri.startsWith("/") ? this.endpointAddressUri.substring(1) : this.endpointAddressUri;
        return uri + "/__container$publishing$subctx";
    }

    public boolean matchesEjbPublishRequest(String requestUriRaw, String query) {
        String requestUri;
        String string = requestUri = requestUriRaw.charAt(0) == '/' ? requestUriRaw.substring(1) : requestUriRaw;
        if (query == null) {
            String publishingUri = this.getPublishingUri() + "/";
            return requestUri.startsWith(publishingUri);
        }
        String toMatch = this.endpointAddressUri.charAt(0) == '/' ? this.endpointAddressUri.substring(1) : this.endpointAddressUri;
        return requestUri.equals(toMatch) && (query.equalsIgnoreCase("WSDL") || query.startsWith("xsd=") || query.startsWith("wsdl="));
    }

    public String getWsdlContentPath(String requestUri) {
        String publishingRoot;
        String uri = requestUri.charAt(0) == '/' ? requestUri.substring(1) : requestUri;
        String publishingUriRaw = this.getPublishingUri();
        if (this.implementedByWebComponent()) {
            WebBundleDescriptor webBundle = this.webComponentImpl.getWebBundleDescriptor();
            String contextRoot = webBundle.getContextRoot();
            if (contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
            publishingRoot = contextRoot + "/" + publishingUriRaw + "/";
        } else {
            publishingRoot = publishingUriRaw + "/";
        }
        return uri.startsWith(publishingRoot) ? uri.substring(publishingRoot.length()) : null;
    }

    public void saveServletImplClass() {
        if (!this.implementedByWebComponent()) {
            throw new IllegalStateException("requires ejb");
        }
        this.servletImplClass = this.webComponentImpl.getWebComponentImplementation();
    }

    private void updateServletEndpointRuntime() {
        WebComponentDescriptor wc = ((WebBundleDescriptor)this.webService.getBundleDescriptor()).getWebComponentByCanonicalName(this.webComponentImpl.getCanonicalName());
        if (wc != this.webComponentImpl) {
            this.setWebComponentImpl(wc);
        }
        this.saveServletImplClass();
        WebBundleDescriptor bundle = this.webComponentImpl.getWebBundleDescriptor();
        WebServicesDescriptor webServices = bundle.getWebServices();
        Collection<WebServiceEndpoint> endpoints = webServices.getEndpointsImplementedBy(this.webComponentImpl);
        if (endpoints.size() > 1) {
            String msg = "Servlet " + this.getWebComponentLink() + " implements " + endpoints.size() + " web service endpoints  but must only implement 1";
            throw new IllegalStateException(msg);
        }
        if (this.getEndpointAddressUri() == null) {
            Set<String> urlPatterns = this.webComponentImpl.getUrlPatternsSet();
            if (urlPatterns.size() == 1) {
                String uri = urlPatterns.iterator().next();
                this.setEndpointAddressUri(uri);
                Collection<SecurityConstraint> constraints = bundle.getSecurityConstraintsForUrlPattern(uri);
                for (SecurityConstraint constraint : constraints) {
                    UserDataConstraint dataConstraint = constraint.getUserDataConstraint();
                    String guarantee = dataConstraint == null ? null : dataConstraint.getTransportGuarantee();
                    if (guarantee == null || !guarantee.equals(TRANSPORT_INTEGRAL) && !guarantee.equals(TRANSPORT_CONFIDENTIAL)) continue;
                    this.setTransportGuarantee(guarantee);
                    break;
                }
            } else {
                String msg = "Endpoint " + this.getEndpointName() + " has not been assigned an endpoint address  and is associated with servlet " + this.webComponentImpl.getCanonicalName() + " , which has " + urlPatterns.size() + " url patterns";
                throw new IllegalStateException(msg);
            }
        }
    }

    public String getSoapAddressPrefix() {
        WSDolSupport dolSupport = (WSDolSupport)Globals.getDefaultHabitat().getService(WSDolSupport.class, new Annotation[0]);
        if (dolSupport == null) {
            return "so`ap";
        }
        return dolSupport.getSoapAddressPrefix(this.protocolBinding);
    }

    public void print(StringBuffer toStringBuffer) {
        super.print(toStringBuffer);
        toStringBuffer.append("\n endpoint name = ").append(this.endpointName);
        toStringBuffer.append("\n endpoint intf = ").append(this.serviceEndpointInterface);
        toStringBuffer.append("\n wsdl Port = ").append(this.wsdlPort);
        toStringBuffer.append("\n wsdl Addressing = ").append((Object)this.addressing);
        toStringBuffer.append("\n wsdl RespectBinding = ").append((Object)this.respectBinding);
        toStringBuffer.append("\n ejb Link = ").append(this.ejbLink);
        toStringBuffer.append("\n web Link = ").append(this.webComponentLink);
    }

    private EjbBundleDescriptor getEjbBundle() {
        return (EjbBundleDescriptor)this.getBundleDescriptor();
    }

    private WebBundleDescriptor getWebBundle() {
        return (WebBundleDescriptor)this.getBundleDescriptor();
    }
}

