/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jsonb.internal;

import jakarta.inject.Inject;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NoContentException;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.glassfish.jersey.jsonb.LocalizationMessages;
import org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import org.glassfish.jersey.message.internal.EntityInputStream;
import org.glassfish.jersey.message.internal.ReaderWriter;

@Provider
@Produces(value={"application/json", "text/json", "*/*"})
@Consumes(value={"application/json", "text/json", "*/*"})
public class JsonBindingProvider
extends AbstractMessageReaderWriterProvider<Object> {
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";
    private final Providers providers;

    @Inject
    public JsonBindingProvider(@Context Providers providers) {
        this.providers = providers;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonBindingProvider.supportsMediaType(mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        EntityInputStream entityInputStream = new EntityInputStream(entityStream);
        entityStream = entityInputStream;
        if (entityInputStream.isEmpty()) {
            throw new NoContentException(LocalizationMessages.ERROR_JSONB_EMPTYSTREAM());
        }
        Jsonb jsonb = this.getJsonb(type);
        try {
            return jsonb.fromJson(entityStream, genericType);
        }
        catch (JsonbException e) {
            throw new ProcessingException(LocalizationMessages.ERROR_JSONB_DESERIALIZATION(), (Throwable)e);
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonBindingProvider.supportsMediaType(mediaType);
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Jsonb jsonb = this.getJsonb(type);
        try {
            entityStream.write(jsonb.toJson(o).getBytes(ReaderWriter.getCharset((MediaType)mediaType)));
            entityStream.flush();
        }
        catch (IOException e) {
            throw new ProcessingException(LocalizationMessages.ERROR_JSONB_SERIALIZATION(), (Throwable)e);
        }
    }

    private Jsonb getJsonb(Class<?> type) {
        ContextResolver contextResolver = this.providers.getContextResolver(Jsonb.class, MediaType.APPLICATION_JSON_TYPE);
        if (contextResolver != null) {
            return (Jsonb)contextResolver.getContext(type);
        }
        return JsonbSingleton.INSTANCE.getInstance();
    }

    private static boolean supportsMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }

    private static enum JsonbSingleton {
        INSTANCE;

        private Jsonb jsonbInstance = JsonbBuilder.create();

        Jsonb getInstance() {
            return this.jsonbInstance;
        }
    }
}

