/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.jakartapersistence;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jnosql.jakartapersistence.communication.EntityManagerProvider;
import org.eclipse.jnosql.jakartapersistence.communication.PersistenceDatabaseManagerProvider;
import org.eclipse.jnosql.jakartapersistence.mapping.EnsureTransactionInterceptor;
import org.eclipse.jnosql.jakartapersistence.mapping.cache.PersistenceUnitCacheProvider;
import org.eclipse.jnosql.jakartapersistence.mapping.repository.AbstractRepositoryPersistenceBean;
import org.eclipse.jnosql.jakartapersistence.mapping.spi.MethodInterceptor;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.spi.AbstractBean;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.main.jnosql.jakartapersistence.GlassFishRepositoryInterceptor;
import org.glassfish.main.jnosql.jakartapersistence.JakartaDataApplicationContext;
import org.glassfish.main.jnosql.util.CdiExtensionUtil;

public class JakartaPersistenceIntegrationExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(JakartaPersistenceIntegrationExtension.class.getName());

    void afterBeanDiscovery(@Observes @Priority(value=1000) AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        Types types = JakartaPersistenceIntegrationExtension.getTypes();
        afterBeanDiscovery.addBean().types(new Type[]{JakartaDataApplicationContext.class}).scope(Dependent.class).createWith(ctx -> new JakartaDataApplicationContext(types));
        CdiExtensionUtil.addBean(GlassFishRepositoryInterceptor.class, afterBeanDiscovery, beanManager).types(new Type[]{MethodInterceptor.class}).qualifiers(new Annotation[]{MethodInterceptor.Repository.INSTANCE}).alternative(true).priority(0).scope(ApplicationScoped.class);
        this.defineJNoSqlBeans(afterBeanDiscovery, beanManager);
    }

    private void defineJNoSqlBeans(AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        Class[] dummyBeansClasses;
        for (Class dummyBeanClass : dummyBeansClasses = new Class[]{AbstractBean.class, AbstractRepositoryPersistenceBean.class}) {
            afterBeanDiscovery.addBean().types(new Type[]{dummyBeanClass}).scope(ApplicationScoped.class).qualifiers(new Annotation[]{Default.Literal.INSTANCE}).createWith(ctx -> null);
        }
        List<BeanConfigurator<PersistenceUnitCacheProvider>> configurations = List.of(CdiExtensionUtil.addBean(Converters.class, afterBeanDiscovery, beanManager), CdiExtensionUtil.addBean(PersistenceDatabaseManagerProvider.class, afterBeanDiscovery, beanManager), CdiExtensionUtil.addBean(EntityManagerProvider.class, afterBeanDiscovery, beanManager), CdiExtensionUtil.addBean(EnsureTransactionInterceptor.class, afterBeanDiscovery, beanManager), CdiExtensionUtil.addBean(EnsureTransactionInterceptor.RunInGlobalTransaction.class, afterBeanDiscovery, beanManager), CdiExtensionUtil.addBean(PersistenceUnitCacheProvider.class, afterBeanDiscovery, beanManager));
        for (BeanConfigurator<PersistenceUnitCacheProvider> configurator : configurations) {
            configurator.scope(ApplicationScoped.class).alternative(true).priority(4000);
        }
    }

    private static Types getTypes() {
        DeploymentContext deploymentContext = ((Deployment)Globals.getDefaultHabitat().getService(Deployment.class, new Annotation[0])).getCurrentDeploymentContext();
        return (Types)deploymentContext.getTransientAppMetaData(Types.class.getName(), Types.class);
    }
}

