/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.ConnectionCustomizer;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.expressions.SpatialExpressionOperators;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.platform.database.XMLTypePlaceholder;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPHelper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPLTZWrapper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPTZWrapper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPTypes;
import org.eclipse.persistence.internal.platform.database.oracle.XMLTypeFactory;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.oracle.NCharacter;
import org.eclipse.persistence.platform.database.oracle.NClob;
import org.eclipse.persistence.platform.database.oracle.NString;
import org.eclipse.persistence.platform.database.oracle.Oracle8Platform;
import org.eclipse.persistence.platform.database.oracle.OracleJDBC_10_1_0_2ProxyConnectionCustomizer;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Document;

public class Oracle9Platform
extends Oracle8Platform {
    public static final Class<NCharacter> NCHAR = NCharacter.class;
    public static final Class<NString> NSTRING = NString.class;
    public static final Class<NClob> NCLOB = NClob.class;
    public static final Class<XMLTypePlaceholder> XMLTYPE = XMLTypePlaceholder.class;
    protected transient String driverVersion;
    protected transient boolean shouldPrintCalendar;
    protected transient boolean isTimestampInGmt;
    protected transient boolean isLtzTimestampInGmt;
    protected transient boolean isConnectionDataInitialized;
    protected boolean shouldTruncateDate;
    private XMLTypeFactory xmlTypeFactory;
    private transient String connectionUserName = null;
    private static final Class<TIMESTAMP> ORACLE_SQL_TIMESTAMP = TIMESTAMP.class;
    private static final Class<TIMESTAMPTZ> ORACLE_SQL_TIMESTAMPTZ = TIMESTAMPTZ.class;
    private static final Class<TIMESTAMPLTZ> ORACLE_SQL_TIMESTAMPLTZ = TIMESTAMPLTZ.class;

    @Override
    public void copyInto(Platform platform) {
        super.copyInto(platform);
        if (!(platform instanceof Oracle9Platform)) {
            return;
        }
        Oracle9Platform oracle9Platform = (Oracle9Platform)platform;
        oracle9Platform.setShouldTruncateDate(this.shouldTruncateDate());
    }

    public Object getObjectFromResultSet(ResultSet resultSet, int columnNumber, int type, AbstractSession session) throws SQLException {
        if (type == 93 || type == 91) {
            return resultSet.getTimestamp(columnNumber);
        }
        if (type == -101) {
            return this.getTIMESTAMPTZFromResultSet(resultSet, columnNumber);
        }
        if (type == -102) {
            return this.getTIMESTAMPLTZFromResultSet(resultSet, columnNumber, session);
        }
        if (type == -8) {
            return resultSet.getString(columnNumber);
        }
        if (type == 2009) {
            SQLXML sqlXml = resultSet.getSQLXML(columnNumber);
            String str = null;
            if (sqlXml != null) {
                str = sqlXml.getString();
                sqlXml.free();
            }
            return str != null && str.endsWith("\n") ? str.substring(0, str.length() - 1) : str;
        }
        if (type == 2007) {
            try {
                Object result = resultSet.getObject(columnNumber);
                if (!(result instanceof OracleOpaque)) {
                    return result;
                }
                return this.getXMLTypeFactory().getString((OracleOpaque)result);
            }
            catch (SQLException ex) {
                throw DatabaseException.sqlException((SQLException)ex, null, (AbstractSession)session, (boolean)false);
            }
        }
        return super.getObjectFromResultSet(resultSet, columnNumber, type, session);
    }

    public Object getTIMESTAMPTZFromResultSet(ResultSet resultSet, int columnNumber) throws SQLException {
        TIMESTAMPTZ tsTZ = (TIMESTAMPTZ)resultSet.getObject(columnNumber);
        if (tsTZ != null && tsTZ.getLength() != 0L) {
            return new TIMESTAMPTZWrapper(tsTZ.toZonedDateTime());
        }
        return null;
    }

    public Object getTIMESTAMPLTZFromResultSet(ResultSet resultSet, int columnNumber, AbstractSession session) throws SQLException {
        TIMESTAMPLTZ tsLTZ = (TIMESTAMPLTZ)resultSet.getObject(columnNumber);
        if (tsLTZ != null && tsLTZ.getLength() != 0L) {
            return new TIMESTAMPLTZWrapper(tsLTZ.zonedDateTimeValue(this.getConnection(session, resultSet.getStatement().getConnection())), this.isLtzTimestampInGmt);
        }
        return null;
    }

    @Override
    public boolean shouldUseCustomModifyForCall(DatabaseField field) {
        Class type = field.getType();
        if (type != null && this.isOracle9Specific(type)) {
            return true;
        }
        return super.shouldUseCustomModifyForCall(field);
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.extractXml());
        this.addOperator(ExpressionOperator.extractValue());
        this.addOperator(ExpressionOperator.existsNode());
        this.addOperator(ExpressionOperator.isFragment());
        this.addOperator(ExpressionOperator.getStringVal());
        this.addOperator(ExpressionOperator.getNumberVal());
        this.addOperator(SpatialExpressionOperators.withinDistance());
        this.addOperator(SpatialExpressionOperators.relate());
        this.addOperator(SpatialExpressionOperators.filter());
        this.addOperator(SpatialExpressionOperators.nearestNeighbor());
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses((int)150, (String)"CURRENT_TIMESTAMP"));
        this.addOperator(ExpressionOperator.simpleFunctionNoParentheses((int)151, (String)"CURRENT_TIMESTAMP"));
    }

    @Override
    protected Hashtable<Class<?>, FieldTypeDefinition> buildFieldTypes() {
        Hashtable<Class<?>, FieldTypeDefinition> fieldTypes = super.buildFieldTypes();
        fieldTypes.put(Document.class, new FieldTypeDefinition("sys.XMLType"));
        fieldTypes.put(Time.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypes.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypes.put(ORACLE_SQL_TIMESTAMP, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypes.put(ORACLE_SQL_TIMESTAMPTZ, new FieldTypeDefinition("TIMESTAMP WITH TIME ZONE", false));
        fieldTypes.put(ORACLE_SQL_TIMESTAMPLTZ, new FieldTypeDefinition("TIMESTAMP WITH LOCAL TIME ZONE", false));
        return fieldTypes;
    }

    protected String buildFirstRowsHint(int max) {
        return this.HINT_START + "(" + max + ")" + this.HINT_END;
    }

    protected Map<String, Class<?>> buildClassTypes() {
        Map classTypeMapping = super.buildClassTypes();
        classTypeMapping.put("TIMESTAMP", ORACLE_SQL_TIMESTAMP);
        classTypeMapping.put("TIMESTAMP WITH TIME ZONE", ORACLE_SQL_TIMESTAMPTZ);
        classTypeMapping.put("TIMESTAMP WITH LOCAL TIME ZONE", ORACLE_SQL_TIMESTAMPLTZ);
        return classTypeMapping;
    }

    public Object clone() {
        Oracle9Platform clone = (Oracle9Platform)((Object)super.clone());
        clone.clearConnectionData();
        return clone;
    }

    public <T> T convertObject(Object sourceObject, Class<T> javaClass) throws ConversionException, DatabaseException {
        if (javaClass == null || sourceObject != null && sourceObject.getClass() == javaClass) {
            return (T)sourceObject;
        }
        if (sourceObject == null) {
            return (T)super.convertObject(sourceObject, javaClass);
        }
        Object valueToConvert = sourceObject;
        if (javaClass == TIMESTAMPTypes.TIMESTAMP_CLASS) {
            if (sourceObject instanceof Calendar) {
                return (T)new TIMESTAMP(new Timestamp(((Calendar)sourceObject).getTimeInMillis()), (Calendar)sourceObject);
            }
            return (T)sourceObject;
        }
        if (javaClass == TIMESTAMPTypes.TIMESTAMPLTZ_CLASS) {
            if (sourceObject instanceof Calendar) {
                try {
                    return (T)new TIMESTAMPLTZWrapper(ZonedDateTime.ofInstant(((Calendar)sourceObject).toInstant(), ((Calendar)sourceObject).getTimeZone().toZoneId()), this.isLtzTimestampInGmt);
                }
                catch (SQLException exception) {
                    throw DatabaseException.sqlException((SQLException)exception);
                }
            }
            return (T)sourceObject;
        }
        if (javaClass == TIMESTAMPTypes.TIMESTAMPTZ_CLASS) {
            if (sourceObject instanceof java.util.Date) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(((java.util.Date)sourceObject).getTime());
                return (T)cal;
            }
            if (sourceObject instanceof Calendar) {
                try {
                    return (T)new TIMESTAMPTZ(ZonedDateTime.ofInstant(((Calendar)sourceObject).toInstant(), ((Calendar)sourceObject).getTimeZone().toZoneId()));
                }
                catch (SQLException exception) {
                    throw DatabaseException.sqlException((SQLException)exception);
                }
            }
            return (T)sourceObject;
        }
        if (javaClass == XMLTYPE) {
            return (T)sourceObject;
        }
        if (sourceObject instanceof TIMESTAMP) {
            try {
                valueToConvert = ((TIMESTAMP)sourceObject).timestampValue();
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException((SQLException)exception);
            }
        }
        if (sourceObject instanceof TIMESTAMPTZWrapper) {
            if (javaClass == ClassConstants.CALENDAR || javaClass == ClassConstants.GREGORIAN_CALENDAR) {
                return (T)TIMESTAMPHelper.buildCalendar((TIMESTAMPTZWrapper)sourceObject);
            }
            try {
                valueToConvert = ((TIMESTAMPTZWrapper)sourceObject).unwrap(javaClass);
            }
            catch (IllegalArgumentException e) {
                valueToConvert = ((TIMESTAMPTZWrapper)sourceObject).getTimestamp();
            }
        } else if (sourceObject instanceof TIMESTAMPLTZWrapper) {
            if (javaClass == ClassConstants.CALENDAR || javaClass == ClassConstants.GREGORIAN_CALENDAR) {
                return (T)TIMESTAMPHelper.buildCalendar((TIMESTAMPLTZWrapper)sourceObject);
            }
            try {
                valueToConvert = ((TIMESTAMPLTZWrapper)sourceObject).unwrap(javaClass);
            }
            catch (IllegalArgumentException e) {
                valueToConvert = ((TIMESTAMPLTZWrapper)sourceObject).getTimestamp();
            }
        }
        return (T)super.convertObject(valueToConvert, javaClass);
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_timestamp('");
            writer.write(Helper.printTimestamp((Timestamp)timestamp));
            writer.write("','yyyy-mm-dd HH24:MI:SS.FF')");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_timestamp_tz('");
            writer.write(TIMESTAMPHelper.printCalendar(calendar));
            if (TIMESTAMPHelper.shouldAppendDaylightTime(calendar)) {
                writer.write("','yyyy-mm-dd HH24:MI:SS.FF TZR TZD')");
            } else {
                writer.write("','yyyy-mm-dd HH24:MI:SS.FF TZR')");
            }
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    public void initializeConnectionData(Connection connection) throws SQLException {
        if (this.isConnectionDataInitialized || connection == null || connection.getMetaData() == null) {
            return;
        }
        this.driverVersion = connection.getMetaData().getDriverVersion();
        boolean bl = this.shouldPrintCalendar = Helper.compareVersions((String)"9", (String)this.driverVersion) <= 0 && Helper.compareVersions((String)this.driverVersion, (String)"10.2.0.4") < 0;
        if (Helper.compareVersions((String)this.driverVersion, (String)"11.1.0.7") >= 0) {
            if (connection instanceof oracle.jdbc.OracleConnection) {
                oracle.jdbc.OracleConnection oraConn = (oracle.jdbc.OracleConnection)connection;
                String timestampTzInGmtPropStr = oraConn.getProperties().getProperty("oracle.jdbc.timestampTzInGmt", "true");
                this.connectionUserName = oraConn.getUserName();
                this.isTimestampInGmt = timestampTzInGmtPropStr.equalsIgnoreCase("true");
            } else {
                this.connectionUserName = connection.getMetaData().getUserName();
                this.isTimestampInGmt = true;
            }
            if (Helper.compareVersions((String)this.driverVersion, (String)"11.2.0.2") >= 0) {
                this.isLtzTimestampInGmt = true;
            }
        }
        this.isConnectionDataInitialized = true;
    }

    public void clearConnectionData() {
        this.driverVersion = null;
        this.isConnectionDataInitialized = false;
    }

    public void clearOracleConnectionCache(Connection conn) {
        if (conn instanceof oracle.jdbc.OracleConnection) {
            oracle.jdbc.OracleConnection oracleConnection = (oracle.jdbc.OracleConnection)conn;
            try {
                if (oracleConnection.getImplicitCachingEnabled()) {
                    oracleConnection.purgeImplicitCache();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (oracleConnection.getExplicitCachingEnabled()) {
                    oracleConnection.purgeExplicitCache();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void setParameterValueInDatabaseCall(Object parameter, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        if (parameter instanceof TIMESTAMP || parameter instanceof TIMESTAMPTZ) {
            statement.setObject(index, parameter);
        } else if (parameter instanceof TIMESTAMPLTZWrapper) {
            Connection conn = this.getConnection(session, statement.getConnection());
            statement.setObject(index, ((TIMESTAMPLTZWrapper)parameter).builtTimestampLtz(conn));
        } else if (parameter instanceof Calendar) {
            Connection conn = this.getConnection(session, statement.getConnection());
            TIMESTAMPTZ tsTZ = TIMESTAMPHelper.buildTIMESTAMPTZ((Calendar)parameter, conn, this.shouldPrintCalendar);
            statement.setObject(index, tsTZ);
        } else if (this.shouldTruncateDate && parameter instanceof Date) {
            statement.setDate(index, Helper.truncateDateIgnoreMilliseconds((Date)((Date)parameter)));
        } else {
            super.setParameterValueInDatabaseCall(parameter, statement, index, session);
        }
    }

    public void setParameterValueInDatabaseCall(Object parameter, CallableStatement statement, String name, AbstractSession session) throws SQLException {
        if (parameter instanceof TIMESTAMP || parameter instanceof TIMESTAMPTZ) {
            statement.setObject(name, parameter);
        } else if (parameter instanceof TIMESTAMPLTZWrapper) {
            Connection conn = this.getConnection(session, statement.getConnection());
            statement.setObject(name, (Object)((TIMESTAMPLTZWrapper)parameter).builtTimestampLtz(conn));
        } else if (parameter instanceof Calendar) {
            Connection conn = this.getConnection(session, statement.getConnection());
            TIMESTAMPTZ tsTZ = TIMESTAMPHelper.buildTIMESTAMPTZ((Calendar)parameter, conn, this.shouldPrintCalendar);
            statement.setObject(name, (Object)tsTZ);
        } else if (this.shouldTruncateDate && parameter instanceof Date) {
            statement.setDate(name, Helper.truncateDateIgnoreMilliseconds((Date)((Date)parameter)));
        } else {
            super.setParameterValueInDatabaseCall(parameter, statement, name, session);
        }
    }

    public Timestamp getTimestampFromServer(AbstractSession session, String sessionName) {
        if (this.getTimestampQuery() != null) {
            this.getTimestampQuery().setSessionName(sessionName);
            Object ob = session.executeQuery((DatabaseQuery)this.getTimestampQuery());
            return ((TIMESTAMPTZWrapper)ob).getTimestamp();
        }
        return super.getTimestampFromServer(session, sessionName);
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSTIMESTAMP FROM DUAL");
            this.timestampQuery.setAllowNativeSQLQuery(Boolean.valueOf(true));
        }
        return this.timestampQuery;
    }

    public String serverTimestampString() {
        return "SYSTIMESTAMP";
    }

    protected List<Class<?>> buildToTIMESTAMPVec() {
        Vector vec = new Vector();
        vec.add(java.util.Date.class);
        vec.add(Timestamp.class);
        vec.add(Calendar.class);
        vec.add(String.class);
        vec.add(Long.class);
        vec.add(java.util.Date.class);
        vec.add(Time.class);
        return vec;
    }

    protected List<Class<?>> buildToNStringCharVec() {
        Vector vec = new Vector();
        vec.add(String.class);
        vec.add(Character.class);
        return vec;
    }

    protected List<Class<?>> buildToNClobVec() {
        Vector vec = new Vector();
        vec.add(String.class);
        vec.add(Character[].class);
        vec.add(char[].class);
        return vec;
    }

    @Override
    public int getLobValueLimits() {
        return this.lobValueLimits;
    }

    @Override
    public void setLobValueLimits(int lobValueLimits) {
        this.lobValueLimits = lobValueLimits;
    }

    protected boolean isOracle9Specific(Class<?> type) {
        return type == NCHAR || type == NSTRING || type == NCLOB || type == XMLTYPE;
    }

    @Override
    protected boolean isClob(Class<?> type) {
        return NCLOB.equals(type) || super.isClob(type);
    }

    @Override
    public Object getCustomModifyValueForCall(Call call, Object value, DatabaseField field, boolean shouldBind) {
        Class type = field.getType();
        if (type != null && this.isOracle9Specific(type)) {
            if (value == null) {
                return null;
            }
            if (NCHAR.equals(type) || NSTRING.equals(type)) {
                return new NTypeBindCallCustomParameter(value);
            }
            if (NCLOB.equals(type)) {
                value = this.convertToDatabaseType(value);
                if (this.shouldUseLocatorForLOBWrite() && this.lobValueExceedsLimit(value)) {
                    ((DatabaseCall)call).addContext(field, value);
                    value = new String(" ");
                }
                return new NTypeBindCallCustomParameter(value);
            }
            if (XMLTYPE.equals(type)) {
                return this.getXMLTypeFactory().createXMLTypeBindCallCustomParameter(value);
            }
        }
        return super.getCustomModifyValueForCall(call, value, field, shouldBind);
    }

    protected List buildFromStringCharVec(Class<?> javaClass) {
        List vec = this.getConversionManager().getDataTypesConvertedFrom(javaClass);
        vec.add(NCHAR);
        vec.add(NSTRING);
        if (javaClass == String.class) {
            vec.add(NCLOB);
        }
        return vec;
    }

    public List<Class<?>> getDataTypesConvertedFrom(Class<?> javaClass) {
        List dataTypes;
        if (this.dataTypesConvertedFromAClass == null) {
            this.dataTypesConvertedFromAClass = new Hashtable(5);
        }
        if ((dataTypes = (List)this.dataTypesConvertedFromAClass.get(javaClass)) != null) {
            return dataTypes;
        }
        dataTypes = super.getDataTypesConvertedFrom(javaClass);
        if (javaClass == String.class || javaClass == Character.class) {
            dataTypes.add(NCHAR);
            dataTypes.add(NSTRING);
            if (javaClass == String.class) {
                dataTypes.add(NCLOB);
            }
        }
        if (javaClass == char[].class || javaClass == Character[].class) {
            dataTypes.add(NCLOB);
        }
        this.dataTypesConvertedFromAClass.put(javaClass, dataTypes);
        return dataTypes;
    }

    public List<Class<?>> getDataTypesConvertedTo(Class<?> javaClass) {
        List<Class<Object>> dataTypes;
        if (this.dataTypesConvertedToAClass == null) {
            this.dataTypesConvertedToAClass = new Hashtable(5);
        }
        if ((dataTypes = (List<Class<Object>>)this.dataTypesConvertedToAClass.get(javaClass)) != null) {
            return dataTypes;
        }
        dataTypes = javaClass == NCHAR || javaClass == NSTRING ? this.buildToNStringCharVec() : (javaClass == NCLOB ? this.buildToNClobVec() : super.getDataTypesConvertedTo(javaClass));
        this.dataTypesConvertedToAClass.put(javaClass, dataTypes);
        return dataTypes;
    }

    public int getJDBCTypeForSetNull(DatabaseField field) {
        int type = this.getJDBCType(field);
        if (type == 2007 || type == 2009) {
            return 12;
        }
        return type;
    }

    public int getJDBCType(Class<?> javaType) {
        if (javaType == XMLTYPE) {
            return 12;
        }
        return super.getJDBCType(javaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeBatch(Statement statement, boolean isStatementPrepared) throws SQLException {
        if (this.usesNativeBatchWriting() && isStatementPrepared) {
            int rowCount = 0;
            try {
                rowCount = ((OraclePreparedStatement)statement).sendBatch();
                this.setExecuteBatchRowCounts(new int[]{rowCount});
            }
            finally {
                ((OraclePreparedStatement)statement).setExecuteBatch(1);
            }
            return rowCount;
        }
        return super.executeBatch(statement, isStatementPrepared);
    }

    public int addBatch(PreparedStatement statement) throws SQLException {
        if (this.usesNativeBatchWriting()) {
            return statement.executeUpdate();
        }
        return super.addBatch(statement);
    }

    public Statement prepareBatchStatement(Statement statement, int maxBatchWritingSize) throws SQLException {
        if (this.usesNativeBatchWriting()) {
            ((OraclePreparedStatement)statement).setExecuteBatch(maxBatchWritingSize);
        }
        return statement;
    }

    protected XMLTypeFactory getXMLTypeFactory() {
        if (this.xmlTypeFactory == null) {
            String className = "org.eclipse.persistence.internal.platform.database.oracle.xdb.XMLTypeFactoryImpl";
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    Class xmlTypeFactoryClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, ((Object)((Object)this)).getClass().getClassLoader()));
                    Constructor xmlTypeFactoryConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(xmlTypeFactoryClass, new Class[0], true));
                    this.xmlTypeFactory = (XMLTypeFactory)AccessController.doPrivileged(new PrivilegedInvokeConstructor(xmlTypeFactoryConstructor, new Object[0]));
                } else {
                    Class xmlTypeFactoryClass = PrivilegedAccessHelper.getClassForName((String)className, (boolean)true, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    Constructor xmlTypeFactoryConstructor = PrivilegedAccessHelper.getConstructorFor((Class)xmlTypeFactoryClass, (Class[])new Class[0], (boolean)true);
                    this.xmlTypeFactory = (XMLTypeFactory)PrivilegedAccessHelper.invokeConstructor((Constructor)xmlTypeFactoryConstructor, (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                throw QueryException.reflectiveCallOnTopLinkClassFailed((String)className, (Exception)e);
            }
        }
        return this.xmlTypeFactory;
    }

    public boolean isXDBDocument(Object obj) {
        return this.getXMLTypeFactory().isXDBDocument(obj);
    }

    public boolean canUnwrapOracleConnection() {
        return true;
    }

    public Connection unwrapOracleConnection(Connection connection) {
        if (connection instanceof OracleConnection) {
            return ((OracleConnection)connection).getPhysicalConnection();
        }
        return super.unwrapOracleConnection(connection);
    }

    public boolean isOracle9() {
        return true;
    }

    public ConnectionCustomizer createConnectionCustomizer(Accessor accessor, AbstractSession session) {
        Object proxyTypeValue = session.getProperty("eclipselink.oracle.proxy-type");
        if (proxyTypeValue == null || proxyTypeValue instanceof String && ((String)proxyTypeValue).isEmpty()) {
            return null;
        }
        return new OracleJDBC_10_1_0_2ProxyConnectionCustomizer(accessor, (Session)session);
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public boolean isTimestampInGmt() {
        return this.isTimestampInGmt;
    }

    public boolean isLtzTimestampInGmt() {
        return this.isLtzTimestampInGmt;
    }

    public boolean shouldTruncateDate() {
        return this.shouldTruncateDate;
    }

    public void setShouldTruncateDate(boolean shouldTruncateDate) {
        this.shouldTruncateDate = shouldTruncateDate;
    }

    public boolean supportsConnectionUserName() {
        return true;
    }

    public String getConnectionUserName() {
        return this.connectionUserName;
    }

    protected static class NTypeBindCallCustomParameter
    extends BindCallCustomParameter {
        public NTypeBindCallCustomParameter(Object obj) {
            super(obj);
        }

        public boolean shouldUseUnwrappedConnection() {
            return true;
        }

        public void set(DatabasePlatform platform, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
            ((OraclePreparedStatement)statement).setFormOfUse(index, (short)2);
            super.set(platform, statement, index, session);
        }
    }
}

