/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class IntegrityChecker
implements Serializable {
    protected List<Exception> caughtExceptions = null;
    protected List<String> tables = null;
    protected boolean shouldCatchExceptions = true;
    protected boolean shouldCheckDatabase = false;
    protected boolean shouldCheckInstantiationPolicy = true;

    public void catchExceptions() {
        this.setShouldCatchExceptions(true);
    }

    public void checkDatabase() {
        this.setShouldCheckDatabase(true);
    }

    public void checkInstantiationPolicy() {
        this.setShouldCheckInstantiationPolicy(true);
    }

    public boolean checkTable(DatabaseTable table, AbstractSession session) {
        boolean tableExists;
        if (this.getTables().isEmpty()) {
            this.initializeTables(session);
        }
        if (!(tableExists = this.getTables().contains(table.getName())) && session.getPlatform().isMySQL()) {
            return this.getTables().contains(table.getName().toLowerCase());
        }
        return tableExists;
    }

    public void dontCatchExceptions() {
        this.setShouldCatchExceptions(false);
    }

    public void dontCheckDatabase() {
        this.setShouldCheckDatabase(false);
    }

    public void dontCheckInstantiationPolicy() {
        this.setShouldCheckInstantiationPolicy(false);
    }

    public List<Exception> getCaughtExceptions() {
        if (this.caughtExceptions == null) {
            this.caughtExceptions = new ArrayList<Exception>();
        }
        return this.caughtExceptions;
    }

    public List<String> getTables() {
        if (this.tables == null) {
            this.tables = new ArrayList<String>();
        }
        return this.tables;
    }

    public void handleError(RuntimeException runtimeException) {
        if (!this.shouldCatchExceptions()) {
            throw runtimeException;
        }
        this.getCaughtExceptions().add(runtimeException);
    }

    public boolean hasErrors() {
        return this.caughtExceptions != null && !this.caughtExceptions.isEmpty();
    }

    public boolean hasRuntimeExceptions() {
        if (this.hasErrors()) {
            Iterator<Exception> iterator = this.getCaughtExceptions().iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof RuntimeException)) continue;
                return true;
            }
        }
        return false;
    }

    public void initializeTables(AbstractSession session) {
        Vector<AbstractRecord> result = session.getAccessor().getTableInfo(null, null, session);
        for (AbstractRecord row : result) {
            if (session.getPlatform().shouldForceFieldNamesToUpperCase()) {
                this.tables.add(((String)row.get("TABLE_NAME")).toUpperCase());
                continue;
            }
            this.tables.add((String)row.get("TABLE_NAME"));
        }
    }

    public void setCaughtExceptions(List<Exception> exceptions) {
        this.caughtExceptions = exceptions;
    }

    public void setShouldCatchExceptions(boolean answer) {
        this.shouldCatchExceptions = answer;
    }

    public void setShouldCheckDatabase(boolean answer) {
        this.shouldCheckDatabase = answer;
    }

    public void setShouldCheckInstantiationPolicy(boolean answer) {
        this.shouldCheckInstantiationPolicy = answer;
    }

    public boolean shouldCatchExceptions() {
        return this.shouldCatchExceptions;
    }

    public boolean shouldCheckDatabase() {
        return this.shouldCheckDatabase;
    }

    public boolean shouldCheckInstantiationPolicy() {
        return this.shouldCheckInstantiationPolicy;
    }
}

