/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.bootstrap;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Which {
    public static File jarFile(final Class clazz) throws IOException {
        final String resourceName = clazz.getName().replace(".", "/") + ".class";
        URL resource = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return clazz.getClassLoader().getResource(resourceName);
            }
        });
        if (resource == null) {
            throw new IllegalArgumentException("Cannot get bootstrap path from " + clazz + " class location, aborting");
        }
        if (resource.getProtocol().equals("jar")) {
            try {
                JarURLConnection c = (JarURLConnection)resource.openConnection();
                URL jarFile = c.getJarFileURL();
                try {
                    return new File(jarFile.toURI());
                }
                catch (URISyntaxException e) {
                    return new File(jarFile.getPath());
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot open jar file " + resource, e);
            }
        }
        throw new IllegalArgumentException("Don't support packaging " + resource + " , please contribute !");
    }
}

