/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import jakarta.inject.Inject;
import java.lang.reflect.Constructor;
import org.glassfish.deployment.common.DeploymentException;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class BeanGeneratorBase {
    BeanGeneratorBase() {
    }

    protected static void generateConstructor(ClassVisitor cv, Class<?> superClass, boolean withNoArguments) {
        Constructor<?> parentCtor = BeanGeneratorBase.findParentConstructor(superClass);
        String parentCtorDesc = Type.getConstructorDescriptor(parentCtor);
        String ctorDesc = withNoArguments ? "()V" : parentCtorDesc;
        String superClassInternalName = Type.getInternalName(superClass);
        MethodVisitor mv = cv.visitMethod(1, "<init>", ctorDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        int argCount = parentCtor.getParameterCount();
        for (int i = 0; i < argCount; ++i) {
            if (withNoArguments) {
                mv.visitInsn(1);
                continue;
            }
            mv.visitVarInsn(25, i + 1);
        }
        mv.visitMethodInsn(183, superClassInternalName, "<init>", parentCtorDesc, false);
        mv.visitInsn(177);
        mv.visitMaxs(argCount + 1, withNoArguments ? 1 : argCount + 1);
        mv.visitEnd();
    }

    private static Constructor<?> findParentConstructor(Class<?> superClass) {
        Constructor<?>[] ctors = superClass.getConstructors();
        Constructor<?> parentCtor = null;
        for (Constructor<?> ctor : ctors) {
            if (ctor.getParameterCount() == 0) {
                parentCtor = ctor;
                break;
            }
            if (!ctor.isAnnotationPresent(Inject.class)) continue;
            parentCtor = ctor;
        }
        if (parentCtor == null) {
            throw new DeploymentException("A class " + superClass.getName() + " doesn't have any appropriate constructor");
        }
        return parentCtor;
    }
}

