/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.http.io.NIOOutputStream;
import org.glassfish.grizzly.http.io.OutputBuffer;

class NIOOutputStreamImpl
extends NIOOutputStream
implements Cacheable {
    private volatile OutputBuffer outputBuffer;

    NIOOutputStreamImpl() {
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.writeByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.initialized()) {
            return;
        }
        this.outputBuffer.close();
    }

    @Override
    @Deprecated
    public boolean canWrite(int length) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.outputBuffer.canWrite();
    }

    @Override
    public boolean canWrite() {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.outputBuffer.canWrite();
    }

    @Override
    @Deprecated
    public void notifyCanWrite(WriteHandler handler, int length) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        this.outputBuffer.notifyCanWrite(handler);
    }

    @Override
    public void notifyCanWrite(WriteHandler handler) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        this.outputBuffer.notifyCanWrite(handler);
    }

    @Override
    public void write(Buffer buffer) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.outputBuffer.writeBuffer(buffer);
    }

    @Override
    public void recycle() {
        this.outputBuffer = null;
    }

    public void setOutputBuffer(OutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    private boolean initialized() {
        return this.outputBuffer != null;
    }
}

