/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.shoal.ha.cache.store.backing.ReplicatedBackingStoreFactory;

public class DataStoreShell {
    BackingStore<String, Serializable> ds;
    int counter = 0;
    private final Logger csc_log = Logger.getLogger("org.glassfish.shoal.ha.cache.command.save");
    private final Logger clrc_log = Logger.getLogger("org.glassfish.shoal.ha.cache.command.load_request");
    private final Logger clresp_log = Logger.getLogger("org.glassfish.shoal.ha.cache.command.load_response");

    public static void main(String[] args) throws Exception {
        BackingStoreConfiguration conf = new BackingStoreConfiguration();
        conf.setStoreName(args[0]).setInstanceName(args[1]).setClusterName(args[2]).setKeyClazz(String.class).setValueClazz(Serializable.class);
        Map map = conf.getVendorSpecificSettings();
        map.put("start.gms", true);
        map.put("max.idle.timeout.in.seconds", 90L);
        map.put("class.loader", ClassLoader.getSystemClassLoader());
        BackingStore ds = new ReplicatedBackingStoreFactory().createBackingStore(conf);
        DataStoreShell main = new DataStoreShell();
        main.runShell(ds);
    }

    private void runShell(BackingStore<String, Serializable> ds) {
        this.csc_log.setLevel(Level.ALL);
        this.clrc_log.setLevel(Level.ALL);
        this.clresp_log.setLevel(Level.ALL);
        this.ds = ds;
        String line = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        do {
            this.prompt();
            try {
                line = br.readLine();
                ArrayList<String> args = new ArrayList<String>();
                StringTokenizer tok = new StringTokenizer(line, "\n\r\t\f \f");
                while (tok.hasMoreTokens()) {
                    String str = tok.nextToken();
                    args.add(str);
                }
                if (args.size() <= 0) continue;
                String command = (String)args.remove(0);
                String[] params = args.toArray(new String[0]);
                this.execute(command, params);
                ++this.counter;
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
            catch (BackingStoreException bsEx) {
                bsEx.printStackTrace();
            }
        } while (!"quit".equalsIgnoreCase(line));
    }

    private void prompt() {
        System.out.print(this.counter + ">");
        System.out.flush();
    }

    private void execute(String command, String[] params) throws BackingStoreException {
        if ("put".equalsIgnoreCase(command)) {
            String hint = this.ds.save((Serializable)((Object)params[0]), (Serializable)((Object)params[1]), true);
            System.out.println("Saved; hint: " + hint);
        } else if ("get".equalsIgnoreCase(command)) {
            String hint = params.length > 1 ? params[1] : null;
            System.out.println("get(" + params[0] + ") => " + String.valueOf(this.ds.load((Serializable)((Object)params[0]), hint)));
        } else if ("remove".equalsIgnoreCase(command)) {
            this.ds.remove((Serializable)((Object)params[0]));
        } else if ("size".equalsIgnoreCase(command)) {
            int size = this.ds.size();
            System.out.println("Size: " + size);
        } else if ("expireIdle".equalsIgnoreCase(command)) {
            int count = this.ds.removeExpired(15L);
            System.out.println("** Idle Entries Removed: " + count);
        }
    }
}

