/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class LiteralNode
extends Node
implements AliasableNode {
    public Object literal;

    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.addAttribute("CONSTANT", this.generateExpression(context));
        }
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        ConstantExpression whereClause = new ConstantExpression(this.getLiteral(), context.getBaseExpression());
        return whereClause;
    }

    @Override
    public String getAsString() {
        return this.getLiteral().toString();
    }

    public Object getLiteral() {
        return this.literal;
    }

    @Override
    public boolean isLiteralNode() {
        return true;
    }

    public void setLiteral(Object newLiteral) {
        this.literal = newLiteral;
    }

    @Override
    public String toString(int indent) {
        StringBuilder buffer = new StringBuilder();
        this.toStringIndent(indent, buffer);
        buffer.append(this.toStringDisplayName() + "[" + String.valueOf(this.getLiteral()) + "]");
        return buffer.toString();
    }

    @Override
    public boolean isAliasableNode() {
        return true;
    }
}

