/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.vti;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.derby.vti.StringColumnVTI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlVTI
extends StringColumnVTI {
    private String _rowTag;
    private InputStream _xmlResource;
    private int _rowIdx = -1;
    private int _rowCount = -1;
    private String[] _currentRow;
    private DocumentBuilder _builder;
    private NodeList _rawRows;
    private int _firstChildTagIdx;

    public XmlVTI(InputStream inputStream, String string, int n, String ... stringArray) {
        super(stringArray);
        this._xmlResource = inputStream;
        this._rowTag = string;
        this._firstChildTagIdx = n;
    }

    public static XmlVTI xmlVTI(String string, String string2, String ... stringArray) throws Exception {
        return XmlVTI.xmlVTI(string, string2, null, XmlVTI.asList(stringArray));
    }

    public static XmlVTI xmlVTIFromURL(String string, String string2, String ... stringArray) throws Exception {
        return XmlVTI.xmlVTIFromURL(string, string2, null, XmlVTI.asList(stringArray));
    }

    public static XmlVTI xmlVTI(String string, String string2, ArrayList<String> arrayList, ArrayList<String> arrayList2) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(new File(string));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        return XmlVTI.xmlVTI(fileInputStream, string2, arrayList, arrayList2);
    }

    public static XmlVTI xmlVTIFromURL(String string, String string2, ArrayList<String> arrayList, ArrayList<String> arrayList2) throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = new URI(string).toURL().openStream();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        return XmlVTI.xmlVTI(inputStream, string2, arrayList, arrayList2);
    }

    private static XmlVTI xmlVTI(InputStream inputStream, String string, ArrayList<String> arrayList, ArrayList<String> arrayList2) throws Exception {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
        }
        String[] stringArray = new String[arrayList.size() + arrayList2.size()];
        int n = 0;
        for (String string2 : arrayList) {
            stringArray[n++] = string2;
        }
        for (String string2 : arrayList2) {
            stringArray[n++] = string2;
        }
        return new XmlVTI(inputStream, string, arrayList.size(), stringArray);
    }

    public static ArrayList<String> asList(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    protected String getRawColumn(int n) throws SQLException {
        try {
            return this._currentRow[n - 1];
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage());
        }
    }

    @Override
    public void close() throws SQLException {
        this._builder = null;
        this._rawRows = null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("Not implemented.");
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (this._rowIdx < 0) {
                this.readRows();
            }
            if (++this._rowIdx < this._rowCount) {
                this.parseRow(this._rowIdx);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.getMessage(), throwable);
        }
    }

    private void readRows() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        this._builder = documentBuilderFactory.newDocumentBuilder();
        this._builder.setErrorHandler(new XMLErrorHandler());
        Document document = this._builder.parse(this._xmlResource);
        Element element = document.getDocumentElement();
        this._rawRows = element.getElementsByTagName(this._rowTag);
        this._rowCount = this._rawRows.getLength();
        this._xmlResource.close();
    }

    private void parseRow(int n) throws Exception {
        Element element = (Element)this._rawRows.item(n);
        int n2 = this.getColumnCount();
        this._currentRow = new String[n2];
        for (int i = 0; i < n2; ++i) {
            this._currentRow[i] = this.findColumnValue(element, i);
        }
    }

    private String findColumnValue(Element element, int n) throws Exception {
        NodeList nodeList;
        String string;
        Object object;
        boolean bl;
        boolean bl2 = bl = n < this._firstChildTagIdx;
        if (bl) {
            object = element.getParentNode();
            if (object == null || !(object instanceof Element)) {
                return null;
            }
            element = (Element)object;
        }
        if ("".equals(string = element.getAttribute((String)(object = this.getColumnName(n + 1))))) {
            string = null;
        }
        if (string == null && (nodeList = element.getElementsByTagName((String)object)) != null && nodeList.getLength() > 0) {
            int n2 = nodeList.getLength();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n2; ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (i != 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.squeezeText(element2));
            }
            string = stringBuilder.toString();
        }
        if (bl && string == null) {
            return this.findColumnValue(element, n);
        }
        return string;
    }

    private String squeezeText(Element element) throws Exception {
        String string = null;
        Node node = element.getFirstChild();
        if (node != null) {
            string = node.getNodeValue();
        }
        return string;
    }

    private class XMLErrorHandler
    implements ErrorHandler {
        private XMLErrorHandler() {
        }

        private void closeInput() {
            try {
                if (XmlVTI.this._xmlResource != null) {
                    XmlVTI.this._xmlResource.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.closeInput();
            throw new SAXException(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.closeInput();
            throw new SAXException(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.closeInput();
            throw new SAXException(sAXParseException);
        }
    }
}

