/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.remote.HttpCommand;
import com.sun.enterprise.admin.remote.reader.ProprietaryReaderFactory;
import com.sun.enterprise.admin.util.CachedCommandModel;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.admin.util.cache.AdminCacheUtils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Properties;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.InvalidCommandException;

public class CommandModelHttpCommand
implements HttpCommand<CachedCommandModel> {
    private static final String MEDIATYPE_JSON = "application/json";
    private static final System.Logger LOG = System.getLogger(CommandModelHttpCommand.class.getName());
    private final String commandName;
    private final String commandCacheKey;
    private final boolean detached;
    private final boolean notify;

    public CommandModelHttpCommand(String commandName, String commandCacheKey, boolean detached, boolean notify) {
        this.commandName = commandName;
        this.commandCacheKey = commandCacheKey;
        this.detached = detached;
        this.notify = notify;
    }

    @Override
    public void prepareConnection(HttpURLConnection urlConnection) throws IOException {
        urlConnection.setRequestProperty("Accept", MEDIATYPE_JSON);
    }

    @Override
    public CachedCommandModel useConnection(HttpURLConnection urlConnection) throws CommandException, IOException {
        String json;
        CachedCommandModel commandModel;
        long startNanos = System.nanoTime();
        String eTag = urlConnection.getHeaderField("ETag");
        if (eTag != null) {
            if ((eTag = eTag.trim()).startsWith("W/")) {
                eTag = eTag.substring(2).trim();
            }
            if (eTag.startsWith("\"")) {
                eTag = eTag.substring(1);
            }
            if (eTag.endsWith("\"")) {
                eTag = eTag.substring(0, eTag.length() - 1);
            }
        }
        if ((commandModel = CommandModelHttpCommand.parseMetadata(json = ProprietaryReaderFactory.getReader(String.class, urlConnection.getContentType()).readFrom(urlConnection.getInputStream(), urlConnection.getContentType()), eTag, this.detached, this.notify)) == null) {
            throw new InvalidCommandException("Command model could not be parsed from JSON metadata received from server.");
        }
        LOG.log(System.Logger.Level.DEBUG, "Command model for {0} command fetched from remote server. Duration: {1} nanos", this.commandName, System.nanoTime() - startNanos);
        try {
            StringBuilder forCache = new StringBuilder(json.length() + 40);
            forCache.append("ETag: ").append(eTag);
            forCache.append("\n");
            forCache.append(json);
            AdminCacheUtils.getCache().put(this.commandCacheKey, forCache.toString());
        }
        catch (Exception ex) {
            LOG.log(System.Logger.Level.WARNING, "NCLS-ADMIN-00013", this.commandCacheKey);
        }
        return commandModel;
    }

    static CommandModel fromCache(String key, boolean detached, boolean notify) {
        int ind;
        String cachedModel = CommandModelHttpCommand.getCachedModel(key);
        int n = ind = cachedModel == null ? -1 : cachedModel.indexOf(10);
        if (ind < 0) {
            return null;
        }
        String eTag = CommandModelHttpCommand.toEtag(cachedModel, ind);
        LOG.log(System.Logger.Level.DEBUG, () -> "Cached command model ETag is " + eTag);
        String content = cachedModel.substring(ind + 1).trim();
        return CommandModelHttpCommand.parseMetadata(content, eTag, detached, notify);
    }

    private static String getCachedModel(String key) {
        String cachedModel = AdminCacheUtils.getCache().get(key, String.class);
        if (cachedModel == null) {
            return null;
        }
        return cachedModel.trim();
    }

    private static String toEtag(String cachedModel, int ind) {
        String eTag = cachedModel.substring(0, ind);
        if (!eTag.startsWith("ETag:")) {
            return null;
        }
        return eTag.substring(5).trim();
    }

    private static CachedCommandModel parseMetadata(String str, String etag, boolean detached, boolean notify) {
        if (LOG.isLoggable(System.Logger.Level.TRACE)) {
            LOG.log(System.Logger.Level.TRACE, "------- RAW METADATA RESPONSE ---------");
            LOG.log(System.Logger.Level.TRACE, "ETag: {0}", etag);
            LOG.log(System.Logger.Level.TRACE, str);
            LOG.log(System.Logger.Level.TRACE, "------- RAW METADATA RESPONSE ---------");
        }
        if (str == null) {
            return null;
        }
        try {
            boolean sawFile = false;
            JSONObject obj = new JSONObject(str);
            obj = obj.getJSONObject("command");
            CachedCommandModel cm = new CachedCommandModel(obj.getString("@name"), etag);
            cm.dashOk = obj.optBoolean("@unknown-options-are-operands", false);
            cm.managedJob = obj.optBoolean("@managed-job", false);
            cm.setUsage(obj.optString("usage", null));
            Object optns = obj.opt("option");
            if (!JSONObject.NULL.equals(optns)) {
                JSONArray jsonOptions;
                if (optns instanceof JSONArray) {
                    jsonOptions = (JSONArray)optns;
                } else {
                    jsonOptions = new JSONArray();
                    jsonOptions.put(optns);
                }
                for (int i = 0; i < jsonOptions.length(); ++i) {
                    JSONObject jsOpt = jsonOptions.getJSONObject(i);
                    String type = jsOpt.getString("@type");
                    CommandModelData.ParamModelData opt = new CommandModelData.ParamModelData(jsOpt.getString("@name"), CommandModelHttpCommand.typeOf(type), jsOpt.optBoolean("@optional", false), jsOpt.optString("@default"), jsOpt.optString("@short"), jsOpt.optBoolean("@obsolete", false), jsOpt.optString("@alias"));
                    opt.param._acceptableValues = jsOpt.optString("@acceptable-values");
                    if ("PASSWORD".equals(type)) {
                        opt.param._password = true;
                        opt.prompt = jsOpt.optString("@prompt");
                        opt.promptAgain = jsOpt.optString("@prompt-again");
                    } else if ("FILE".equals(type)) {
                        sawFile = true;
                    }
                    if (jsOpt.optBoolean("@primary", false)) {
                        opt.param._primary = true;
                    }
                    if (jsOpt.optBoolean("@multiple", false)) {
                        opt.type = opt.type == File.class ? File[].class : List.class;
                        opt.param._multiple = true;
                    }
                    cm.add(opt);
                }
            }
            if (sawFile) {
                cm.add(new CommandModelData.ParamModelData("upload", Boolean.class, true, null));
                cm.setAddedUploadOption(true);
            }
            if (notify) {
                cm.add(new CommandModelData.ParamModelData("notify", Boolean.class, false, "false"));
            }
            if (detached) {
                cm.add(new CommandModelData.ParamModelData("detach", Boolean.class, false, "false"));
            }
            return cm;
        }
        catch (JSONException e) {
            LOG.log(System.Logger.Level.DEBUG, "Can not parse command metadata", (Throwable)e);
            return null;
        }
    }

    private static Class<?> typeOf(String type) {
        if (type.equals("STRING")) {
            return String.class;
        }
        if (type.equals("BOOLEAN")) {
            return Boolean.class;
        }
        if (type.equals("FILE")) {
            return File.class;
        }
        if (type.equals("PASSWORD")) {
            return String.class;
        }
        if (type.equals("PROPERTIES")) {
            return Properties.class;
        }
        return String.class;
    }
}

