/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.entity;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.entity.Coffee;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static Coffee[] cRef = new Coffee[5];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.logTrace("Create Test data");
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationEntityTest1() throws Exception {
        this.logTrace("Begin annotationEntityTest1");
        boolean pass = true;
        List c = null;
        try {
            this.getEntityTransaction().begin();
            Object[] expectedBrands = new String[]{"vanilla creme", "mocha", "hazelnut", "decaf", "breakfast blend"};
            this.logTrace("find coffees by brand name");
            c = this.getEntityManager().createQuery("Select c.brandName from cof c ORDER BY c.brandName DESC").setMaxResults(10).getResultList();
            Object[] result = c.toArray(new String[c.size()]);
            this.logTrace("Compare results of Coffee Brand Names");
            pass = Arrays.equals(expectedBrands, result);
            if (!pass) {
                this.logErr("Did not get expected results.  Expected 5 Coffees : vanilla creme, mocha, hazelnut, decaf, breakfast blend.  Received: " + c.size());
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    this.logTrace(" Coffee Brand Name: " + String.valueOf(it.next()));
                }
            } else {
                this.logTrace("Expected results received");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("annotationEntityTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationEntityTest2() throws Exception {
        this.logTrace("Begin annotationEntityTest2");
        boolean pass1 = true;
        boolean pass2 = false;
        List c = null;
        try {
            this.getEntityTransaction().begin();
            Integer[] expectedPKs = new Integer[]{21, 22, 23, 24, 25};
            this.logTrace("find all coffees");
            c = this.getEntityManager().createQuery("Select c from cof c").setMaxResults(10).getResultList();
            if (c.size() != 5) {
                this.logErr("Did not get expected results.  Expected 5 references, got: " + c.size());
                pass1 = false;
            } else if (pass1) {
                this.logTrace("Expected size received, verify contents . . . ");
                Iterator i = c.iterator();
                int foundCof = 0;
                block11: while (i.hasNext()) {
                    this.logTrace("Check List for expected coffees");
                    Coffee o = (Coffee)i.next();
                    for (int l = 0; l < 5; ++l) {
                        if (!expectedPKs[l].equals(o.getId())) continue;
                        this.logTrace("Found coffee with PK: " + o.getId());
                        ++foundCof;
                        continue block11;
                    }
                }
                if (foundCof != 5) {
                    this.logErr("anotationEntityTest2: Did not get expected results");
                    pass2 = false;
                } else {
                    this.logTrace("Expected results received");
                    pass2 = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass2 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("annotationEntityTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            this.logTrace("createTestData");
            this.getEntityTransaction().begin();
            this.logTrace("Create 5 Coffees");
            Client.cRef[0] = new Coffee(21, "hazelnut", 1.0f);
            Client.cRef[1] = new Coffee(22, "vanilla creme", 2.0f);
            Client.cRef[2] = new Coffee(23, "decaf", 3.0f);
            Client.cRef[3] = new Coffee(24, "breakfast blend", 4.0f);
            Client.cRef[4] = new Coffee(25, "mocha", 5.0f);
            this.logTrace("Start to persist coffees ");
            for (Coffee coffee : cRef) {
                this.getEntityManager().persist((Object)coffee);
                this.logTrace("persisted coffee " + String.valueOf(coffee));
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

