/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.strquery;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Alias;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Arrays;
import java.util.List;

public class Client5
extends Util {
    public static void main(String[] args) {
        Client5 theTests = new Client5();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest3() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers with Alias: imc");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join alias = customer.join("aliases");
            cquery.where((Expression)cbuilder.equal((Expression)alias.get("alias"), (Expression)cbuilder.parameter(String.class, "aName"))).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("aName", (Object)"imc");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"8"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest3 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest20() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers who do not have aliases");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isEmpty((Expression)customer.get("aliases")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"6", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 7 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest20 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest21() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers who have aliases");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotEmpty((Expression)customer.get("aliases")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 15 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest21 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest24() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all aliases who have match: stevie");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.equal((Expression)alias.get("alias"), cbuilder.concat(cbuilder.literal((Object)"ste"), "vie")));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"14"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + alist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest24 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest25() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all aliases containing the substring: iris");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.equal((Expression)alias.get("alias"), cbuilder.substring((Expression)cbuilder.parameter(String.class, "string1"), (Expression)cbuilder.parameter(Integer.class, "int2"), (Expression)cbuilder.parameter(Integer.class, "int3"))));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("string1", (Object)"iris");
            tquery.setParameter("int2", (Object)1);
            tquery.setParameter("int3", (Object)4);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"20"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + alist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest25 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest26() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find aliases whose alias name is greater than 4 characters");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.gt(cbuilder.length((Expression)alias.get("alias")), (Number)4));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"8", "10", "13", "14", "18", "28", "29"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 7 references, got: " + alist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest26 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest28() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all aliases who contain the string: ev in their alias name");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.equal(cbuilder.locate((Expression)alias.get("alias"), "ev"), (Object)3));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13", "14", "18"};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 3 references, got: " + alist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest28 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest29() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find aliases who are members of customersNoop");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.isMember((Expression)alias.get("customerNoop"), (Expression)alias.get("customersNoop")));
            cquery.select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(alist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + alist.size());
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest29 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest30() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find aliases who are NOT members of collection");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.isNotMember((Expression)alias.get("customerNoop"), (Expression)alias.get("customersNoop")));
            cquery.select((Selection)alias);
            cquery.distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List alist = tquery.getResultList();
            String[] expectedPKs = new String[this.aliasRef.length];
            for (int i = 0; i < this.aliasRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(alist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected " + this.aliasRef.length + " references, got: " + alist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest30 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest31() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers with an alias LIKE: sh_ll");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.like((Expression)a.get("alias"), "sh\\_ll", '\\'));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
                this.logTrace("Expected results received");
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest31 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest45() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find customers whose id is greater than 1 OR where the relationship is NOT EMPTY");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.isNotEmpty((Expression)customer.get("aliasesNoop")), (Expression)cbuilder.notEqual((Expression)customer.get("id"), (Object)"1")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 19 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest45 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest49() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers who have a null relationship");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.isNull((Expression)a.get("customerNoop")));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 13 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest49 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest50() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers with an alias that contains an underscore");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.like((Expression)a.get("alias"), "%\\_%", '\\'));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest50 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest51() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers who do not have null relationship");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.isNotNull((Expression)a.get("customerNoop")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (clist.size() != 0) {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest51 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest53() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("determine if customer has a NULL relationship");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)customer.get("name"), (Expression)cbuilder.parameter(String.class, "cName")), (Expression)cbuilder.isNull((Expression)a.get("customerNoop"))));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("cName", (Object)"Arthur D. Frechette");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 13 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest53 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void queryTest54() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("determine if customers have a NULL relationship");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.isNotNull((Expression)a.get("customerNoop")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (clist.size() != 0) {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest54 failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_leftouterjoin_MxM() throws Exception {
        boolean pass1 = false;
        boolean pass2 = true;
        Object[][] expectedResultSet = new Object[][]{{"7", "sjc"}, {"5", "ssd"}, {"7", "stevec"}, {"5", "steved"}, {"5", "stevie"}, {"7", "stevie"}};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases", JoinType.LEFT);
            cquery.where((Expression)cbuilder.like((Expression)customer.get("name"), "Ste%"));
            cquery.multiselect(new Selection[]{customer.get("id"), a.get("alias")}).orderBy(new Order[]{cbuilder.asc((Expression)a.get("alias")), cbuilder.asc((Expression)customer.get("id"))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List q = tquery.getResultList();
            if (q.size() != 6) {
                this.logTrace("test_leftouterjoin_MxM:  Did not get expected results. Expected 6,  got: " + q.size());
            } else {
                pass1 = true;
                this.logTrace("Expected size received, verify contents . . . ");
                for (int i = 0; i < q.size(); ++i) {
                    Object obj = q.get(i);
                    Object[] customerAndAliasExpected = expectedResultSet[i];
                    Tuple customerAndAliasTuple = null;
                    Object[] customerAndAlias = null;
                    if (obj instanceof Tuple) {
                        this.logTrace("The element in the result list is of type Object[], continue . . .");
                        customerAndAliasTuple = (Tuple)obj;
                        customerAndAlias = customerAndAliasTuple.toArray();
                        if (Arrays.equals(customerAndAliasExpected, customerAndAlias)) continue;
                        this.logErr("Expecting element value: " + String.valueOf(Arrays.asList(customerAndAliasExpected)) + ", actual element value: " + String.valueOf(Arrays.asList(customerAndAlias)));
                        pass2 = false;
                        break;
                    }
                    this.logErr("The element in the result list is not of type Object[]:" + String.valueOf(obj));
                    break;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("test_leftouterjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_upperStringExpression() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.equal(cbuilder.upper((Expression)a.get("alias")), (Object)"SJC"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_upperStringExpression failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_lowerStringExpression() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.equal(cbuilder.lower((Expression)a.get("alias")), (Object)"sjc")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_lowerStringExpression failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_innerjoin_MxM() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.where((Expression)cbuilder.equal((Expression)a.get("alias"), (Expression)cbuilder.parameter(String.class, "aName")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("aName", (Object)"fish");
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_fetchjoin_MxM() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FETCHJOIN-MXM Executing Query");
            CriteriaQuery cquery = cbuilder.createQuery(Alias.class);
            Root alias = cquery.from(Alias.class);
            cquery.where((Expression)cbuilder.like((Expression)alias.get("alias"), "a%")).select((Selection)alias);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "5", "6"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 4 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_MxM failed");
        }
    }

    @SetupMethod(name="setupAliasData")
    public void test_substringHavingClause() throws Exception {
        boolean pass = false;
        Long expectedCount = 2L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Executing Query");
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("aliases");
            cquery.select((Selection)cbuilder.count((Expression)customer)).groupBy(new Expression[]{a.get("alias")}).having((Expression)cbuilder.equal((Expression)a.get("alias"), cbuilder.substring((Expression)cbuilder.parameter(String.class, "string1"), (Expression)cbuilder.parameter(Integer.class, "int1"), (Expression)cbuilder.parameter(Integer.class, "int2"))));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("string1", (Object)"fish");
            tquery.setParameter("int1", (Object)1);
            tquery.setParameter("int2", (Object)4);
            Long result = (Long)tquery.getSingleResult();
            this.logTrace("Check results received .  .  .");
            if (expectedCount.equals(result)) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results. Expected Count of 2, got: " + String.valueOf(result));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_substringHavingClause failed");
        }
    }
}

