/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.prepStmt.prepStmt7;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class prepStmtClient7
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.prepStmt.prepStmt7";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private csSchema csSch = null;
    private String drManager = null;
    private transient DatabaseMetaData dbmd = null;
    private Properties sqlp = null;
    private Properties props = null;
    private PreparedStatement pstmt = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        prepStmtClient7 theTests = new prepStmtClient7();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.props = p;
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception: " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject63() throws Exception {
        Integer minTinyintVal = null;
        BigDecimal minBigDecimalVal = null;
        Object rTinyintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Tinyint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Tinyint to be Updated ");
            sminStringVal = this.rsSch.extractVal("Tinyint_Tab", 2, this.sqlp, this.conn);
            minBigDecimalVal = new BigDecimal(sminStringVal);
            minTinyintVal = new Integer(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minBigDecimalVal, -6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Tinyint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orTinyintVal = this.rs.getObject(1);
            String srTinyintVal = new String(orTinyintVal.toString());
            this.msg.addOutputMsg(sminStringVal, srTinyintVal);
            if (srTinyintVal.trim().equals(sminStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject64() throws Exception {
        Integer maxSmallintVal = null;
        BigDecimal maxBigDecimalVal = null;
        Object rSmallintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Smallint_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Smallint to be Updated ");
            smaxStringVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            maxBigDecimalVal = new BigDecimal(smaxStringVal);
            maxSmallintVal = new Integer(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxBigDecimalVal, 5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Smallint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orSmallintVal = this.rs.getObject(1);
            String srSmallintVal = new String(orSmallintVal.toString());
            this.msg.addOutputMsg(smaxStringVal, srSmallintVal);
            if (srSmallintVal.trim().equals(smaxStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject65() throws Exception {
        Integer minSmallintVal = null;
        BigDecimal minBigDecimalVal = null;
        Object rSmallintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Smallint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Smallint to be Updated ");
            sminStringVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            minBigDecimalVal = new BigDecimal(sminStringVal);
            minSmallintVal = new Integer(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minBigDecimalVal, 5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orSmallintVal = this.rs.getObject(1);
            String srSmallintVal = new String(orSmallintVal.toString());
            this.msg.addOutputMsg(sminStringVal, srSmallintVal);
            if (srSmallintVal.trim().equals(sminStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject66() throws Exception {
        Integer maxIntegerVal = null;
        BigDecimal maxBigDecimalVal = null;
        Object rIntegerVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Integer_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Integer to be Updated");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxBigDecimalVal = new BigDecimal(smaxStringVal);
            maxIntegerVal = new Integer(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxBigDecimalVal, 4);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Integer_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orIntegerVal = this.rs.getObject(1);
            String srIntegerVal = new String(orIntegerVal.toString());
            this.msg.addOutputMsg(smaxStringVal, srIntegerVal);
            if (srIntegerVal.trim().equals(smaxStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject67() throws Exception {
        Integer minIntegerVal = null;
        BigDecimal minBigDecimalVal = null;
        Object rIntegerVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Integer_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Integer to be Updated");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minBigDecimalVal = new BigDecimal(sminStringVal);
            minIntegerVal = new Integer(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minBigDecimalVal, 4);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Integer_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orIntegerVal = this.rs.getObject(1);
            String srIntegerVal = new String(orIntegerVal.toString());
            this.msg.addOutputMsg(sminStringVal, srIntegerVal);
            if (srIntegerVal.trim().equals(sminStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject68() throws Exception {
        Long maxBigintVal = null;
        BigDecimal maxBigDecimalVal = null;
        Object rBigintVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bigint_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Bigint to be Updated");
            smaxStringVal = this.rsSch.extractVal("Bigint_Tab", 1, this.sqlp, this.conn);
            maxBigDecimalVal = new BigDecimal(smaxStringVal);
            maxBigintVal = new Long(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxBigDecimalVal, -5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Bigint_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orBigintVal = this.rs.getObject(1);
            String srBigintVal = new String(orBigintVal.toString());
            this.msg.addOutputMsg(smaxStringVal, srBigintVal);
            if (srBigintVal.trim().equals(smaxStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject69() throws Exception {
        Long minBigintVal = null;
        BigDecimal minBigDecimalVal = null;
        Object rBigintVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bigint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Bigint to be Updated ");
            sminStringVal = this.rsSch.extractVal("Bigint_Tab", 2, this.sqlp, this.conn);
            minBigDecimalVal = new BigDecimal(sminStringVal);
            minBigintVal = new Long(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minBigDecimalVal, -5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Bigint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orBigintVal = this.rs.getObject(1);
            String srBigintVal = new String(orBigintVal.toString());
            this.msg.addOutputMsg(sminStringVal, srBigintVal);
            if (srBigintVal.trim().equals(sminStringVal.trim())) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject70() throws Exception {
        Float maxRealVal = null;
        BigDecimal maxBigDecimalVal = null;
        Float rRealVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Real_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Integer to be Updated in Real table");
            smaxStringVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxBigDecimalVal = new BigDecimal(smaxStringVal);
            maxRealVal = new Float(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxBigDecimalVal, 7);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Real_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            Object orRealVal = this.rs.getObject(1);
            rRealVal = new Float(orRealVal.toString());
            this.msg.addOutputMsg("" + maxRealVal, "" + rRealVal);
            if (rRealVal.compareTo(maxRealVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject71() throws Exception {
        Float minRealVal = null;
        BigDecimal minBigDecimalVal = null;
        Float rRealVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Real_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Integer to be Updated in Real table");
            sminStringVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            minBigDecimalVal = new BigDecimal(sminStringVal);
            minRealVal = new Float(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minBigDecimalVal, 7);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Real_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orRealVal = this.rs.getObject(1);
            rRealVal = new Float(orRealVal.toString());
            this.msg.addOutputMsg("" + minRealVal, "" + rRealVal);
            if (rRealVal.compareTo(minRealVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject72() throws Exception {
        Double maxFloatVal = null;
        BigDecimal maxBigDecimalVal = null;
        Double rFloatVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Float_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Decimal to be Updated  in Float");
            smaxStringVal = this.rsSch.extractVal("Decimal_Tab", 1, this.sqlp, this.conn);
            maxBigDecimalVal = new BigDecimal(smaxStringVal);
            maxFloatVal = new Double(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxBigDecimalVal, 6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Float_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rFloatVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxFloatVal, "" + rFloatVal);
            if (rFloatVal.equals(maxFloatVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject73() throws Exception {
        Double minFloatVal = null;
        BigDecimal minBigDecimalVal = null;
        Double rFloatVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Float_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Minimum Value of Decimal to be Updated in Float table");
            sminStringVal = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            minBigDecimalVal = new BigDecimal(sminStringVal);
            minFloatVal = new Double(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minBigDecimalVal, 6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Float_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rFloatVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minFloatVal, "" + rFloatVal);
            if (rFloatVal.equals(minFloatVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject74() throws Exception {
        Double maxDoubleVal = null;
        BigDecimal maxBigDecimalVal = null;
        Double rDoubleVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Double_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Double to be Updated");
            smaxStringVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            maxBigDecimalVal = new BigDecimal(smaxStringVal);
            maxDoubleVal = new Double(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxBigDecimalVal, 8);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Double_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rDoubleVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + maxDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(maxDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject75() throws Exception {
        Double minDoubleVal = null;
        BigDecimal minBigDecimalVal = null;
        Double rDoubleVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Double_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Double to be Updated");
            sminStringVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            minBigDecimalVal = new BigDecimal(sminStringVal);
            minDoubleVal = new Double(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minBigDecimalVal, 8);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Double_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDoubleVal = (Double)this.rs.getObject(1);
            this.msg.addOutputMsg("" + minDoubleVal, "" + rDoubleVal);
            if (rDoubleVal.equals(minDoubleVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject76() throws Exception {
        BigDecimal maxDecimalVal = null;
        BigDecimal rDecimalVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Decimal_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Decimal to be Updated");
            smaxStringVal = this.rsSch.extractVal("Decimal_Tab", 1, this.sqlp, this.conn);
            maxDecimalVal = new BigDecimal(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxDecimalVal, 3, 15);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDecimalVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg(String.valueOf(maxDecimalVal), String.valueOf(rDecimalVal));
            if (rDecimalVal.compareTo(maxDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject77() throws Exception {
        BigDecimal minDecimalVal = null;
        BigDecimal rDecimalVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Decimal_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Decimal to be Updated");
            sminStringVal = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            minDecimalVal = new BigDecimal(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minDecimalVal, 3, 15);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Decimal_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orDecimalVal = this.rs.getObject(1);
            rDecimalVal = new BigDecimal(orDecimalVal.toString());
            this.msg.addOutputMsg(String.valueOf(minDecimalVal), String.valueOf(rDecimalVal));
            if (rDecimalVal.compareTo(minDecimalVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject78() throws Exception {
        BigDecimal maxNumericVal = null;
        BigDecimal rNumericVal = null;
        String smaxStringVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Min_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Maximum Value of Numeric to be Updated");
            smaxStringVal = this.rsSch.extractVal("Numeric_Tab", 1, this.sqlp, this.conn);
            maxNumericVal = new BigDecimal(smaxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxNumericVal, 2, 15);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Min_Val_Query = this.sqlp.getProperty("Numeric_Query_Min", "");
            this.msg.setMsg(Min_Val_Query);
            this.rs = this.stmt.executeQuery(Min_Val_Query);
            this.rs.next();
            rNumericVal = (BigDecimal)this.rs.getObject(1);
            this.msg.addOutputMsg(String.valueOf(maxNumericVal), String.valueOf(rNumericVal));
            if (rNumericVal.compareTo(maxNumericVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject79() throws Exception {
        BigDecimal minNumericVal = null;
        BigDecimal rNumericVal = null;
        String sminStringVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Minimum Value of Numeric to be Updated");
            sminStringVal = this.rsSch.extractVal("Numeric_Tab", 2, this.sqlp, this.conn);
            minNumericVal = new BigDecimal(sminStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)minNumericVal, 2, 15);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            Object orNumericVal = this.rs.getObject(1);
            rNumericVal = new BigDecimal(orNumericVal.toString());
            this.msg.addOutputMsg(String.valueOf(minNumericVal), String.valueOf(rNumericVal));
            if (rNumericVal.compareTo(minNumericVal) == 0) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetObject82() throws Exception {
        String maxStringVal = null;
        String rStringVal = null;
        BigDecimal maxBigDecimalVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Char_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of String to be Updated");
            maxStringVal = this.rsSch.extractVal("Decimal_Tab", 1, this.sqlp, this.conn);
            maxBigDecimalVal = new BigDecimal(maxStringVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setObject(1, (Object)maxBigDecimalVal, 1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getObject(1).toString();
            rStringVal = rStringVal.trim();
            maxStringVal = maxStringVal.trim();
            this.msg.addOutputMsg(maxStringVal, rStringVal);
            if (rStringVal.equals(maxStringVal)) {
                this.msg.setMsg("setObject Method sets the designated parameter with the Object");
            } else {
                this.msg.printTestError("setObject Method does not set the designated parameter with the Object", "test setObject Failed");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setObject is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setObject is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

