/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.foreignMsgTopic;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.BytesMessageTestImpl;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MapMessageTestImpl;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import com.sun.ts.tests.jms.common.ObjectMessageTestImpl;
import com.sun.ts.tests.jms.common.StreamMessageTestImpl;
import com.sun.ts.tests.jms.common.TextMessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;

public class ForeignMsgTopicTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.foreignMsgTopic.ForeignMsgTopicTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;
    boolean testBoolean = true;
    byte testByte = (byte)100;
    char testChar = (char)97;
    int testInt = 10;
    Object testObject = new Double(3.141);
    String testString = "java";

    public static void main(String[] args) {
        ForeignMsgTopicTests theTests = new ForeignMsgTopicTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void sendReceiveBytesMsgTopicTest() throws Exception {
        boolean pass = true;
        try {
            BytesMessageTestImpl messageSent = null;
            BytesMessage messageReceived = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = new BytesMessageTestImpl();
            this.logTrace("Setting test values in message");
            long bodyLength = 22L;
            BytesMessageTestImpl messageSentImpl = messageSent;
            messageSentImpl.setBodyLength(bodyLength);
            messageSent.writeBoolean(this.testBoolean);
            messageSent.writeByte(this.testByte);
            messageSent.writeChar(this.testChar);
            messageSent.writeInt(this.testInt);
            messageSent.writeObject(this.testObject);
            messageSent.writeUTF(this.testString);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveBytesMsgTopicTest");
            this.logTrace("Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            this.logTrace("Check received message");
            if (messageReceived.readBoolean() == this.testBoolean) {
                this.logTrace("Received correct boolean value");
            } else {
                this.logMsg("incorrect boolean value -- BAD");
                pass = false;
            }
            if (messageReceived.readByte() == this.testByte) {
                this.logTrace("Received correct byte value");
            } else {
                this.logMsg("incorrect byte value -- BAD");
                pass = false;
            }
            if (messageReceived.readChar() == this.testChar) {
                this.logTrace("Received correct char value");
            } else {
                this.logMsg("incorrect char value -- BAD");
                pass = false;
            }
            if (messageReceived.readInt() == this.testInt) {
                this.logTrace("Received correct int value");
            } else {
                this.logMsg("incorrect int value -- BAD");
                pass = false;
            }
            if (messageReceived.readDouble() == ((Double)this.testObject).doubleValue()) {
                this.logTrace("Received correct object");
            } else {
                this.logMsg("incorrect object -- BAD");
                pass = false;
            }
            if (messageReceived.readUTF().equals(this.testString)) {
                this.logTrace("Received correct String");
            } else {
                this.logMsg("incorrect string -- BAD");
                pass = false;
            }
            if (!pass) {
                this.logMsg("Test failed -- see above");
                throw new Exception();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveBytesMsgTopicTest");
        }
    }

    public void sendReceiveMsgTopicTest() throws Exception {
        try {
            MessageTestImpl messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("Creating 1 message");
            messageSent = new MessageTestImpl();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveMsgTopicTest");
            this.logMsg("sending: " + (Message)messageSent);
            this.logMsg("Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.logMsg("Receiving message");
            messageReceived = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logMsg("received: " + messageReceived);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveMsgTopicTest");
        }
    }

    public void sendReceiveMapMsgTopicTest() throws Exception {
        boolean pass = true;
        try {
            MapMessageTestImpl messageSent = null;
            MapMessage messageReceived = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = new MapMessageTestImpl();
            this.logTrace("Setting test values in message");
            messageSent.setBoolean("TestBoolean", this.testBoolean);
            messageSent.setByte("TestByte", this.testByte);
            messageSent.setChar("TestChar", this.testChar);
            messageSent.setInt("TestInt", this.testInt);
            messageSent.setObject("TestDouble", this.testObject);
            messageSent.setString("TestString", this.testString);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveMapMsgTopicTest");
            this.logTrace("Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            this.logTrace("Check received message");
            if (messageReceived.getBoolean("TestBoolean") == this.testBoolean) {
                this.logTrace("Received correct boolean value");
            } else {
                this.logMsg("incorrect boolean value -- BAD");
                pass = false;
            }
            if (messageReceived.getByte("TestByte") == this.testByte) {
                this.logTrace("Received correct byte value");
            } else {
                this.logMsg("incorrect byte value -- BAD");
                pass = false;
            }
            if (messageReceived.getChar("TestChar") == this.testChar) {
                this.logTrace("Received correct char value");
            } else {
                this.logMsg("incorrect char value -- BAD");
                pass = false;
            }
            if (messageReceived.getInt("TestInt") == this.testInt) {
                this.logTrace("Received correct int value");
            } else {
                this.logMsg("incorrect int value -- BAD");
                pass = false;
            }
            if (messageReceived.getDouble("TestDouble") == ((Double)this.testObject).doubleValue()) {
                this.logTrace("Received correct object");
            } else {
                this.logMsg("incorrect object -- BAD");
                pass = false;
            }
            if (messageReceived.getString("TestString").equals(this.testString)) {
                this.logTrace("Received correct String");
            } else {
                this.logMsg("incorrect string -- BAD");
                pass = false;
            }
            if (!pass) {
                this.logMsg("Test failed -- see above");
                throw new Exception();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveMapMsgTopicTest");
        }
    }

    public void sendReceiveObjectMsgTopicTest() throws Exception {
        try {
            ObjectMessageTestImpl messageSent = null;
            ObjectMessage messageReceived = null;
            String text = "test";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("Creating 1 message");
            messageSent = new ObjectMessageTestImpl();
            messageSent.setObject((Serializable)((Object)text));
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveObjectMsgTopicTest");
            this.logMsg("Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.logMsg("Receiving message");
            messageReceived = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            if (!((String)((Object)messageReceived.getObject())).equals(text)) {
                throw new Exception("Did not receive correct message");
            }
            this.logMsg("Received correct object");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveObjectMsgTopicTest");
        }
    }

    public void sendReceiveStreamMsgTopicTest() throws Exception {
        boolean pass = true;
        try {
            StreamMessageTestImpl messageSent = null;
            StreamMessage messageReceived = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("Creating 1 message");
            messageSent = new StreamMessageTestImpl();
            this.logTrace("Setting test values in message");
            messageSent.writeBoolean(this.testBoolean);
            messageSent.writeByte(this.testByte);
            messageSent.writeChar(this.testChar);
            messageSent.writeInt(this.testInt);
            messageSent.writeObject(this.testObject);
            messageSent.writeString(this.testString);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveStreamMsgTopicTest");
            this.logMsg("Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.logMsg("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            this.logTrace("Check received message");
            if (messageReceived.readBoolean() == this.testBoolean) {
                this.logTrace("Received correct boolean value");
            } else {
                this.logMsg("incorrect boolean value -- BAD");
                pass = false;
            }
            if (messageReceived.readByte() == this.testByte) {
                this.logTrace("Received correct byte value");
            } else {
                this.logMsg("incorrect byte value -- BAD");
                pass = false;
            }
            if (messageReceived.readChar() == this.testChar) {
                this.logTrace("Received correct char value");
            } else {
                this.logMsg("incorrect char value -- BAD");
                pass = false;
            }
            if (messageReceived.readInt() == this.testInt) {
                this.logTrace("Received correct int value");
            } else {
                this.logMsg("incorrect int value -- BAD");
                pass = false;
            }
            if (messageReceived.readDouble() == ((Double)this.testObject).doubleValue()) {
                this.logTrace("Received correct object");
            } else {
                this.logMsg("incorrect object -- BAD");
                pass = false;
            }
            if (messageReceived.readString().equals(this.testString)) {
                this.logTrace("Received correct String");
            } else {
                this.logMsg("incorrect string -- BAD");
                pass = false;
            }
            if (!pass) {
                this.logMsg("Test failed -- see above");
                throw new Exception();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveStreamMsgTopicTest");
        }
    }

    public void sendReceiveTextMsgTopicTest() throws Exception {
        try {
            TextMessageTestImpl messageSent = null;
            TextMessage messageReceived = null;
            String text = "test";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logMsg("Creating 1 message");
            messageSent = new TextMessageTestImpl();
            messageSent.setText(text);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveTextMsgTopicTest");
            this.logMsg("Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.logMsg("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            if (!messageReceived.getText().equals(text)) {
                throw new Exception("Did not receive correct message");
            }
            this.logMsg("Received correct text");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveTextMsgTopicTest");
        }
    }

    public void sendSetsJMSDestinationTopicTest() throws Exception {
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.logMsg("Creating 1 message");
            MessageTestImpl message = new MessageTestImpl();
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "sendSetsJMSDestinationTopicTest");
            message.setJMSDestination(null);
            this.logMsg("Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)message);
            this.logTrace("Check header value");
            if (!((Topic)message.getJMSDestination()).getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                throw new Exception("Header not set correctly");
            }
            this.logTrace("Header set correctly");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendSetsJMSDestinationTopicTest");
        }
    }

    public void sendSetsJMSExpirationTopicTest() throws Exception {
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.logMsg("Creating 1 message");
            MessageTestImpl message = new MessageTestImpl();
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "sendSetsJMSExpirationTopicTest");
            this.logTrace("Set JMSExpiration to 9999");
            message.setJMSExpiration(9999L);
            this.logMsg("Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)message);
            long mode = message.getJMSExpiration();
            this.logTrace("Check header value");
            if (mode == 9999L) {
                this.logTrace("JMSExpiration for message is " + mode);
                throw new Exception("Header not set correctly");
            }
            this.logTrace("Header set correctly");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendSetsJMSExpirationTopicTest");
        }
    }

    public void sendSetsJMSPriorityTopicTest() throws Exception {
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.logMsg("Creating 1 message");
            MessageTestImpl message = new MessageTestImpl();
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "sendSetsJMSPriorityTopicTest");
            this.logTrace("Set JMSPriority to 9999");
            message.setJMSPriority(9999);
            this.logMsg("Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)message);
            int mode = message.getJMSPriority();
            this.logTrace("Check header value");
            if (mode == 9999) {
                this.logTrace("JMSPriority for message is " + mode);
                throw new Exception("Header not set correctly");
            }
            this.logTrace("Header set correctly: " + mode);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendSetsJMSPriorityTopicTest");
        }
    }

    public void sendSetsJMSMessageIDTopicTest() throws Exception {
        try {
            String id0 = "foo";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.logMsg("Creating 1 message");
            MessageTestImpl message = new MessageTestImpl();
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "sendSetsJMSMessageIDTopicTest");
            this.logTrace("Set JMSMessageID to \"" + id0 + "\"");
            message.setJMSMessageID(id0);
            this.logMsg("Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)message);
            String id1 = message.getJMSMessageID();
            this.logTrace("Check header value");
            if (id1.equals(id0)) {
                this.logTrace("JMSMessageID for message is " + id1);
                throw new Exception("Header not set correctly");
            }
            this.logTrace("Header set correctly: " + id1);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendSetsJMSMessageIDTopicTest");
        }
    }

    public void sendSetsJMSTimestampTopicTest() throws Exception {
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.logMsg("Creating 1 message");
            MessageTestImpl message = new MessageTestImpl();
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "sendSetsJMSTimestampTopicTest");
            this.logTrace("Set JMSTimestamp to 9999");
            message.setJMSTimestamp(9999L);
            this.logMsg("Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)message);
            long mode = message.getJMSTimestamp();
            this.logTrace("Check header value");
            if (mode == 9999L) {
                this.logTrace("JMSTimestamp for message is " + mode);
                throw new Exception("Header not set correctly");
            }
            this.logTrace("Header set correctly: " + mode);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendSetsJMSTimestampTopicTest");
        }
    }
}

